/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mock.issue.search;

import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.project.Project;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericValue;

public class MockSearchContext
implements SearchContext {
    private List<Project> projects;

    public MockSearchContext() {
        this.projects = Collections.emptyList();
    }

    public MockSearchContext(Project ... projects) {
        this.projects = new ArrayList<Project>();
        this.projects.addAll(Arrays.asList(projects));
    }

    public boolean isForAnyProjects() {
        return this.projects.isEmpty();
    }

    public boolean isForAnyIssueTypes() {
        throw new UnsupportedOperationException();
    }

    public boolean isSingleProjectContext() {
        return 1 == this.projects.size();
    }

    public Project getSingleProject() {
        return this.projects.get(0);
    }

    public List getProjectCategoryIds() {
        throw new UnsupportedOperationException();
    }

    public List<Long> getProjectIds() {
        return Lists.transform(this.projects, (Function)new Function<Project, Long>(){

            public Long apply(@Nullable Project project) {
                return project.getId();
            }
        });
    }

    public GenericValue getOnlyProject() {
        return this.getSingleProject().getGenericValue();
    }

    public List<String> getIssueTypeIds() {
        throw new UnsupportedOperationException();
    }

    public List<IssueContext> getAsIssueContexts() {
        throw new UnsupportedOperationException();
    }

    public void verify() {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public List<Project> getProjects() {
        return Lists.newArrayList(this.projects);
    }

    @Nonnull
    public List<IssueType> getIssueTypes() {
        throw new UnsupportedOperationException();
    }
}

