/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mock.ofbiz;

import com.atlassian.jira.propertyset.OfBizPropertyEntryStore;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class MockOfBizPropertyEntryStore
implements OfBizPropertyEntryStore {
    private final Map<EntityNameAndId, Map<String, OfBizPropertyEntryStore.PropertyEntry>> propertyMapForEntity = new ConcurrentHashMap<EntityNameAndId, Map<String, OfBizPropertyEntryStore.PropertyEntry>>();

    @Nonnull
    public Collection<String> getKeys(String entityName, long entityId) {
        Map<String, OfBizPropertyEntryStore.PropertyEntry> propertyMap = this.getPropertyMap(entityName, entityId);
        if (propertyMap == null) {
            return ImmutableSet.of();
        }
        return ImmutableSet.copyOf(propertyMap.keySet());
    }

    @Nonnull
    public Collection<String> getKeys(String entityName, long entityId, int type) {
        Map<String, OfBizPropertyEntryStore.PropertyEntry> propertyMap = this.getPropertyMap(entityName, entityId);
        if (propertyMap == null) {
            return ImmutableSet.of();
        }
        return ImmutableSet.copyOf(Maps.filterValues(propertyMap, entry -> entry.getType() == type).keySet());
    }

    public boolean exists(String entityName, long entityId, String propertyKey) {
        return this.getEntry(entityName, entityId, propertyKey) != null;
    }

    public int getType(String entityName, long entityId, String propertyKey) {
        OfBizPropertyEntryStore.PropertyEntry entry = this.getEntry(entityName, entityId, propertyKey);
        return entry != null ? entry.getType() : 0;
    }

    public OfBizPropertyEntryStore.PropertyEntry getEntry(String entityName, long entityId, String propertyKey) {
        return this.getPropertyMap(entityName, entityId).get(propertyKey);
    }

    public void setEntry(String entityName, long entityId, String propertyKey, int type, Object value) {
        this.getPropertyMap(entityName, entityId).put(propertyKey, new MockPropertyEntry(type, value));
    }

    public void removeEntry(String entityName, long entityId, String propertyKey) {
        this.getPropertyMap(entityName, entityId).remove(propertyKey);
    }

    public void removePropertySet(String entityName, long entityId) {
        this.propertyMapForEntity.remove(new EntityNameAndId(entityName, entityId));
    }

    private Map<String, OfBizPropertyEntryStore.PropertyEntry> getPropertyMap(String entityName, long entityId) {
        EntityNameAndId entity = new EntityNameAndId(entityName, entityId);
        HashMap propertyMap = this.propertyMapForEntity.get(entity);
        if (propertyMap == null) {
            propertyMap = Maps.newHashMap();
            this.propertyMapForEntity.put(entity, propertyMap);
        }
        return propertyMap;
    }

    static class MockPropertyEntry
    implements OfBizPropertyEntryStore.PropertyEntry {
        private final int type;
        private final Object value;

        MockPropertyEntry(int type, @Nullable Object value) {
            this.type = type;
            this.value = value;
        }

        public int getType() {
            return this.type;
        }

        public Object getValue() {
            return this.value;
        }

        @Nullable
        public Object getValue(int type) {
            return this.value;
        }

        public boolean equals(Object o) {
            return o instanceof MockPropertyEntry && this.equals((MockPropertyEntry)o);
        }

        private boolean equals(MockPropertyEntry other) {
            return this.type == other.type && Objects.equal((Object)this.value, (Object)other.value);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.type, this.value});
        }

        public String toString() {
            return "MockPropertyEntry[type=" + this.type + ",value=" + this.value + ']';
        }
    }

    static class EntityNameAndId {
        private final String entityName;
        private final Long entityId;

        EntityNameAndId(String entityName, long entityId) {
            this.entityName = (String)Assertions.notNull((String)"entityName", (Object)entityName);
            this.entityId = (Long)Assertions.notNull((String)"entityId", (Object)entityId);
        }

        String getEntityName() {
            return this.entityName;
        }

        Long getEntityId() {
            return this.entityId;
        }

        public boolean equals(Object o) {
            return o instanceof EntityNameAndId && this.equals((EntityNameAndId)o);
        }

        private boolean equals(EntityNameAndId other) {
            return this.entityId.equals(other.entityId) && this.entityName.equals(other.entityName);
        }

        public int hashCode() {
            return 31 * this.entityId.hashCode() + this.entityName.hashCode();
        }

        public String toString() {
            return "EntityNameAndId[entityName=" + this.entityName + ",entityId=" + this.entityId + ']';
        }
    }
}

