/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mock.ofbiz.matchers;

import com.atlassian.jira.mock.ofbiz.matchers.EntityConditionMatcher;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityOperator;

public class EntityConditionListMatcher
extends BaseMatcher<EntityConditionList> {
    private final EntityOperator expectedOperator;
    private final Matcher<?> conditions;

    private EntityConditionListMatcher(EntityConditionList conditions) {
        this.expectedOperator = conditions.getOperator();
        int size = conditions.getConditionListSize();
        ArrayList<Matcher<? extends EntityCondition>> matchers = new ArrayList<Matcher<? extends EntityCondition>>(size);
        for (int i = 0; i < size; ++i) {
            matchers.add(EntityConditionMatcher.entityCondition(conditions.getCondition(i)));
        }
        this.conditions = new IsIterableContainingInAnyOrder(matchers);
    }

    public static EntityConditionListMatcher entityConditionList(EntityConditionList expected) {
        return new EntityConditionListMatcher(expected);
    }

    public boolean matches(Object item) {
        return item instanceof EntityConditionList && this.matches((EntityConditionList)item);
    }

    private boolean matches(EntityConditionList other) {
        return this.expectedOperator.equals((Object)other.getOperator()) && this.conditions.matches(EntityConditionListMatcher.toList(other));
    }

    public void describeTo(Description description) {
        description.appendText("Entity condition list joined with '").appendText(this.expectedOperator.getCode()).appendText("' and ").appendDescriptionOf(this.conditions);
    }

    private static List<EntityCondition> toList(EntityConditionList conditions) {
        ArrayList<EntityCondition> list = new ArrayList<EntityCondition>(conditions.getConditionListSize());
        Iterator iter = conditions.getConditionIterator();
        while (iter.hasNext()) {
            list.add((EntityCondition)iter.next());
        }
        return list;
    }
}

