/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mock.ofbiz.matchers;

import com.google.common.base.Objects;
import org.hamcrest.Description;
import org.mockito.ArgumentMatcher;
import org.ofbiz.core.entity.EntityExpr;

public class EntityExprMatcher
extends ArgumentMatcher<EntityExpr> {
    private final EntityExpr expected;

    private EntityExprMatcher(EntityExpr expected) {
        this.expected = expected;
    }

    public static EntityExprMatcher entityExpr(EntityExpr expected) {
        return new EntityExprMatcher(expected);
    }

    public boolean matches(Object o) {
        return o instanceof EntityExpr && this.matches((EntityExpr)o);
    }

    private boolean matches(EntityExpr other) {
        return Objects.equal((Object)this.expected.getOperator(), (Object)other.getOperator()) && this.expected.isLUpper() == other.isLUpper() && this.expected.isRUpper() == other.isRUpper() && Objects.equal((Object)this.expected.getLhs(), (Object)other.getLhs()) && Objects.equal((Object)this.expected.getRhs(), (Object)other.getRhs());
    }

    public void describeTo(Description description) {
        description.appendText("entity expression [");
        EntityExprMatcher.describeArgumentTo(description, this.expected.isLUpper(), this.expected.getLhs());
        description.appendText(" ").appendText(this.expected.getOperator().getCode()).appendText(" ");
        EntityExprMatcher.describeArgumentTo(description, this.expected.isRUpper(), this.expected.getRhs());
        description.appendText("]");
    }

    private static void describeArgumentTo(Description description, boolean upper, Object value) {
        if (upper) {
            description.appendText("UPPER(");
        }
        description.appendValue(value);
        if (upper) {
            description.appendText(")");
        }
    }
}

