/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mock.ofbiz.matchers;

import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hamcrest.Description;
import org.junit.Assert;
import org.mockito.ArgumentMatcher;
import org.ofbiz.core.entity.EntityFieldMap;
import org.ofbiz.core.entity.EntityOperator;

public class EntityFieldMapMatcher
extends ArgumentMatcher<EntityFieldMap> {
    private final EntityFieldMap expected;

    private EntityFieldMapMatcher(EntityFieldMap expected) {
        this.expected = expected;
    }

    public static EntityFieldMapMatcher entityFieldMap(Map<String, ?> expected) {
        return new EntityFieldMapMatcher(new EntityFieldMap(expected, EntityOperator.AND));
    }

    public static EntityFieldMapMatcher entityFieldMap(EntityFieldMap expected) {
        return new EntityFieldMapMatcher(expected);
    }

    public boolean matches(Object o) {
        return o instanceof EntityFieldMap && this.matches((EntityFieldMap)o);
    }

    private boolean matches(EntityFieldMap other) {
        return Objects.equal((Object)this.expected.getOperator(), (Object)other.getOperator()) && EntityFieldMapMatcher.toMap(this.expected).equals(EntityFieldMapMatcher.toMap(other));
    }

    public void describeTo(Description description) {
        description.appendValue((Object)this.expected);
    }

    private static Map<String, Object> toMap(EntityFieldMap entityFieldMap) {
        HashMap map = Maps.newHashMap();
        Iterator iter = entityFieldMap.getFieldEntryIterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            if (map.put(entry.getKey(), entry.getValue()) == null) continue;
            Assert.fail((String)("EntityFieldMap has multiple values for field '" + (String)entry.getKey() + "': " + entityFieldMap));
        }
        return map;
    }
}

