/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mock.plugin;

import com.atlassian.jira.mock.plugin.MockResources;
import com.atlassian.plugin.InstallationMode;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginDependencies;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.plugin.PluginState;
import com.atlassian.plugin.Resourced;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.elements.ResourceLocation;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;

public class MockPlugin
implements Plugin {
    private int pluginsVersion;
    private String name;
    private String key;
    private boolean enabledByDefault;
    private PluginInformation pluginInformation;
    private boolean enabled;
    private boolean systemPlugin;
    private PluginState pluginState;
    private ClassLoader loader;
    private Map<String, ModuleDescriptor<?>> descriptors = Maps.newLinkedHashMap();
    private MockResources resources = new MockResources();
    private final Map<String, String> resourceContent = Maps.newHashMap();

    public MockPlugin() {
    }

    public MockPlugin(String key) {
        this.key = key;
    }

    public MockPlugin(String name, String key, PluginInformation pluginInformation, PluginState pluginState) {
        this.name = name;
        this.key = key;
        this.pluginInformation = pluginInformation;
        this.pluginState = pluginState;
    }

    public MockPlugin(String name, String key, PluginInformation pluginInformation) {
        this.name = name;
        this.key = key;
        this.pluginInformation = pluginInformation;
    }

    public int getPluginsVersion() {
        return this.pluginsVersion;
    }

    public void setPluginsVersion(int version) {
        this.pluginsVersion = version;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getI18nNameKey() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void setI18nNameKey(String i18nNameKey) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void addModuleDescriptor(ModuleDescriptor<?> moduleDescriptor) {
        this.descriptors.put(moduleDescriptor.getKey(), moduleDescriptor);
    }

    public Collection<ModuleDescriptor<?>> getModuleDescriptors() {
        return ImmutableList.copyOf(this.descriptors.values());
    }

    public ModuleDescriptor<?> getModuleDescriptor(String key) {
        return this.descriptors.get(key);
    }

    public <M> List<ModuleDescriptor<M>> getModuleDescriptorsByModuleClass(Class<M> moduleClass) {
        ArrayList result = Lists.newArrayList();
        for (ModuleDescriptor<?> descriptor : this.descriptors.values()) {
            if (!descriptor.getModuleClass().equals(moduleClass)) continue;
            result.add(descriptor);
        }
        return result;
    }

    public InstallationMode getInstallationMode() {
        return InstallationMode.LOCAL;
    }

    public boolean isEnabledByDefault() {
        return this.enabledByDefault;
    }

    public void setEnabledByDefault(boolean enabledByDefault) {
        this.enabledByDefault = enabledByDefault;
    }

    public PluginInformation getPluginInformation() {
        return this.pluginInformation;
    }

    public void setPluginInformation(PluginInformation pluginInformation) {
        this.pluginInformation = pluginInformation;
    }

    public void setResources(Resourced resources) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public PluginState getPluginState() {
        return this.pluginState;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isSystemPlugin() {
        return this.systemPlugin;
    }

    public void setSystemPlugin(boolean system) {
        this.systemPlugin = system;
    }

    public boolean containsSystemModule() {
        return false;
    }

    public boolean isBundledPlugin() {
        return false;
    }

    public Date getDateLoaded() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Date getDateInstalled() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isUninstallable() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isDeleteable() {
        return false;
    }

    public boolean isDynamicallyLoaded() {
        return false;
    }

    public <T> Class<T> loadClass(String clazz, Class<?> callingClass) throws ClassNotFoundException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public MockPlugin setClassLoader(ClassLoader loader) {
        this.loader = loader;
        return this;
    }

    public URL getResource(String path) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public InputStream getResourceAsStream(String name) {
        String resource = this.resourceContent.get(name);
        if (resource != null) {
            try {
                return IOUtils.toInputStream((String)resource, (String)"UTF-8");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void close() {
    }

    public void install() {
    }

    public void uninstall() {
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void disable() {
        this.setEnabled(false);
    }

    public Set<String> getRequiredPlugins() {
        return Collections.emptySet();
    }

    public Set<String> getActivePermissions() {
        return Collections.emptySet();
    }

    public boolean hasAllPermissions() {
        return false;
    }

    public void resolve() {
    }

    @Nullable
    public Date getDateEnabling() {
        return null;
    }

    @Nullable
    public Date getDateEnabled() {
        return null;
    }

    public int compareTo(Plugin o) {
        return this.getKey().compareTo(o.getKey());
    }

    public List<ResourceDescriptor> getResourceDescriptors() {
        return this.resources.getAll();
    }

    public List<ResourceDescriptor> getResourceDescriptors(String type) {
        return this.resources.getAllByType(type);
    }

    public ResourceDescriptor getResourceDescriptor(String type, String name) {
        return this.resources.getResourceDescriptor(type, name);
    }

    public ResourceLocation getResourceLocation(String type, String name) {
        return this.resources.getResourceLocation(type, name);
    }

    public PluginArtifact getPluginArtifact() {
        return null;
    }

    public String toString() {
        return String.format("Plugin(%s)", this.key);
    }

    public MockPlugin resource(String name, String value) {
        this.resourceContent.put(name, value);
        return this;
    }

    public ResourceDescriptor createI18nResource(String name, String location) {
        return this.resources.createI18nResource(name, location);
    }

    public ResourceDescriptor createHelpResource(String name, String location) {
        return this.resources.createHelpResource(name, location);
    }

    @Nonnull
    public PluginDependencies getDependencies() {
        return new PluginDependencies(Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
    }

    public MockPlugin addResourceDescriptor(ResourceDescriptor resourceDescriptor, String contents) {
        this.addResourceDescriptor(resourceDescriptor);
        this.resource(resourceDescriptor.getLocation(), contents);
        return this;
    }

    public void addResourceDescriptor(ResourceDescriptor resourceDescriptor) {
        this.resources.add(resourceDescriptor);
    }
}

