/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mock.user;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserHistoryManager;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;

public class MockUserHistoryManager
implements UserHistoryManager {
    private List<UserHistoryItem> userHistoryItems;
    private List<String> addedUsers;

    public MockUserHistoryManager() {
        this(Collections.emptyList());
    }

    public MockUserHistoryManager(List<UserHistoryItem> userHistoryItems) {
        this.userHistoryItems = userHistoryItems;
        this.addedUsers = new LinkedList<String>();
    }

    public void addUserToHistory(UserHistoryItem.Type type, ApplicationUser user, ApplicationUser entity) {
        this.addedUsers.add(entity.getUsername());
    }

    public void addItemToHistory(UserHistoryItem.Type type, ApplicationUser user, String entityId) {
        this.addedUsers.add(entityId);
    }

    public void addItemToHistory(UserHistoryItem.Type type, ApplicationUser user, String entityId, String data) {
        this.addedUsers.add(entityId);
    }

    public boolean hasHistory(UserHistoryItem.Type type, ApplicationUser user) {
        return false;
    }

    public List<UserHistoryItem> getHistory(UserHistoryItem.Type type, ApplicationUser user) {
        return this.userHistoryItems;
    }

    public void removeHistoryForUser(@Nonnull ApplicationUser user) {
    }

    public List<String> getAddedUsers() {
        return this.addedUsers;
    }
}

