/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.version;

import com.atlassian.fugue.Option;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comparator.NullComparator;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.mock.project.MockVersion;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.CustomFieldWithVersionUsage;
import com.atlassian.jira.project.version.DeleteVersionWithCustomFieldParameters;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class MockVersionManager
implements VersionManager {
    private final Map<Long, Version> versions = new HashMap<Long, Version>();

    public Version createVersion(String name, Date releaseDate, String description, Long projectId, Long scheduleAfterVersion) throws CreateException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Version createVersion(String name, Date startDate, Date releaseDate, String description, Long projectId, Long scheduleAfterVersion) throws CreateException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Version createVersion(String name, Date startDate, Date releaseDate, String description, Long projectId, Long scheduleAfterVersion, boolean released) throws CreateException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Version moveToStartVersionSequence(Version version) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Version increaseVersionSequence(Version version) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Version decreaseVersionSequence(Version version) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Version moveToEndVersionSequence(Version version) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Version moveVersionAfter(Version version, Long scheduleAfterVersion) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void deleteVersion(Version version) {
        this.versions.remove(version.getId());
    }

    public void deleteVersion(ApplicationUser applicationUser, Version versionToDelete, Option<Version> affectsSwapVersion, Option<Version> fixSwapVersion) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void deleteAllVersions(@Nonnull Long projectId) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Version update(Version version) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Version editVersionDetails(Version version, String name, String description) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isDuplicateName(Version version, String name) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Version releaseVersion(Version version, boolean release) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Collection<Version> releaseVersions(Collection<Version> versions, boolean release) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void moveIssuesToNewVersion(List issues, Version currentVersion, Version swapToVersion) throws IndexException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void archiveVersions(String[] idsToArchive, String[] idsToUnarchive) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Version archiveVersion(Version version, boolean archive) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Collection<Version> getVersionsUnarchived(Long projectId) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Collection<Version> getVersionsArchived(Project project) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Version editVersionStartDate(Version version, Date startDate) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Version editVersionReleaseDate(Version version, Date duedate) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Version editVersionStartReleaseDate(Version version, Date startDate, Date releaseDate) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isVersionOverDue(Version version) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public List<Version> getVersions(Long projectId) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public List<Version> getVersions(Long projectId, boolean includeArchived) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public List<Version> getVersions(Project project) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Collection<Version> getVersionsByName(String versionName) {
        ArrayList<Version> versionList = new ArrayList<Version>();
        for (Version version : this.versions.values()) {
            if (!versionName.equals(version.getName())) continue;
            versionList.add(version);
        }
        return versionList;
    }

    public Collection<Version> getVersions(List<Long> ids) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Version getVersion(Long id) {
        return this.versions.get(id);
    }

    public Version getVersion(Long projectId, String versionName) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Collection<Version> getVersionsUnreleased(Long projectId, boolean includeArchived) {
        ArrayList v = Lists.newArrayList();
        for (Version version : this.versions.values()) {
            if (!projectId.equals(version.getProjectId()) || version.isReleased() || version.isArchived() && !includeArchived) continue;
            v.add(version);
        }
        return v;
    }

    public List<Version> getVersionsReleased(Long projectId, boolean includeArchived) {
        ArrayList v = Lists.newArrayList();
        for (Version version : this.versions.values()) {
            if (!projectId.equals(version.getProjectId()) || !version.isReleased() || version.isArchived() && !includeArchived) continue;
            v.add(version);
        }
        return v;
    }

    public Collection<Version> getVersionsReleasedDesc(Long projectId, boolean includeArchived) {
        Collection versions = this.getVersionsReleased(projectId, includeArchived);
        Collections.sort(versions, new Comparator<Version>(){

            @Override
            public int compare(Version a, Version b) {
                return new NullComparator().compare((Object)(a == null ? null : a.getReleaseDate()), (Object)(b == null ? null : b.getReleaseDate()));
            }
        });
        return versions;
    }

    public Collection<Version> getOtherVersions(Version version) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Collection<Version> getOtherUnarchivedVersions(Version version) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Collection<Issue> getIssuesWithFixVersion(Version version) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Collection<Issue> getIssuesWithAffectsVersion(Version version) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Collection<Long> getIssueIdsWithAffectsVersion(@Nonnull Version version) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Collection<Long> getIssueIdsWithFixVersion(@Nonnull Version version) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Collection<Version> getAffectedVersionsFor(Issue issue) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public List<ChangeItemBean> updateIssueAffectsVersions(Issue issue, Collection<Version> newValue) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public List<ChangeItemBean> updateIssueFixVersions(Issue issue, Collection<Version> newValue) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Collection<Version> getFixVersionsFor(Issue issue) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Collection<Version> getAllVersions() {
        return this.versions.values();
    }

    public Collection<Version> getAllVersionsForProjects(Collection<Project> projects, boolean includeArchived) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Collection<Version> getAllVersionsReleased(boolean includeArchived) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Collection<Version> getAllVersionsUnreleased(boolean includeArchived) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void swapVersionForRelatedIssues(ApplicationUser user, Version version, Option<Version> affectsSwapVersion, Option<Version> fixSwapVersion) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void merge(ApplicationUser user, @Nonnull Version versionToDelete, @Nonnull Version versionToMergeTo) {
        this.deleteVersion(versionToDelete);
        this.swapVersionForRelatedIssues(user, versionToDelete, (Option<Version>)Option.option((Object)versionToMergeTo), (Option<Version>)Option.option((Object)versionToMergeTo));
    }

    public void deleteAndRemoveFromIssues(ApplicationUser user, @Nonnull Version versionToRemove) {
        this.deleteVersion(versionToRemove);
        this.swapVersionForRelatedIssues(user, versionToRemove, (Option<Version>)Option.none(), (Option<Version>)Option.none());
    }

    @Nonnull
    public Collection<CustomFieldWithVersionUsage> getCustomFieldsUsing(@Nonnull Version version) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public long getCustomFieldIssuesCount(@Nonnull Version version) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void deleteVersionAndSwap(ApplicationUser applicationUser, DeleteVersionWithCustomFieldParameters parameters) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void add(MockVersion version) {
        this.versions.put(version.getId(), version);
    }
}

