/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security;

import com.atlassian.fugue.Option;
import com.atlassian.jira.permission.MockProjectPermission;
import com.atlassian.jira.permission.ProjectPermission;
import com.atlassian.jira.permission.ProjectPermissionCategory;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.security.plugin.ProjectPermissionTypesManager;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class MockProjectPermissionTypesManager
implements ProjectPermissionTypesManager {
    private static final List<ProjectPermission> SYSTEM_PROJECT_PERMISSIONS = Arrays.asList(new MockProjectPermission("ADMINISTER_PROJECTS", "admin.permissions.PROJECT_ADMIN", "admin.permissions.descriptions.PROJECT_ADMIN", ProjectPermissionCategory.PROJECTS), new MockProjectPermission("BROWSE_PROJECTS", "admin.permissions.BROWSE", "admin.permissions.descriptions.BROWSE", ProjectPermissionCategory.PROJECTS), new MockProjectPermission("VIEW_DEV_TOOLS", "admin.permissions.VIEW_VERSION_CONTROL", "admin.permissions.descriptions.VIEW_VERSION_CONTROL", ProjectPermissionCategory.PROJECTS), new MockProjectPermission("VIEW_READONLY_WORKFLOW", "admin.permissions.VIEW_WORKFLOW_READONLY", "admin.permissions.descriptions.WORKFLOW_VIEW_READONLY", ProjectPermissionCategory.PROJECTS), new MockProjectPermission("CREATE_ISSUES", "admin.permissions.CREATE_ISSUE", "admin.permissions.descriptions.CREATE_ISSUE", ProjectPermissionCategory.ISSUES), new MockProjectPermission("EDIT_ISSUES", "admin.permissions.EDIT_ISSUE", "admin.permissions.descriptions.EDIT_ISSUE", ProjectPermissionCategory.ISSUES), new MockProjectPermission("TRANSITION_ISSUES", "admin.permissions.TRANSITION_ISSUE", "admin.permissions.descriptions.TRANSITION_ISSUE", ProjectPermissionCategory.ISSUES), new MockProjectPermission("SCHEDULE_ISSUES", "admin.permissions.SCHEDULE_ISSUE", "admin.permissions.descriptions.SCHEDULE_ISSUE", ProjectPermissionCategory.ISSUES), new MockProjectPermission("MOVE_ISSUES", "admin.permissions.MOVE_ISSUE", "admin.permissions.descriptions.MOVE_ISSUE", ProjectPermissionCategory.ISSUES), new MockProjectPermission("ASSIGN_ISSUES", "admin.permissions.ASSIGN_ISSUE", "admin.permissions.descriptions.ASSIGN_ISSUE", ProjectPermissionCategory.ISSUES), new MockProjectPermission("ASSIGNABLE_USER", "admin.permissions.ASSIGNABLE_USER", "admin.permissions.descriptions.ASSIGNABLE_USER", ProjectPermissionCategory.ISSUES), new MockProjectPermission("RESOLVE_ISSUES", "admin.permissions.RESOLVE_ISSUE", "admin.permissions.descriptions.RESOLVE_ISSUE", ProjectPermissionCategory.ISSUES), new MockProjectPermission("CLOSE_ISSUES", "admin.permissions.CLOSE_ISSUE", "admin.permissions.descriptions.CLOSE_ISSUE", ProjectPermissionCategory.ISSUES), new MockProjectPermission("MODIFY_REPORTER", "admin.permissions.MODIFY_REPORTER", "admin.permissions.descriptions.MODIFY_REPORTER", ProjectPermissionCategory.ISSUES), new MockProjectPermission("DELETE_ISSUES", "admin.permissions.DELETE_ISSUE", "admin.permissions.descriptions.DELETE_ISSUE", ProjectPermissionCategory.ISSUES), new MockProjectPermission("LINK_ISSUES", "admin.permissions.LINK_ISSUE", "admin.permissions.descriptions.LINK_ISSUE", ProjectPermissionCategory.ISSUES), new MockProjectPermission("SET_ISSUE_SECURITY", "admin.permissions.SET_ISSUE_SECURITY", "admin.permissions.descriptions.SET_ISSUE_SECURITY", ProjectPermissionCategory.ISSUES), new MockProjectPermission("VIEW_VOTERS_AND_WATCHERS", "admin.permissions.VIEW_VOTERS_AND_WATCHERS", "admin.permissions.descriptions.VIEW_VOTERS_AND_WATCHERS", ProjectPermissionCategory.VOTERS_AND_WATCHERS), new MockProjectPermission("MANAGE_WATCHERS", "admin.permissions.MANAGE_WATCHER_LIST", "admin.permissions.descriptions.MANAGE_WATCHER_LIST", ProjectPermissionCategory.VOTERS_AND_WATCHERS), new MockProjectPermission("ADD_COMMENTS", "admin.permissions.COMMENT_ISSUE", "admin.permissions.descriptions.COMMENT_ISSUE", ProjectPermissionCategory.COMMENTS), new MockProjectPermission("EDIT_ALL_COMMENTS", "admin.permissions.COMMENT_EDIT_ALL", "admin.permissions.descriptions.COMMENT_EDIT_ALL", ProjectPermissionCategory.COMMENTS), new MockProjectPermission("EDIT_OWN_COMMENTS", "admin.permissions.COMMENT_EDIT_OWN", "admin.permissions.descriptions.COMMENT_EDIT_OWN", ProjectPermissionCategory.COMMENTS), new MockProjectPermission("DELETE_ALL_COMMENTS", "admin.permissions.COMMENT_DELETE_ALL", "admin.permissions.descriptions.COMMENT_DELETE_ALL", ProjectPermissionCategory.COMMENTS), new MockProjectPermission("DELETE_OWN_COMMENTS", "admin.permissions.COMMENT_DELETE_OWN", "admin.permissions.descriptions.COMMENT_DELETE_OWN", ProjectPermissionCategory.COMMENTS), new MockProjectPermission("CREATE_ATTACHMENTS", "admin.permissions.CREATE_ATTACHMENT", "admin.permissions.descriptions.CREATE_ATTACHMENT", ProjectPermissionCategory.ATTACHMENTS), new MockProjectPermission("DELETE_ALL_ATTACHMENTS", "admin.permissions.ATTACHMENT_DELETE_ALL", "admin.permissions.descriptions.ATTACHMENT_DELETE_ALL", ProjectPermissionCategory.ATTACHMENTS), new MockProjectPermission("DELETE_OWN_ATTACHMENTS", "admin.permissions.ATTACHMENT_DELETE_OWN", "admin.permissions.descriptions.ATTACHMENT_DELETE_OWN", ProjectPermissionCategory.ATTACHMENTS), new MockProjectPermission("WORK_ON_ISSUES", "admin.permissions.WORK_ISSUE", "admin.permissions.descriptions.WORK_ISSUE", ProjectPermissionCategory.TIME_TRACKING), new MockProjectPermission("EDIT_OWN_WORKLOGS", "admin.permissions.WORKLOG_EDIT_OWN", "admin.permissions.descriptions.WORKLOG_EDIT_OWN", ProjectPermissionCategory.TIME_TRACKING), new MockProjectPermission("EDIT_ALL_WORKLOGS", "admin.permissions.WORKLOG_EDIT_ALL", "admin.permissions.descriptions.WORKLOG_EDIT_ALL", ProjectPermissionCategory.TIME_TRACKING), new MockProjectPermission("DELETE_OWN_WORKLOGS", "admin.permissions.WORKLOG_DELETE_OWN", "admin.permissions.descriptions.WORKLOG_DELETE_OWN", ProjectPermissionCategory.TIME_TRACKING), new MockProjectPermission("DELETE_ALL_WORKLOGS", "admin.permissions.WORKLOG_DELETE_ALL", "admin.permissions.descriptions.WORKLOG_DELETE_ALL", ProjectPermissionCategory.TIME_TRACKING));

    public Collection<ProjectPermission> all() {
        return SYSTEM_PROJECT_PERMISSIONS;
    }

    public Collection<ProjectPermission> withCategory(final ProjectPermissionCategory category) {
        return Lists.newArrayList((Iterable)Iterables.filter(this.all(), (Predicate)new Predicate<ProjectPermission>(){

            public boolean apply(ProjectPermission permission) {
                return category.equals((Object)permission.getCategory());
            }
        }));
    }

    public Option<ProjectPermission> withKey(ProjectPermissionKey key) {
        for (ProjectPermission permission : this.all()) {
            if (!permission.getKey().equals(key.permissionKey())) continue;
            return Option.some((Object)permission);
        }
        return Option.none();
    }

    public boolean exists(ProjectPermissionKey key) {
        return this.withKey(key) != null;
    }
}

