/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.tenancy;

import com.atlassian.core.util.FileUtils;
import com.atlassian.jira.tenancy.PluginKeyPredicateLoader;
import com.atlassian.plugin.Plugin;
import java.io.File;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestPluginKeyPredicateLoader {
    @Mock
    Plugin mockPlugin;
    @Rule
    public TemporaryFolder testFolder = new TemporaryFolder();

    @Before
    public void setupMocks() {
        Mockito.when((Object)this.mockPlugin.getKey()).thenReturn((Object)"plugin.key");
    }

    @Test
    public void returnsBlankPredicateIfFileDoesNotExist() {
        PluginKeyPredicateLoader loader = new PluginKeyPredicateLoader();
        Assert.assertThat((Object)loader.getPluginKeyPatternsPredicate().matches(this.mockPlugin), (Matcher)IsEqual.equalTo((Object)true));
    }

    @Test
    public void predicatesFilteredSuccessfully() throws Exception {
        File patternFile = this.testFolder.newFile("patterns.txt");
        FileUtils.saveTextFile((String)"plugin.key", (File)patternFile);
        PluginKeyPredicateLoader loader = new PluginKeyPredicateLoader(patternFile.getPath());
        Assert.assertThat((Object)loader.getPluginKeyPatternsPredicate().matches(this.mockPlugin), (Matcher)IsEqual.equalTo((Object)true));
    }
}

