/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.crowd.embedded.api.Attributes;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.GroupWithAttributes;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.api.UserCapabilities;
import com.atlassian.crowd.embedded.api.UserWithAttributes;
import com.atlassian.crowd.embedded.impl.DelegatingGroupWithAttributes;
import com.atlassian.crowd.embedded.impl.ImmutableAttributes;
import com.atlassian.crowd.embedded.impl.ImmutableUser;
import com.atlassian.crowd.exception.FailedAuthenticationException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.runtime.GroupNotFoundException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.crowd.search.query.entity.GroupQuery;
import com.atlassian.crowd.search.query.entity.UserQuery;
import com.atlassian.crowd.search.query.membership.GroupMembersOfGroupQuery;
import com.atlassian.crowd.search.query.membership.GroupMembershipQuery;
import com.atlassian.crowd.search.query.membership.UserMembersOfGroupQuery;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.MockUser;
import com.atlassian.jira.user.util.MockUserKeyStore;
import com.atlassian.jira.user.util.UserKeyStore;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MockCrowdService
implements CrowdService {
    protected Map<String, User> users = new HashMap<String, User>();
    protected Map<String, PasswordCredential> credentials = new HashMap<String, PasswordCredential>();
    protected Map<String, Map<String, Set<String>>> userAttributes = new HashMap<String, Map<String, Set<String>>>();
    protected Map<String, Group> groups = new HashMap<String, Group>();
    protected Map<String, SetMultimap<String, String>> groupAttributes = new HashMap<String, SetMultimap<String, String>>();
    protected Multimap<String, User> groupMembers = HashMultimap.create();
    protected Multimap<String, Group> nestedGroups = HashMultimap.create();

    public User addUser(User user, String credential) {
        User newUser = ImmutableUser.newUser((User)user).directoryId(1L).toUser();
        this.users.put(newUser.getName().toLowerCase(), newUser);
        this.credentials.put(newUser.getName().toLowerCase(), PasswordCredential.unencrypted((String)credential));
        this.getUserKeyStore().ensureUniqueKeyForNewUser(newUser.getName());
        return newUser;
    }

    public User addUser(ApplicationUser user) throws InvalidUserException, InvalidCredentialException {
        return this.addUser(user.getDirectoryUser(), null);
    }

    protected UserKeyStore getUserKeyStore() {
        return new MockUserKeyStore();
    }

    public User updateUser(User user) throws InvalidUserException {
        this.users.put(user.getName().toLowerCase(), user);
        return user;
    }

    public User renameUser(User user, String newUsername) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void updateUserCredential(User user, String credential) throws InvalidCredentialException {
        this.credentials.put(user.getName().toLowerCase(), PasswordCredential.unencrypted((String)credential));
    }

    public void setUserAttribute(User user, String key, String value) {
        Map<String, Set<String>> allValues = this.userAttributes.get(user.getName());
        if (allValues == null) {
            allValues = new HashMap<String, Set<String>>();
            this.userAttributes.put(user.getName(), allValues);
        }
        allValues.put(key, Collections.singleton(value));
    }

    public void setUserAttribute(User user, String key, Set<String> value) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void removeUserAttribute(User user, String key) {
        Map<String, Set<String>> allValues = this.userAttributes.get(user.getName());
        if (allValues != null) {
            allValues.remove(key);
        }
    }

    public void removeAllUserAttributes(User user) {
        this.userAttributes.remove(user.getName());
    }

    public boolean removeUser(User user) {
        if (this.users.containsKey(user.getName().toLowerCase())) {
            this.users.remove(user.getName().toLowerCase());
            this.credentials.remove(user.getName().toLowerCase());
            for (Group group : this.groups.values()) {
                this.removeUserFromGroup(user, group);
            }
            return true;
        }
        return false;
    }

    public Group addGroup(Group group) {
        this.groups.put(group.getName(), group);
        return group;
    }

    public boolean mockUsersInGroup(int numberOfUsers, Group group) {
        for (int i = 0; i < numberOfUsers; ++i) {
            this.groupMembers.put((Object)group.getName(), (Object)new MockUser("User" + Math.random()));
        }
        return true;
    }

    public Group updateGroup(Group group) {
        this.groups.put(group.getName(), group);
        return group;
    }

    public void setGroupAttribute(Group group, String attributeName, String attributeValue) {
        String groupName = group.getName();
        if (this.getGroup(groupName) == null) {
            throw new GroupNotFoundException(groupName);
        }
        SetMultimap<String, String> attributes = this.groupAttributes.getOrDefault(group, (SetMultimap<String, String>)HashMultimap.create());
        this.groupAttributes.put(groupName, attributes);
        attributes.put((Object)attributeName, (Object)attributeValue);
    }

    public void setGroupAttribute(Group group, String attributeName, Set<String> attributeValues) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void removeGroupAttribute(Group group, String attributeName) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void removeAllGroupAttributes(Group group) {
        this.groupAttributes.remove(group.getName());
    }

    public boolean removeGroup(Group group) {
        if (this.groups.containsKey(group.getName())) {
            this.groups.remove(group.getName());
            this.groupMembers.removeAll((Object)group.getName());
            this.groupAttributes.remove(group.getName());
            return true;
        }
        return false;
    }

    public boolean addUserToGroup(User user, Group group) {
        return this.groupMembers.put((Object)group.getName(), (Object)user);
    }

    public boolean addUserToGroup(ApplicationUser user, Group group) {
        return this.addUserToGroup(user.getDirectoryUser(), group);
    }

    public boolean addGroupToGroup(Group childGroup, Group parentGroup) throws GroupNotFoundException {
        if (!this.groups.containsKey(childGroup.getName()) || !this.groups.containsKey(parentGroup.getName())) {
            throw new GroupNotFoundException("Either child group or parent group does not exist");
        }
        return this.nestedGroups.put((Object)parentGroup.getName(), (Object)childGroup);
    }

    public boolean removeUserFromGroup(User user, Group group) {
        return this.groupMembers.remove((Object)group.getName(), (Object)user);
    }

    public boolean removeGroupFromGroup(Group childGroup, Group parentGroup) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isUserDirectGroupMember(User user, Group group) {
        return this.getGroupMembers(group, false).contains(user);
    }

    public boolean isGroupDirectGroupMember(Group childGroup, Group parentGroup) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public User authenticate(String name, String credential) throws OperationFailedException, FailedAuthenticationException {
        User user = this.getUser(name);
        if (user == null) {
            throw new InactiveAccountException(name);
        }
        PasswordCredential passwordCredential = this.credentials.get(name.toLowerCase());
        if (passwordCredential == null || passwordCredential.isEncryptedCredential()) {
            throw new FailedAuthenticationException(name);
        }
        String knownCredential = passwordCredential.getCredential();
        if (knownCredential != null && knownCredential.equals(credential)) {
            return user;
        }
        throw new FailedAuthenticationException(name);
    }

    public User getUser(String name) {
        return this.users.get(name.toLowerCase());
    }

    public UserWithAttributes getUserWithAttributes(String name) {
        User user = this.getUser(name);
        if (user != null) {
            return new MockUser(name, user.getDisplayName(), user.getEmailAddress(), this.userAttributes.get(user.getName()));
        }
        return null;
    }

    public Group getGroup(String name) {
        return this.groups.get(name);
    }

    public GroupWithAttributes getGroupWithAttributes(String name) {
        Group group = this.getGroup(name);
        if (group != null) {
            SetMultimap<String, String> attributes = this.groupAttributes.getOrDefault(group.getName(), (SetMultimap<String, String>)HashMultimap.create());
            return new DelegatingGroupWithAttributes(group, (Attributes)new ImmutableAttributes(attributes.asMap()));
        }
        return null;
    }

    public <T> Iterable<T> search(Query<T> query) {
        if (query instanceof UserQuery) {
            if (query.getReturnType().isAssignableFrom(String.class)) {
                return this.users.keySet();
            }
            return this.users.values();
        }
        if (query instanceof GroupQuery) {
            if (query.getReturnType().isAssignableFrom(String.class)) {
                return this.groups.keySet();
            }
            return this.groups.values();
        }
        if (query instanceof GroupMembershipQuery) {
            ArrayList<String> groupList = new ArrayList<String>();
            String userName = ((GroupMembershipQuery)query).getEntityNameToMatch();
            User user = this.getUser(userName);
            if (user == null) {
                return Collections.emptyList();
            }
            for (Group group : this.groups.values()) {
                if (!this.isUserMemberOfGroup(user, group)) continue;
                if (query.getReturnType().isAssignableFrom(String.class)) {
                    groupList.add(group.getName());
                    continue;
                }
                groupList.add((String)group);
            }
            return groupList;
        }
        if (query instanceof UserMembersOfGroupQuery) {
            ArrayList<String> userList = new ArrayList<String>();
            String groupName = ((UserMembersOfGroupQuery)query).getEntityNameToMatch();
            Group group = this.getGroup(groupName);
            if (group != null) {
                for (User user : this.getGroupMembers(group, true)) {
                    if (query.getReturnType().isAssignableFrom(String.class)) {
                        userList.add(user.getName());
                        continue;
                    }
                    userList.add((String)user);
                }
            }
            return userList;
        }
        if (query instanceof GroupMembersOfGroupQuery) {
            ArrayList<String> groupList = new ArrayList<String>();
            String groupName = ((GroupMembersOfGroupQuery)query).getEntityNameToMatch();
            Group group = this.getGroup(groupName);
            if (group != null) {
                for (Group g : this.groups.values()) {
                    if (!this.isGroupMemberOfGroup(g, group)) continue;
                    if (query.getReturnType().isAssignableFrom(String.class)) {
                        groupList.add(g.getName());
                        continue;
                    }
                    groupList.add((String)g);
                }
            }
            return groupList;
        }
        throw new UnsupportedOperationException("Unrecognized Query type '" + query + "'.");
    }

    public boolean isUserMemberOfGroup(User user, Group group) {
        return this.isUserMemberOfGroup(user.getName(), group.getName());
    }

    public boolean isUserMemberOfGroup(String userName, String groupName) {
        List<User> groupMembers = this.getGroupMembers(groupName, true);
        for (User groupMember : groupMembers) {
            if (!userName.equals(groupMember.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean isGroupMemberOfGroup(String childGroupName, String parentGroup) {
        for (Group child : this.nestedGroups.get((Object)parentGroup)) {
            if (child.getName().equalsIgnoreCase(childGroupName)) {
                return true;
            }
            if (!this.isGroupMemberOfGroup(childGroupName, child.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean isGroupMemberOfGroup(Group childGroup, Group parentGroup) {
        return this.isGroupMemberOfGroup(childGroup.getName(), parentGroup.getName());
    }

    public Iterable<User> searchUsersAllowingDuplicateNames(Query<User> userQuery) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public UserCapabilities getCapabilitiesForNewUsers() {
        return () -> false;
    }

    private List<User> getGroupMembers(Group group, boolean nested) {
        if (group == null) {
            throw new IllegalArgumentException("null group");
        }
        return this.getGroupMembers(group.getName(), nested);
    }

    private List<User> getGroupMembers(String groupname, boolean nested) {
        Collection members = this.groupMembers.get((Object)groupname);
        ArrayList<User> allMembers = new ArrayList<User>(members);
        if (nested) {
            for (Group g : this.nestedGroups.get((Object)groupname)) {
                allMembers.addAll(this.getGroupMembers(g.getName(), true));
            }
        }
        return allMembers;
    }

    public Collection<User> getAllUsers() {
        return this.users.values();
    }
}

