/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.bean;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.bean.I18nBean;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;

public class MockI18nBean
extends I18nBean {
    public MockI18nBean() {
        super((I18nHelper)new SimpleDelegate());
    }

    public MockI18nBean(Locale locale) {
        super((I18nHelper)new SimpleDelegate(locale));
    }

    protected I18nHelper.BeanFactory getFactory() {
        return new I18nHelper.BeanFactory(){

            public I18nHelper getInstance(Locale locale) {
                return new SimpleDelegate(locale);
            }

            public I18nHelper getInstance(ApplicationUser user) {
                throw new UnsupportedOperationException("Not implemented");
            }
        };
    }

    private static class SimpleDelegate
    implements I18nHelper {
        private static final Object[] EMPTY_ARRAY = new Object[0];
        private final ResourceBundle bundle;
        private final Locale locale;

        private SimpleDelegate() {
            this(Locale.ENGLISH);
        }

        private SimpleDelegate(Locale locale) {
            this.bundle = ResourceBundle.getBundle(JiraWebActionSupport.class.getName(), locale);
            this.locale = locale;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public ResourceBundle getDefaultResourceBundle() {
            return this.bundle;
        }

        public String getUnescapedText(String key) {
            return this.getTranslation(key);
        }

        public String getUntransformedRawText(String key) {
            return this.getTranslation(key);
        }

        private String getTranslation(String key) {
            if (this.bundle.containsKey(key)) {
                return this.bundle.getString(key);
            }
            return key;
        }

        public boolean isKeyDefined(String key) {
            return this.bundle.containsKey(key);
        }

        public String getText(String key) {
            return this.formatI18nMsg(key, new Object[0]);
        }

        public String getText(String key, String value1) {
            return this.formatI18nMsg(key, value1);
        }

        public String getText(String key, String value1, String value2) {
            return this.formatI18nMsg(key, value1, value2);
        }

        public String getText(String key, String value1, String value2, String value3) {
            return this.formatI18nMsg(key, value1, value2, value3);
        }

        public String getText(String key, String value1, String value2, String value3, String value4) {
            return this.formatI18nMsg(key, value1, value2, value3, value4);
        }

        public String getText(String key, Object value1, Object value2, Object value3) {
            return this.formatI18nMsg(key, value1, value2, value3);
        }

        public String getText(String key, Object value1, Object value2, Object value3, Object value4) {
            return this.formatI18nMsg(key, value1, value2, value3, value4);
        }

        public String getText(String key, Object value1, Object value2, Object value3, Object value4, Object value5) {
            return this.formatI18nMsg(key, value1, value2, value3, value4, value5);
        }

        public String getText(String key, Object value1, Object value2, Object value3, Object value4, Object value5, Object value6) {
            return this.formatI18nMsg(key, value1, value2, value3, value4, value5, value6);
        }

        public String getText(String key, Object value1, Object value2, Object value3, Object value4, Object value5, Object value6, Object value7) {
            return this.formatI18nMsg(key, value1, value2, value3, value4, value5, value6, value7);
        }

        public String getText(String key, String value1, String value2, String value3, String value4, String value5, String value6, String value7) {
            return this.formatI18nMsg(key, value1, value2, value3, value4, value5, value6, value7);
        }

        public String getText(String key, Object value1, Object value2, Object value3, Object value4, Object value5, Object value6, Object value7, Object value8) {
            return this.formatI18nMsg(key, value1, value2, value3, value4, value5, value6, value7, value8);
        }

        public String getText(String key, String value1, String value2, String value3, String value4, String value5, String value6, String value7, String value8, String value9) {
            return this.formatI18nMsg(key, value1, value2, value3, value4, value5, value6, value7, value8, value9);
        }

        public String getText(String key, Object parameters) {
            Object[] substitutionParameters = parameters instanceof Object[] ? (Object[])parameters : (parameters instanceof Iterable ? Iterables.toArray((Iterable)((Iterable)parameters), Object.class) : (parameters == null ? EMPTY_ARRAY : new Object[]{parameters}));
            return this.formatI18nMsg(key, substitutionParameters);
        }

        public Set<String> getKeysForPrefix(final String prefix) {
            return Sets.filter(this.bundle.keySet(), (Predicate)new Predicate<String>(){

                public boolean apply(String input) {
                    return input.startsWith(prefix);
                }
            });
        }

        public ResourceBundle getResourceBundle() {
            return this.bundle;
        }

        private String formatI18nMsg(String key, Object ... substitutionParameters) {
            if (key == null || !this.bundle.containsKey(key)) {
                return key;
            }
            MessageFormat mf = new MessageFormat(this.bundle.getString(key), this.locale);
            return mf.format(substitutionParameters == null ? EMPTY_ARRAY : substitutionParameters);
        }
    }

    public static class MockI18nBeanFactory
    implements I18nHelper.BeanFactory {
        public I18nHelper getInstance(Locale locale) {
            return new MockI18nBean();
        }

        public I18nHelper getInstance(ApplicationUser user) {
            return new MockI18nBean();
        }
    }
}

