/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.MockWorkflowScheme;
import com.atlassian.jira.workflow.WorkflowScheme;
import com.google.common.base.Function;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class MockAssignableWorkflowScheme
extends MockWorkflowScheme
implements AssignableWorkflowScheme {
    private String name;
    private String description;
    private boolean defaultScheme;

    public static Function<AssignableWorkflowScheme, MockAssignableWorkflowScheme> toMock() {
        return new Function<AssignableWorkflowScheme, MockAssignableWorkflowScheme>(){

            public MockAssignableWorkflowScheme apply(AssignableWorkflowScheme input) {
                if (input == null) {
                    return null;
                }
                return new MockAssignableWorkflowScheme(input);
            }
        };
    }

    public MockAssignableWorkflowScheme() {
    }

    public MockAssignableWorkflowScheme(Long id, String name) {
        this(id, name, null);
    }

    public MockAssignableWorkflowScheme(Long id, String name, String description) {
        super(id);
        this.name = name;
        this.description = description;
    }

    public MockAssignableWorkflowScheme(AssignableWorkflowScheme scheme) {
        super((WorkflowScheme)scheme);
        this.name = scheme.getName();
        this.description = scheme.getDescription();
        this.defaultScheme = scheme.isDefault();
    }

    @Nonnull
    public AssignableWorkflowScheme.Builder builder() {
        return new MockBuilder(this);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isDraft() {
        return false;
    }

    public boolean isDefault() {
        return this.defaultScheme;
    }

    public MockAssignableWorkflowScheme setDefaultScheme(boolean defaultScheme) {
        this.defaultScheme = defaultScheme;
        return this;
    }

    public MockAssignableWorkflowScheme setDescription(String description) {
        this.description = description;
        return this;
    }

    public MockAssignableWorkflowScheme setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MockAssignableWorkflowScheme that = (MockAssignableWorkflowScheme)o;
        if (this.defaultScheme != that.defaultScheme) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.defaultScheme ? 1 : 0);
        return result;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static class MockBuilder
    implements AssignableWorkflowScheme.Builder {
        private final MockAssignableWorkflowScheme mockAssignableWorkflowScheme;

        public MockBuilder(AssignableWorkflowScheme ws) {
            this.mockAssignableWorkflowScheme = new MockAssignableWorkflowScheme(ws);
        }

        @Nonnull
        public AssignableWorkflowScheme.Builder setName(@Nonnull String name) {
            this.mockAssignableWorkflowScheme.setName(name);
            return this;
        }

        @Nonnull
        public AssignableWorkflowScheme.Builder setDescription(String description) {
            this.mockAssignableWorkflowScheme.setDescription(description);
            return this;
        }

        @Nonnull
        public MockAssignableWorkflowScheme build() {
            return new MockAssignableWorkflowScheme(this.mockAssignableWorkflowScheme);
        }

        public String getDefaultWorkflow() {
            return this.mockAssignableWorkflowScheme.getConfiguredDefaultWorkflow();
        }

        public String getMapping(@Nonnull String issueTypeId) {
            return this.mockAssignableWorkflowScheme.getConfiguredWorkflow(issueTypeId);
        }

        public Map<String, String> getMappings() {
            return this.mockAssignableWorkflowScheme.getMappings();
        }

        public Long getId() {
            return this.mockAssignableWorkflowScheme.getId();
        }

        public boolean isDraft() {
            return this.mockAssignableWorkflowScheme.isDraft();
        }

        public boolean isDefault() {
            return false;
        }

        public String getDescription() {
            return this.mockAssignableWorkflowScheme.getDescription();
        }

        public String getName() {
            return this.mockAssignableWorkflowScheme.getName();
        }

        @Nonnull
        public MockBuilder setDefaultWorkflow(@Nonnull String workflowName) {
            this.mockAssignableWorkflowScheme.setDefaultWorkflow(workflowName);
            return this;
        }

        @Nonnull
        public MockBuilder setMapping(@Nonnull String issueTypeId, @Nonnull String workflowName) {
            this.mockAssignableWorkflowScheme.setMapping(issueTypeId, workflowName);
            return this;
        }

        @Nonnull
        public MockBuilder setMappings(@Nonnull Map<String, String> mappings) {
            this.mockAssignableWorkflowScheme.setMappings(mappings);
            return this;
        }

        @Nonnull
        public MockBuilder removeMapping(@Nonnull String issueTypeId) {
            this.mockAssignableWorkflowScheme.removeMapping(issueTypeId);
            return this;
        }

        @Nonnull
        public MockBuilder removeDefault() {
            this.mockAssignableWorkflowScheme.removeDefault();
            return this;
        }

        @Nonnull
        public MockBuilder clearMappings() {
            this.mockAssignableWorkflowScheme.clearMappings();
            return this;
        }

        @Nonnull
        public AssignableWorkflowScheme.Builder removeWorkflow(@Nonnull String workflowName) {
            this.mockAssignableWorkflowScheme.removeWorkflow(workflowName);
            return this;
        }
    }
}

