/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.gzipfilter.org.apache.commons.lang.builder.ReflectionToStringBuilder;
import com.atlassian.gzipfilter.org.apache.commons.lang.builder.ToStringStyle;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.DraftWorkflowScheme;
import com.atlassian.jira.workflow.MockWorkflowScheme;
import com.atlassian.jira.workflow.WorkflowScheme;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nonnull;

public class MockDraftWorkflowScheme
extends MockWorkflowScheme
implements DraftWorkflowScheme {
    private ApplicationUser lastModifiedUser;
    private Date lastModifiedDate;
    private AssignableWorkflowScheme parentScheme;

    public MockDraftWorkflowScheme() {
        this((Long)null);
    }

    public MockDraftWorkflowScheme(Long id) {
        this(id, null);
    }

    public MockDraftWorkflowScheme(DraftWorkflowScheme ws) {
        super((WorkflowScheme)ws);
        this.lastModifiedUser = ws.getLastModifiedUser();
        this.lastModifiedDate = ws.getLastModifiedDate();
        this.parentScheme = ws.getParentScheme();
    }

    public MockDraftWorkflowScheme(Long l, AssignableWorkflowScheme parentScheme) {
        super(l);
        this.parentScheme = parentScheme;
    }

    public ApplicationUser getLastModifiedUser() {
        return this.lastModifiedUser;
    }

    @Nonnull
    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public AssignableWorkflowScheme getParentScheme() {
        return this.parentScheme;
    }

    public MockDraftWorkflowScheme setParentScheme(AssignableWorkflowScheme parentScheme) {
        this.parentScheme = parentScheme;
        return this;
    }

    public MockBuilder builder() {
        return new MockBuilder(this);
    }

    public MockDraftWorkflowScheme setLastModifiedUser(ApplicationUser lastModifiedUser) {
        this.lastModifiedUser = lastModifiedUser;
        return this;
    }

    public MockDraftWorkflowScheme setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
        return this;
    }

    public String getName() {
        return this.parentScheme == null ? null : this.parentScheme.getName();
    }

    public String getDescription() {
        return this.parentScheme == null ? null : this.parentScheme.getDescription();
    }

    public boolean isDraft() {
        return true;
    }

    public boolean isDefault() {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MockDraftWorkflowScheme that = (MockDraftWorkflowScheme)o;
        if (this.lastModifiedDate != null ? !this.lastModifiedDate.equals(that.lastModifiedDate) : that.lastModifiedDate != null) {
            return false;
        }
        if (this.lastModifiedUser != null ? !this.lastModifiedUser.equals((Object)that.lastModifiedUser) : that.lastModifiedUser != null) {
            return false;
        }
        return !(this.parentScheme != null ? !this.parentScheme.equals(that.parentScheme) : that.parentScheme != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.lastModifiedUser != null ? this.lastModifiedUser.hashCode() : 0);
        result = 31 * result + (this.lastModifiedDate != null ? this.lastModifiedDate.hashCode() : 0);
        result = 31 * result + (this.parentScheme != null ? this.parentScheme.hashCode() : 0);
        return result;
    }

    public String toString() {
        return ReflectionToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static class MockBuilder
    implements DraftWorkflowScheme.Builder {
        private final MockDraftWorkflowScheme mockDraftWorkflowScheme;

        public MockBuilder(DraftWorkflowScheme ws) {
            this.mockDraftWorkflowScheme = new MockDraftWorkflowScheme(ws);
        }

        public ApplicationUser getLastModifiedUser() {
            return this.mockDraftWorkflowScheme.getLastModifiedUser();
        }

        public Date getLastModifiedDate() {
            return this.mockDraftWorkflowScheme.getLastModifiedDate();
        }

        public AssignableWorkflowScheme getParentScheme() {
            return this.mockDraftWorkflowScheme.getParentScheme();
        }

        public DraftWorkflowScheme build() {
            return new MockDraftWorkflowScheme(this.mockDraftWorkflowScheme);
        }

        public String getDefaultWorkflow() {
            return this.mockDraftWorkflowScheme.getConfiguredDefaultWorkflow();
        }

        public String getMapping(@Nonnull String issueTypeId) {
            return this.mockDraftWorkflowScheme.getConfiguredWorkflow(issueTypeId);
        }

        public Map<String, String> getMappings() {
            return this.mockDraftWorkflowScheme.getMappings();
        }

        public Long getId() {
            return this.mockDraftWorkflowScheme.getId();
        }

        public boolean isDraft() {
            return true;
        }

        public boolean isDefault() {
            return false;
        }

        public String getDescription() {
            return this.mockDraftWorkflowScheme.getDescription();
        }

        public String getName() {
            return this.mockDraftWorkflowScheme.getName();
        }

        @Nonnull
        public DraftWorkflowScheme.Builder setDefaultWorkflow(@Nonnull String workflowName) {
            this.mockDraftWorkflowScheme.setDefaultWorkflow(workflowName);
            return this;
        }

        @Nonnull
        public DraftWorkflowScheme.Builder setMapping(@Nonnull String issueTypeId, @Nonnull String workflowName) {
            this.mockDraftWorkflowScheme.setMapping(issueTypeId, workflowName);
            return this;
        }

        @Nonnull
        public DraftWorkflowScheme.Builder setMappings(@Nonnull Map<String, String> mappings) {
            this.mockDraftWorkflowScheme.setMappings(mappings);
            return this;
        }

        @Nonnull
        public DraftWorkflowScheme.Builder removeMapping(@Nonnull String issueTypeId) {
            this.mockDraftWorkflowScheme.removeMapping(issueTypeId);
            return this;
        }

        @Nonnull
        public DraftWorkflowScheme.Builder removeDefault() {
            this.mockDraftWorkflowScheme.removeDefault();
            return this;
        }

        @Nonnull
        public DraftWorkflowScheme.Builder clearMappings() {
            this.mockDraftWorkflowScheme.clearMappings();
            return this;
        }

        @Nonnull
        public DraftWorkflowScheme.Builder removeWorkflow(@Nonnull String workflowName) {
            this.mockDraftWorkflowScheme.removeWorkflow(workflowName);
            return this;
        }

        public String toString() {
            return ReflectionToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

