/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.jira.workflow.DraftWorkflowScheme;
import com.atlassian.jira.workflow.DraftWorkflowSchemeStore;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.MockDraftWorkflowSchemeState;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MockDraftWorkflowSchemeStore
implements DraftWorkflowSchemeStore {
    private long lastId = 0L;
    private Map<Long, DraftWorkflowSchemeStore.DraftState> workflowState = Maps.newHashMap();
    private Date lastDate;

    public DraftWorkflowSchemeStore.DraftState create(DraftWorkflowSchemeStore.DraftState state) {
        MockDraftWorkflowSchemeState.Builder builder = new MockDraftWorkflowSchemeState.Builder(state);
        builder.setId(++this.lastId);
        builder.setLastModifiedDate(this.nextDate());
        return this.addState(builder.build());
    }

    public DraftWorkflowSchemeStore.DraftState addState(DraftWorkflowSchemeStore.DraftState state) {
        state = new MockDraftWorkflowSchemeState.Builder(state).setLastModifiedDate(this.nextDate()).build();
        this.workflowState.put(state.getId(), state);
        return state;
    }

    public DraftWorkflowSchemeStore.DraftState addStateForScheme(DraftWorkflowScheme scheme) {
        return this.addState(new MockDraftWorkflowSchemeState.Builder(scheme.getParentScheme().getId()).setId(scheme.getId()).setMappings((Map<String, String>)scheme.getMappings()).setLastModifiedDate(scheme.getLastModifiedDate()).build());
    }

    public DraftWorkflowSchemeStore.DraftState update(DraftWorkflowSchemeStore.DraftState state) {
        return this.addState(state);
    }

    public boolean delete(long id) {
        return this.workflowState.remove(id) != null;
    }

    public boolean delete(DraftWorkflowSchemeStore.DraftState state) {
        return this.delete(state.getId());
    }

    public boolean deleteByParentId(long parentId) {
        boolean changed = false;
        Iterator<DraftWorkflowSchemeStore.DraftState> iterator = this.workflowState.values().iterator();
        while (iterator.hasNext()) {
            DraftWorkflowSchemeStore.DraftState next = iterator.next();
            if (next.getParentSchemeId() != parentId) continue;
            iterator.remove();
            changed = true;
        }
        return changed;
    }

    public boolean hasDraftForParent(long parentId) {
        return this.getDraftForParent(parentId) != null;
    }

    public DraftWorkflowSchemeStore.DraftState getDraftForParent(long parentId) {
        for (DraftWorkflowSchemeStore.DraftState state : this.getAll()) {
            if (parentId != state.getParentSchemeId()) continue;
            return state;
        }
        return null;
    }

    public DraftWorkflowSchemeStore.DraftState get(long id) {
        return this.workflowState.get(id);
    }

    public Iterable<DraftWorkflowSchemeStore.DraftState> getAll() {
        return this.workflowState.values();
    }

    public DraftWorkflowSchemeStore.DraftState.Builder builder(long parentId) {
        return new MockDraftWorkflowSchemeState.Builder(parentId);
    }

    public boolean renameWorkflow(String oldName, String newName) {
        boolean changed = false;
        for (DraftWorkflowSchemeStore.DraftState state : Lists.newArrayList(this.getAll())) {
            HashMap newMap = Maps.newHashMap();
            boolean newMapChanged = false;
            for (Map.Entry entry : state.getMappings().entrySet()) {
                if (oldName.equals(entry.getValue())) {
                    newMapChanged = true;
                    newMap.put(entry.getKey(), newName);
                    continue;
                }
                newMap.put(entry.getKey(), entry.getValue());
            }
            if (!newMapChanged) continue;
            this.addState(((DraftWorkflowSchemeStore.DraftState.Builder)state.builder().setMappings((Map)newMap)).build());
            changed = true;
        }
        return changed;
    }

    public Long getParentId(long id) {
        DraftWorkflowSchemeStore.DraftState state = this.get(id);
        return state != null ? Long.valueOf(state.getParentSchemeId()) : null;
    }

    public Iterable<DraftWorkflowSchemeStore.DraftState> getSchemesUsingWorkflow(JiraWorkflow jiraWorkflow) {
        ArrayList<DraftWorkflowSchemeStore.DraftState> states = new ArrayList<DraftWorkflowSchemeStore.DraftState>();
        for (Map.Entry<Long, DraftWorkflowSchemeStore.DraftState> entry : this.workflowState.entrySet()) {
            DraftWorkflowSchemeStore.DraftState state = entry.getValue();
            if (!state.getMappings().containsValue(jiraWorkflow.getName())) continue;
            states.add(state);
        }
        return states;
    }

    private Date nextDate() {
        this.lastDate = new Date();
        return this.lastDate;
    }

    public Date getLastDate() {
        return this.lastDate;
    }

    public long getLastId() {
        return this.lastId;
    }
}

