/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.jira.issue.IssueConstantImpl;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.status.MockStatus;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.mock.ofbiz.MockGenericValue;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import com.opensymphony.workflow.loader.MockStepDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericValue;

public class MockJiraWorkflow
implements JiraWorkflow {
    private final List<GenericValue> statusList = new ArrayList<GenericValue>();
    private final Map<GenericValue, StepDescriptor> statusToStepMap = new HashMap<GenericValue, StepDescriptor>();
    private String name;
    private boolean draftWorkflow = false;
    private WorkflowDescriptor workflowDescriptor;
    private final Collection<ActionDescriptor> actions = new ArrayList<ActionDescriptor>();

    public MockJiraWorkflow() {
    }

    public MockJiraWorkflow(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.getName();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return null;
    }

    public WorkflowDescriptor getDescriptor() {
        return this.workflowDescriptor;
    }

    public void setWorkflowDescriptor(WorkflowDescriptor workflowDescriptor) {
        this.workflowDescriptor = workflowDescriptor;
    }

    public Collection<ActionDescriptor> getAllActions() {
        return this.actions;
    }

    public Collection<ActionDescriptor> getActionsByName(String name) {
        return null;
    }

    public MockJiraWorkflow addAction(ActionDescriptor actionDescriptor) {
        this.actions.add(actionDescriptor);
        return this;
    }

    public Collection<ActionDescriptor> getActionsWithResult(StepDescriptor stepDescriptor) {
        return null;
    }

    public boolean removeStep(StepDescriptor stepDescriptor) {
        return false;
    }

    public StepDescriptor getLinkedStep(GenericValue status) {
        return this.statusToStepMap.get(status);
    }

    public StepDescriptor getLinkedStep(Status status) {
        return this.getLinkedStep(((IssueConstantImpl)status).getGenericValue());
    }

    public List<GenericValue> getLinkedStatuses() {
        return this.statusList;
    }

    public List<Status> getLinkedStatusObjects() {
        return Lists.transform(this.statusList, (Function)new Function<GenericValue, Status>(){

            public Status apply(@Nullable GenericValue input) {
                return new MockStatus(input, null);
            }
        });
    }

    public Set<String> getLinkedStatusIds() {
        return ImmutableSet.copyOf((Collection)Lists.transform(this.getLinkedStatusObjects(), (Function)new Function<Status, String>(){

            public String apply(@Nullable Status input) {
                return input.getId();
            }
        }));
    }

    public boolean isActive() throws WorkflowException {
        return true;
    }

    public boolean isSystemWorkflow() throws WorkflowException {
        return false;
    }

    public boolean isEditable() throws WorkflowException {
        return false;
    }

    public boolean isDefault() {
        return false;
    }

    public boolean hasDraftWorkflow() {
        return false;
    }

    public int getNextActionId() {
        return 0;
    }

    public Collection<StepDescriptor> getStepsForTransition(ActionDescriptor action) {
        return null;
    }

    public Collection<FunctionDescriptor> getPostFunctionsForTransition(ActionDescriptor actionDescriptor) {
        return null;
    }

    public boolean isInitialAction(ActionDescriptor actionDescriptor) {
        return false;
    }

    public boolean isCommonAction(ActionDescriptor actionDescriptor) {
        return false;
    }

    public boolean isGlobalAction(ActionDescriptor actionDescriptor) {
        return false;
    }

    public boolean isOrdinaryAction(ActionDescriptor actionDescriptor) {
        return false;
    }

    public Status getLinkedStatus(StepDescriptor stepDescriptor) {
        return null;
    }

    public Status getLinkedStatusObject(StepDescriptor stepDescriptor) {
        return null;
    }

    public String getLinkedStatusId(StepDescriptor stepDescriptor) {
        return null;
    }

    public String getActionType(ActionDescriptor actionDescriptor) {
        return null;
    }

    public void reset() {
    }

    public Collection<ActionDescriptor> getActionsForScreen(FieldScreen fieldScreen) {
        return null;
    }

    public String getUpdateAuthorName() {
        return null;
    }

    public ApplicationUser getUpdateAuthor() {
        return null;
    }

    public Date getUpdatedDate() {
        return null;
    }

    public String getMode() {
        return null;
    }

    public int compareTo(JiraWorkflow o) {
        return 0;
    }

    public void addStep(int id, String statusName) {
        MockGenericValue gvStatus = new MockGenericValue("Status", (Map<String, ?>)FieldMap.build((String)"name", (Object)statusName));
        this.statusList.add(gvStatus);
        MockStepDescriptor step = new MockStepDescriptor(id);
        this.statusToStepMap.put(gvStatus, step);
    }

    public void clear() {
        this.statusList.clear();
        this.statusToStepMap.clear();
    }

    public boolean isDraftWorkflow() {
        return this.draftWorkflow;
    }

    public void setDraftWorkflow(boolean draftWorkflow) {
        this.draftWorkflow = draftWorkflow;
    }

    public String toString() {
        return this.getName();
    }
}

