/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mock.propertyset;

import com.google.common.collect.Maps;
import com.opensymphony.module.propertyset.PropertyException;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetSchema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Document;

public class MockPropertySet
implements PropertySet {
    private PropertySetSchema propertySetSchema;
    private Map<String, Object> map;

    public MockPropertySet() {
        this(new HashMap<String, Object>());
    }

    public MockPropertySet(Map<String, Object> map) {
        this.map = map;
    }

    public Map getMap() {
        return this.map;
    }

    public void setSchema(PropertySetSchema propertySetSchema) {
        this.propertySetSchema = propertySetSchema;
    }

    public PropertySetSchema getSchema() throws PropertyException {
        return this.propertySetSchema;
    }

    public void setAsActualType(String s, Object o) {
        this.map.put(s, o);
    }

    public Object getAsActualType(String s) {
        return this.map.get(s);
    }

    public void setBoolean(String s, boolean b) {
        this.map.put(s, b);
    }

    public boolean getBoolean(String s) throws PropertyException {
        return this.getCast(s, Boolean.class);
    }

    public void setData(String s, byte[] bytes) {
        this.map.put(s, bytes);
    }

    public byte[] getData(String s) throws PropertyException {
        Object o = this.map.get(s);
        if (o instanceof byte[]) {
            return (byte[])o;
        }
        throw new PropertyException(String.format("'%s' is not a byte[].", o));
    }

    public void setDate(String s, Date date) throws PropertyException {
        this.map.put(s, date);
    }

    public Date getDate(String s) throws PropertyException {
        return this.getCast(s, Date.class);
    }

    public void setDouble(String s, double v) throws PropertyException {
        this.map.put(s, v);
    }

    public double getDouble(String s) throws PropertyException {
        return this.getCast(s, Double.class);
    }

    public void setInt(String s, int i) throws PropertyException {
        this.map.put(s, i);
    }

    public int getInt(String s) throws PropertyException {
        return this.getCast(s, Integer.class);
    }

    public Collection getKeys() throws PropertyException {
        return new ArrayList<String>(this.map.keySet());
    }

    public Collection getKeys(int i) throws PropertyException {
        throw new UnsupportedOperationException();
    }

    public Collection getKeys(String s) throws PropertyException {
        throw new UnsupportedOperationException();
    }

    public Collection getKeys(String s, int i) throws PropertyException {
        throw new UnsupportedOperationException();
    }

    public void setLong(String s, long l) throws PropertyException {
        this.map.put(s, l);
    }

    public long getLong(String s) throws PropertyException {
        return this.getCast(s, Long.class);
    }

    public void setObject(String s, Object o) throws PropertyException {
        this.map.put(s, o);
    }

    public Object getObject(String s) throws PropertyException {
        return this.map.get(s);
    }

    public void setProperties(String s, Properties properties) throws PropertyException {
        this.map.put(s, properties);
    }

    public Properties getProperties(String s) throws PropertyException {
        return this.getCast(s, Properties.class);
    }

    public boolean isSettable(String s) {
        return true;
    }

    public void setString(String s, String s1) throws PropertyException {
        this.map.put(s, s1);
    }

    public String getString(String s) throws PropertyException {
        return this.getCast(s, String.class);
    }

    public void setText(String s, String s1) throws PropertyException {
        this.map.put(s, new TextValue(s1));
    }

    public String getText(String s) throws PropertyException {
        Object value = this.map.get(s);
        return value != null ? String.valueOf(value) : null;
    }

    public int getType(String key) throws PropertyException {
        Object value = this.map.get(key);
        if (value instanceof String) {
            return 5;
        }
        if (value instanceof TextValue) {
            return 6;
        }
        if (value instanceof Boolean) {
            return 1;
        }
        if (value instanceof Long) {
            return 3;
        }
        if (value instanceof Integer) {
            return 2;
        }
        if (value instanceof Date) {
            return 7;
        }
        if (value instanceof Document) {
            return 9;
        }
        return 8;
    }

    public void setXML(String s, Document document) throws PropertyException {
        this.map.put(s, document);
    }

    public Document getXML(String s) throws PropertyException {
        return this.getCast(s, Document.class);
    }

    public boolean exists(String s) throws PropertyException {
        return this.map.containsKey(s);
    }

    public void init(Map map, Map map1) {
    }

    public void remove(String s) throws PropertyException {
        this.map.remove(s);
    }

    public void remove() throws PropertyException {
        this.map.clear();
    }

    public boolean supportsType(int i) {
        return true;
    }

    public boolean supportsTypes() {
        return true;
    }

    private <T> T getCast(String key, Class<T> type) {
        Object o = this.map.get(key);
        if (o == null) {
            return null;
        }
        if (type.isInstance(o)) {
            return type.cast(o);
        }
        throw new PropertyException(String.format("'%s' is not of the correct type. Expecting %s but got %s.", o, type, o.getClass()));
    }

    public Map<String, Object> asMap() {
        HashMap result = Maps.newHashMap();
        for (Map.Entry<String, Object> entry : this.map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof TextValue) {
                result.put(key, ((TextValue)value).getValue());
                continue;
            }
            result.put(key, value);
        }
        return result;
    }

    private static class TextValue {
        private final String value;

        public TextValue(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TextValue textValue = (TextValue)o;
            return !(this.value != null ? !this.value.equals(textValue.value) : textValue.value != null);
        }

        public int hashCode() {
            return this.value != null ? this.value.hashCode() : 0;
        }
    }
}

