/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mail.server;

import com.atlassian.mail.MailException;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.MailProtocol;
import com.atlassian.mail.server.MailServer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;

public abstract class AbstractMailServer
implements MailServer,
Serializable {
    protected transient Logger log = Logger.getLogger(this.getClass());
    private Long id;
    private String name;
    private String description;
    private String hostname;
    private String username = null;
    private String password = null;
    private MailProtocol mailProtocol = null;
    private String port = null;
    private long timeout;
    private boolean debug;
    private boolean tlsRequired;
    private transient PrintStream debugStream;
    private Properties props = new Properties();
    protected boolean isAuthenticating;
    private String socksHost;
    private String socksPort;

    public AbstractMailServer() {
    }

    public AbstractMailServer(Long id, String name, String description, MailProtocol protocol, String hostName, String port, String username, String password, long timeout, String socksHost, String socksPort) {
        this.setId(id);
        this.setName(name);
        this.setDescription(description);
        this.setHostname(hostName);
        this.setUsername(username);
        this.setPassword(password);
        this.setMailProtocol(protocol);
        this.setPort(port);
        this.setTimeout(timeout);
        this.setSocksHost(socksHost);
        this.setSocksPort(socksPort);
        this.props = this.loadSystemProperties(this.props);
    }

    private void setInitialProperties() {
        if (this.getMailProtocol() != null) {
            String protocol = this.getMailProtocol().getProtocol();
            this.props.put("mail." + protocol + ".host", "" + this.getHostname());
            this.props.put("mail." + protocol + ".port", "" + this.getPort());
            this.props.put("mail." + protocol + ".timeout", "" + this.getTimeout());
            this.props.put("mail.transport.protocol", "" + protocol);
            if (this.isTlsRequired()) {
                this.props.put("mail." + protocol + ".starttls.enable", "true");
            }
            if (StringUtils.isNotBlank((String)this.getUsername())) {
                this.props.put("mail." + protocol + ".auth", "true");
                this.isAuthenticating = true;
            }
            if (StringUtils.isNotBlank((String)this.getSocksHost())) {
                this.props.put("mail." + protocol + ".socks.host", this.getSocksHost());
            }
            if (StringUtils.isNotBlank((String)this.getSocksPort())) {
                this.props.put("mail." + protocol + ".socks.port", this.getSocksPort());
            }
        }
        this.props.put("mail.debug", "" + this.getDebug());
        if (Boolean.getBoolean("mail.debug")) {
            this.props.put("mail.debug", "true");
        }
    }

    protected abstract Authenticator getAuthenticator();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
        this.propertyChanged();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.propertyChanged();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.propertyChanged();
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String serverName) {
        this.hostname = serverName;
        this.propertyChanged();
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = StringUtils.isNotBlank((String)username) ? username : null;
        this.propertyChanged();
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = StringUtils.isNotBlank((String)password) ? password : null;
        this.propertyChanged();
    }

    public MailProtocol getMailProtocol() {
        return this.mailProtocol;
    }

    public void setMailProtocol(MailProtocol protocol) {
        this.mailProtocol = protocol;
        this.propertyChanged();
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
        this.propertyChanged();
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
        this.propertyChanged();
    }

    public String getSocksHost() {
        return this.socksHost;
    }

    public void setSocksHost(String socksHost) {
        this.socksHost = socksHost;
        this.propertyChanged();
    }

    public String getSocksPort() {
        return this.socksPort;
    }

    public void setSocksPort(String socksPort) {
        this.socksPort = socksPort;
        this.propertyChanged();
    }

    public boolean isTlsRequired() {
        return this.tlsRequired;
    }

    public void setTlsRequired(boolean tlsRequired) {
        this.tlsRequired = tlsRequired;
        this.propertyChanged();
    }

    public Properties getProperties() {
        return this.props;
    }

    public void setProperties(Properties props) {
        this.props = props;
        this.propertyChanged();
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
        this.propertyChanged();
    }

    public void setDebugStream(PrintStream debugStream) {
        this.debugStream = debugStream;
        this.propertyChanged();
    }

    public boolean getDebug() {
        return this.debug;
    }

    public PrintStream getDebugStream() {
        return this.debugStream;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractMailServer)) {
            return false;
        }
        AbstractMailServer abstractMailServer = (AbstractMailServer)o;
        return new EqualsBuilder().append((Object)this.id, (Object)abstractMailServer.id).append((Object)this.name, (Object)abstractMailServer.name).append((Object)this.description, (Object)abstractMailServer.description).append((Object)this.hostname, (Object)abstractMailServer.hostname).append((Object)this.username, (Object)abstractMailServer.username).append((Object)this.password, (Object)abstractMailServer.password).append((Object)this.mailProtocol, (Object)abstractMailServer.mailProtocol).append((Object)this.port, (Object)abstractMailServer.port).append((Object)this.socksHost, (Object)abstractMailServer.socksHost).append((Object)this.socksPort, (Object)abstractMailServer.socksPort).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.id).append((Object)this.name).append((Object)this.description).append((Object)this.hostname).append((Object)this.username).append((Object)this.password).append((Object)this.mailProtocol).append((Object)this.port).append((Object)this.socksHost).append((Object)this.socksPort).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.id).append("name", (Object)this.name).append("description", (Object)this.description).append("server name", (Object)this.hostname).append("username", (Object)this.username).append("password", (Object)(this.password != null ? "***" : "<unset>")).append("socks host", (Object)this.socksHost).append("socks port", (Object)this.socksPort).toString();
    }

    protected void propertyChanged() {
        this.setInitialProperties();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.log = Logger.getLogger(this.getClass());
    }

    protected synchronized Properties loadSystemProperties(Properties p) {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)p);
        props.putAll((Map<?, ?>)System.getProperties());
        if (this.props != null) {
            props.putAll((Map<?, ?>)this.props);
        }
        return props;
    }

    public void setLogger(Logger logger) {
        this.log = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getMoreDebugInfoAboutCreatedSession(Session session) {
        this.log.debug((Object)("Session providers: [" + Arrays.toString(session.getProviders()) + "]"));
        try {
            Field addressMapField = Session.class.getDeclaredField("addressMap");
            boolean originalAccessibility = addressMapField.isAccessible();
            addressMapField.setAccessible(true);
            try {
                this.log.debug((Object)("Session addressMap: [" + addressMapField.get(session) + "]"));
            }
            finally {
                addressMapField.setAccessible(originalAccessibility);
            }
        }
        catch (Exception e) {
            this.log.debug((Object)("Cannot retrieve Session details via reflections: " + e.getMessage()), (Throwable)e);
        }
    }

    protected Session getSessionFromServerManager(Properties props, Authenticator authenticator) throws MailException {
        this.log.debug((Object)"Getting session");
        if (this.getDebug()) {
            this.log.debug((Object)"Debug messages from JavaMail session initialization will not appear in this log. These messages are sent to standard out.");
        }
        Session session = MailFactory.getServerManager().getSession(props, authenticator);
        if (this.log.isDebugEnabled()) {
            this.getMoreDebugInfoAboutCreatedSession(session);
        }
        if (this.getDebugStream() != null) {
            try {
                session.setDebugOut(this.getDebugStream());
            }
            catch (NoSuchMethodError nsme) {
                this.log.error((Object)"Warning: An old (pre-1.3.2) version of the JavaMail library (javamail.jar or mail.jar) bundled with your app server, is in use. Some functions such as IMAPS/POPS/SMTPS will not work. Consider upgrading the app server's javamail jar to the version JIRA provides.");
            }
        }
        return session;
    }
}

