/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.scopes.api;

import com.atlassian.oauth2.scopes.api.Closeable;
import com.atlassian.oauth2.scopes.api.Permission;
import com.atlassian.oauth2.scopes.api.Scope;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface ScopesRequestCache {
    public boolean isScopePermitted(String var1);

    public Closeable withScopes(Scope var1, Supplier<Optional<String>> var2);

    public boolean containsOnlyThisScope(Scope var1);

    public boolean hasPermission(Permission var1);

    @Nonnull
    public Optional<String> getApplicationNameForRequest();

    @Nonnull
    public Set<Permission> getPermissionsForRequest();

    public RequestCache getRequestCache();

    public void setRequestCache(@Nullable RequestCache var1);

    public void clearRequestCache();

    public static class RequestCache {
        private final Set<Permission> permissions;
        private final Supplier<Optional<String>> applicationNameSupplier;
        private final Set<Scope> scopes;

        public RequestCache() {
            this(Collections.emptySet(), Optional::empty, Collections.emptySet());
        }

        public RequestCache(Collection<Permission> permissions, Supplier<Optional<String>> applicationNameSupplier) {
            this(permissions, applicationNameSupplier, Collections.emptySet());
        }

        public RequestCache(Collection<Permission> permissions, Supplier<Optional<String>> applicationNameSupplier, Set<Scope> scopes) {
            this.permissions = new HashSet<Permission>(permissions){

                @Override
                public boolean contains(Object permission) {
                    return this.stream().anyMatch(setPermission -> setPermission.equals(permission));
                }
            };
            this.applicationNameSupplier = applicationNameSupplier != null ? applicationNameSupplier : Optional::empty;
            this.scopes = Collections.unmodifiableSet(scopes);
        }

        public Set<Permission> getPermissions() {
            return this.permissions;
        }

        public Supplier<Optional<String>> getApplicationNameSupplier() {
            return this.applicationNameSupplier;
        }

        public Set<Scope> getScopes() {
            return this.scopes;
        }

        public RequestCache copy() {
            return new RequestCache(this.permissions, this.applicationNameSupplier, this.scopes);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RequestCache that = (RequestCache)o;
            return Objects.equals(this.permissions, that.permissions) && Objects.equals(this.applicationNameSupplier, that.applicationNameSupplier);
        }

        public int hashCode() {
            return Objects.hash(this.permissions, this.applicationNameSupplier);
        }
    }
}

