/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.config.GenericConfigException;
import org.ofbiz.core.config.ResourceHandler;
import org.ofbiz.core.entity.GenericEntityConfException;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericModelException;
import org.ofbiz.core.entity.config.EntityConfigUtil;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelField;
import org.ofbiz.core.entity.model.ModelRelation;
import org.ofbiz.core.entity.model.ModelViewEntity;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.UtilCache;
import org.ofbiz.core.util.UtilTimer;
import org.ofbiz.core.util.UtilXml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ModelReader {
    public static final String module = ModelReader.class.getName();
    public static UtilCache<String, ModelReader> readers = new UtilCache("entity.ModelReader", 0L, 0L);
    protected Map<String, ModelEntity> entityCache = null;
    protected int numEntities = 0;
    protected int numViewEntities = 0;
    protected int numFields = 0;
    protected int numRelations = 0;
    protected String modelName;
    protected Collection<ResourceHandler> entityResourceHandlers;
    protected Map<ResourceHandler, Collection<String>> resourceHandlerEntities;
    protected Map<String, ResourceHandler> entityResourceHandlerMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ModelReader getModelReader(String delegatorName) throws GenericEntityException {
        EntityConfigUtil.DelegatorInfo delegatorInfo = EntityConfigUtil.getInstance().getDelegatorInfo(delegatorName);
        if (delegatorInfo == null) {
            throw new GenericEntityConfException("Could not find a delegator with the name " + delegatorName);
        }
        String tempModelName = delegatorInfo.entityModelReader;
        ModelReader reader = (ModelReader)readers.get((Object)tempModelName);
        if (reader != null) return reader;
        Class<ModelReader> clazz = ModelReader.class;
        synchronized (ModelReader.class) {
            reader = (ModelReader)readers.get((Object)tempModelName);
            if (reader != null) return reader;
            reader = new ModelReader(tempModelName);
            reader.getEntityCache();
            readers.put((Object)tempModelName, (Object)reader);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return reader;
        }
    }

    public ModelReader(String modelName) throws GenericEntityException {
        this.modelName = modelName;
        this.entityResourceHandlers = new LinkedList<ResourceHandler>();
        this.resourceHandlerEntities = new HashMap<ResourceHandler, Collection<String>>();
        this.entityResourceHandlerMap = new HashMap<String, ResourceHandler>();
        EntityConfigUtil.EntityModelReaderInfo entityModelReaderInfo = EntityConfigUtil.getInstance().getEntityModelReaderInfo(modelName);
        if (entityModelReaderInfo == null) {
            throw new GenericEntityConfException("Cound not find an entity-model-reader with the name " + modelName);
        }
        List<Element> resourceElements = entityModelReaderInfo.resourceElements;
        for (Element elem : resourceElements) {
            ResourceHandler handler = new ResourceHandler("entityengine.xml", elem);
            this.entityResourceHandlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<String, ModelEntity> getEntityCache() throws GenericEntityException {
        if (this.entityCache != null) return this.entityCache;
        Class<ModelReader> clazz = ModelReader.class;
        synchronized (ModelReader.class) {
            if (this.entityCache != null) return this.entityCache;
            this.numEntities = 0;
            this.numViewEntities = 0;
            this.numFields = 0;
            this.numRelations = 0;
            this.entityCache = new HashMap<String, ModelEntity>();
            LinkedList<ModelViewEntity> tempViewEntityList = new LinkedList<ModelViewEntity>();
            UtilTimer utilTimer = new UtilTimer();
            for (ResourceHandler handler : this.entityResourceHandlers) {
                Document document = null;
                try {
                    document = handler.getDocument();
                }
                catch (GenericConfigException e) {
                    throw new GenericEntityConfException("Error getting document from resource handler", e);
                }
                if (document == null) {
                    Debug.logError((String)("Could not get document for " + handler.toString()));
                    this.entityCache = null;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return null;
                }
                Hashtable<String, String> docElementValues = new Hashtable<String, String>();
                Element docElement = document.getDocumentElement();
                if (docElement == null) {
                    this.entityCache = null;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return null;
                }
                docElement.normalize();
                Node curChild = docElement.getFirstChild();
                int i = 0;
                if (curChild != null) {
                    utilTimer.timerString("Before start of entity loop in " + handler.toString());
                    do {
                        boolean isEntity = "entity".equals(curChild.getNodeName());
                        boolean isViewEntity = "view-entity".equals(curChild.getNodeName());
                        if (!isEntity && !isViewEntity || curChild.getNodeType() != 1) continue;
                        ++i;
                        Element curEntity = (Element)curChild;
                        String entityName = UtilXml.checkEmpty((String)curEntity.getAttribute("entity-name"));
                        Collection<String> resourceHandlerEntityNames = this.resourceHandlerEntities.get(handler);
                        if (resourceHandlerEntityNames == null) {
                            resourceHandlerEntityNames = new LinkedList<String>();
                            this.resourceHandlerEntities.put(handler, resourceHandlerEntityNames);
                        }
                        resourceHandlerEntityNames.add(entityName);
                        if (this.entityCache.containsKey(entityName)) {
                            Debug.logWarning((String)("WARNING: Entity " + entityName + " is defined more than once, most recent will over-write " + "previous definition(s)"), (String)module);
                            Debug.logWarning((String)("WARNING: Entity " + entityName + " was found in " + handler + ", but was already defined in " + this.entityResourceHandlerMap.get(entityName).toString()), (String)module);
                        }
                        this.entityResourceHandlerMap.put(entityName, handler);
                        ModelEntity entity = null;
                        if (isEntity) {
                            entity = this.createModelEntity(curEntity, docElement, null, docElementValues);
                        } else {
                            ModelViewEntity mve = this.createModelViewEntity(curEntity, docElement, null, docElementValues);
                            entity = mve;
                            tempViewEntityList.add(mve);
                        }
                        if (entity != null) {
                            this.entityCache.put(entityName, entity);
                            if (isEntity) {
                                if (!Debug.verboseOn()) continue;
                                Debug.logVerbose((String)("-- [Entity]: #" + i + ": " + entityName), (String)module);
                                continue;
                            }
                            if (!Debug.verboseOn()) continue;
                            Debug.logVerbose((String)("-- [ViewEntity]: #" + i + ": " + entityName), (String)module);
                            continue;
                        }
                        Debug.logWarning((String)("-- -- ENTITYGEN ERROR:getModelEntity: Could not create entity for entityName: " + entityName), (String)module);
                    } while ((curChild = curChild.getNextSibling()) != null);
                } else {
                    Debug.logWarning((String)"No child nodes found.", (String)module);
                }
                utilTimer.timerString("Finished " + handler.toString() + " - Total Entities: " + i + " FINISHED");
            }
            for (ModelViewEntity curViewEntity : tempViewEntityList) {
                curViewEntity.populateFields(this.entityCache);
            }
            Debug.log((String)("FINISHED LOADING ENTITIES - ALL FILES; #Entities=" + this.numEntities + " #ViewEntities=" + this.numViewEntities + " #Fields=" + this.numFields + " #Relationships=" + this.numRelations), (String)module);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.entityCache;
        }
    }

    public void rebuildResourceHandlerEntities() {
        this.resourceHandlerEntities = new HashMap<ResourceHandler, Collection<String>>();
        for (Map.Entry<String, ResourceHandler> entry : this.entityResourceHandlerMap.entrySet()) {
            Collection<String> resourceHandlerEntityNames = this.resourceHandlerEntities.get(entry.getValue());
            if (resourceHandlerEntityNames == null) {
                resourceHandlerEntityNames = new LinkedList<String>();
                this.resourceHandlerEntities.put(entry.getValue(), resourceHandlerEntityNames);
            }
            resourceHandlerEntityNames.add(entry.getKey());
        }
    }

    public Iterator<ResourceHandler> getResourceHandlerEntitiesKeyIterator() {
        if (this.resourceHandlerEntities == null) {
            return null;
        }
        return this.resourceHandlerEntities.keySet().iterator();
    }

    public Collection<String> getResourceHandlerEntities(ResourceHandler resourceHandler) {
        if (this.resourceHandlerEntities == null) {
            return null;
        }
        return this.resourceHandlerEntities.get(resourceHandler);
    }

    public void addEntityToResourceHandler(String entityName, String loaderName, String location) {
        this.entityResourceHandlerMap.put(entityName, new ResourceHandler("entityengine.xml", loaderName, location));
    }

    public ResourceHandler getEntityResourceHandler(String entityName) {
        return this.entityResourceHandlerMap.get(entityName);
    }

    public ModelEntity getModelEntity(String entityName) throws GenericEntityException {
        Map<String, ModelEntity> ec = this.getEntityCache();
        if (ec == null) {
            throw new GenericEntityConfException("ERROR: Unable to load Entity Cache");
        }
        ModelEntity modelEntity = ec.get(entityName);
        if (modelEntity == null) {
            throw new GenericModelException("Could not find definition for entity name " + entityName);
        }
        return modelEntity;
    }

    public Iterator<String> getEntityNamesIterator() throws GenericEntityException {
        Collection<String> collection = this.getEntityNames();
        if (collection != null) {
            return collection.iterator();
        }
        return null;
    }

    public Collection<String> getEntityNames() throws GenericEntityException {
        Map<String, ModelEntity> ec = this.getEntityCache();
        if (ec == null) {
            throw new GenericEntityConfException("ERROR: Unable to load Entity Cache");
        }
        return ec.keySet();
    }

    ModelEntity createModelEntity(Element entityElement, Element docElement, UtilTimer utilTimer, Hashtable<String, String> docElementValues) {
        if (entityElement == null) {
            return null;
        }
        ++this.numEntities;
        return new ModelEntity(this, entityElement, docElement, utilTimer, docElementValues);
    }

    ModelViewEntity createModelViewEntity(Element entityElement, Element docElement, UtilTimer utilTimer, Hashtable<String, String> docElementValues) {
        if (entityElement == null) {
            return null;
        }
        ++this.numViewEntities;
        return new ModelViewEntity(this, entityElement, docElement, utilTimer, docElementValues);
    }

    public ModelRelation createRelation(ModelEntity entity, Element relationElement) {
        ++this.numRelations;
        return new ModelRelation(entity, relationElement);
    }

    public ModelField findModelField(ModelEntity entity, String fieldName) {
        for (int i = 0; i < entity.fields.size(); ++i) {
            ModelField field = entity.fields.get(i);
            if (field.name.compareTo(fieldName) != 0) continue;
            return field;
        }
        return null;
    }

    public ModelField createModelField(Element fieldElement, Element docElement, Hashtable<String, String> docElementValues) {
        if (fieldElement == null) {
            return null;
        }
        ++this.numFields;
        return new ModelField(fieldElement);
    }
}

