/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityFindOptions;
import org.ofbiz.core.entity.EntityListIterator;
import org.ofbiz.core.entity.GenericDAO;
import org.ofbiz.core.entity.GenericEntity;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericHelper;
import org.ofbiz.core.entity.GenericPK;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.entity.Transformation;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelRelation;
import org.ofbiz.core.util.Debug;

public class GenericHelperDAO
implements GenericHelper {
    public static final String module = GenericHelperDAO.class.getName();
    protected final GenericDAO genericDAO;
    protected final String helperName;

    public GenericHelperDAO(String helperName) {
        this(helperName, GenericDAO.getGenericDAO(helperName));
    }

    public GenericHelperDAO(String helperName, GenericDAO genericDAO) {
        this.helperName = helperName;
        this.genericDAO = genericDAO;
    }

    @Override
    public String getHelperName() {
        return this.helperName;
    }

    @Override
    public GenericValue create(GenericValue value) throws GenericEntityException {
        if (value == null) {
            return null;
        }
        this.genericDAO.insert(value);
        return value;
    }

    @Override
    public GenericValue findByPrimaryKey(GenericPK primaryKey) throws GenericEntityException {
        if (primaryKey == null) {
            return null;
        }
        GenericValue genericValue = new GenericValue(primaryKey);
        this.genericDAO.select(genericValue);
        return genericValue;
    }

    @Override
    public GenericValue findByPrimaryKeyPartial(GenericPK primaryKey, Set<String> keys) throws GenericEntityException {
        if (primaryKey == null) {
            return null;
        }
        GenericValue genericValue = new GenericValue(primaryKey);
        this.genericDAO.partialSelect(genericValue, keys);
        return genericValue;
    }

    @Override
    public List<GenericValue> findAllByPrimaryKeys(List<? extends GenericPK> primaryKeys) throws GenericEntityException {
        if (primaryKeys == null) {
            return null;
        }
        LinkedList<GenericValue> results = new LinkedList<GenericValue>();
        for (GenericPK genericPK : primaryKeys) {
            GenericValue result = this.findByPrimaryKey(genericPK);
            if (result == null) continue;
            results.add(result);
        }
        return results;
    }

    @Override
    public int removeByPrimaryKey(GenericPK primaryKey) throws GenericEntityException {
        if (primaryKey == null) {
            return 0;
        }
        if (Debug.verboseOn()) {
            Debug.logVerbose((String)("Removing GenericPK: " + primaryKey.toString()), (String)module);
        }
        return this.genericDAO.delete(primaryKey);
    }

    @Override
    public List<GenericValue> findByAnd(ModelEntity modelEntity, Map<String, ?> fields, List<String> orderBy) throws GenericEntityException {
        return this.genericDAO.selectByAnd(modelEntity, fields, orderBy);
    }

    @Override
    public List<GenericValue> findByOr(ModelEntity modelEntity, Map<String, ?> fields, List<String> orderBy) throws GenericEntityException {
        return this.genericDAO.selectByOr(modelEntity, fields, orderBy);
    }

    @Override
    public List<GenericValue> findByCondition(ModelEntity modelEntity, EntityCondition entityCondition, Collection<String> fieldsToSelect, List<String> orderBy) throws GenericEntityException {
        return this.genericDAO.selectByCondition(modelEntity, entityCondition, fieldsToSelect, orderBy);
    }

    @Override
    public EntityListIterator findListIteratorByCondition(ModelEntity modelEntity, EntityCondition whereEntityCondition, EntityCondition havingEntityCondition, Collection<String> fieldsToSelect, List<String> orderBy, EntityFindOptions findOptions) throws GenericEntityException {
        return this.genericDAO.selectListIteratorByCondition(modelEntity, whereEntityCondition, havingEntityCondition, fieldsToSelect, orderBy, findOptions);
    }

    @Override
    public List<GenericValue> findByMultiRelation(GenericValue value, ModelRelation modelRelationOne, ModelEntity modelEntityOne, ModelRelation modelRelationTwo, ModelEntity modelEntityTwo, List<String> orderBy) throws GenericEntityException {
        return this.genericDAO.selectByMultiRelation(value, modelRelationOne, modelEntityOne, modelRelationTwo, modelEntityTwo, orderBy);
    }

    @Override
    public int removeByAnd(ModelEntity modelEntity, Map<String, ?> fields) throws GenericEntityException {
        if (modelEntity == null || fields == null) {
            return 0;
        }
        return this.genericDAO.deleteByAnd(modelEntity, fields);
    }

    @Override
    public int removeByCondition(ModelEntity modelEntity, EntityCondition whereCondition) throws GenericEntityException {
        if (modelEntity == null) {
            return 0;
        }
        return this.genericDAO.deleteByCondition(modelEntity, whereCondition);
    }

    @Override
    public int store(GenericValue value) throws GenericEntityException {
        if (value == null) {
            return 0;
        }
        return this.genericDAO.update(value);
    }

    @Override
    public int storeAll(List<? extends GenericValue> values) throws GenericEntityException {
        return this.genericDAO.storeAll(values);
    }

    @Override
    public int removeAll(List<? extends GenericEntity> dummyPKs) throws GenericEntityException {
        return this.genericDAO.deleteAll(dummyPKs);
    }

    @Override
    public void checkDataSource(Map<String, ? extends ModelEntity> modelEntities, Collection<String> messages, boolean addMissing) throws GenericEntityException {
        this.genericDAO.checkDb(modelEntities, messages, addMissing);
    }

    @Override
    public int count(ModelEntity modelEntity, String fieldName, EntityCondition entityCondition, EntityFindOptions findOptions) throws GenericEntityException {
        return this.genericDAO.count(modelEntity, fieldName, entityCondition, findOptions);
    }

    @Override
    public List<GenericValue> transform(ModelEntity modelEntity, EntityCondition entityCondition, List<String> orderBy, String lockField, Transformation transformation) throws GenericEntityException {
        return this.genericDAO.transform(modelEntity, entityCondition, orderBy, lockField, transformation);
    }
}

