/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.jdbc;

import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.ofbiz.core.entity.ConnectionFactory;
import org.ofbiz.core.entity.GenericDataSourceException;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericTransactionException;
import org.ofbiz.core.entity.TransactionUtil;
import org.ofbiz.core.entity.jdbc.ConnectionGuard;
import org.ofbiz.core.entity.jdbc.ExecQueryCallbackFunctionIF;
import org.ofbiz.core.entity.jdbc.SQLInterceptorSupport;
import org.ofbiz.core.entity.jdbc.interceptors.SQLInterceptor;
import org.ofbiz.core.entity.jdbc.interceptors.connection.ConnectionWithSQLInterceptor;
import org.ofbiz.core.util.Debug;

@NotThreadSafe
public class SQLProcessor {
    public static final String module = SQLProcessor.class.getName();
    private String helperName;
    private volatile ConnectionGuard _guard = null;
    private Connection _connection = null;
    private PreparedStatement _ps = null;
    private ResultSet _rs = null;
    private String _sql;
    private int _ind;
    private boolean _manualTX;
    private CommitMode _commitMode;
    private SQLInterceptor _sqlInterceptor;
    private List<String> _parameterValues;

    SQLProcessor(String helperName, CommitMode commitMode) {
        this.helperName = helperName;
        this._manualTX = true;
        this._connection = null;
        this._commitMode = commitMode;
    }

    public SQLProcessor(String helperName) {
        this(helperName, CommitMode.EXPLICIT_COMMIT);
    }

    public SQLProcessor(String helperName, Connection connection) {
        this(helperName, CommitMode.NOT_INVOLVED);
        this._connection = connection;
        this._manualTX = connection == null;
    }

    public CommitMode getCommitMode() {
        return this._commitMode;
    }

    public void commit() throws GenericDataSourceException {
        if (this._connection == null) {
            return;
        }
        if (this._manualTX) {
            try {
                this._connection.commit();
            }
            catch (SQLException sqle) {
                this.rollback();
                Debug.logWarning((String)("[SQLProcessor.commit]: SQL Exception occurred on commit. Error was:" + sqle));
                throw new GenericDataSourceException("SQL Exception occurred on commit", sqle);
            }
        }
    }

    public void rollback() throws GenericDataSourceException {
        block6: {
            if (this._connection == null) {
                return;
            }
            try {
                if (this._manualTX) {
                    this._connection.rollback();
                    break block6;
                }
                try {
                    TransactionUtil.setRollbackOnly();
                }
                catch (GenericTransactionException e) {
                    Debug.logError((Throwable)((Object)e), (String)"Error setting rollback only");
                    throw new GenericDataSourceException("Error setting rollback only", (Throwable)((Object)e));
                }
            }
            catch (SQLException sqle2) {
                Debug.logWarning((String)("[SQLProcessor.rollback]: SQL Exception while rolling back insert. Error was:" + sqle2), (String)module);
                Debug.logWarning((Throwable)sqle2, (String)module);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws GenericDataSourceException {
        try {
            this.smartCommit(this._connection);
        }
        finally {
            this.closeResultSet();
            this.closePreparedStatement();
            this.closeConnection();
        }
    }

    private void closeResultSet() {
        ResultSet rs = this._rs;
        if (rs == null) {
            return;
        }
        this._rs = null;
        try {
            rs.close();
        }
        catch (SQLException sqle) {
            Debug.logWarning((Throwable)sqle, (String)"Error closing ResultSet", (String)module);
        }
    }

    private void closePreparedStatement() {
        PreparedStatement ps = this._ps;
        if (ps == null) {
            return;
        }
        this._ps = null;
        try {
            ps.close();
        }
        catch (SQLException sqle) {
            Debug.logWarning((Throwable)sqle, (String)"Error closing PreparedStatement", (String)module);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnection() {
        ConnectionGuard guard = this._guard;
        if (guard == null) {
            return;
        }
        guard.clear();
        Connection connection = this._connection;
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException sqle) {
            Debug.logWarning((Throwable)sqle, (String)"Error closing Connection", (String)module);
        }
        finally {
            this._guard = null;
            this._connection = null;
        }
    }

    private void smartCommit(Connection connection) throws GenericDataSourceException {
        if (connection == null) {
            return;
        }
        if (this._commitMode != CommitMode.EXPLICIT_COMMIT) {
            return;
        }
        this.commit();
    }

    public Connection getConnection() throws GenericEntityException {
        if (this._connection != null) {
            return this._connection;
        }
        if (TransactionUtil.isTransactionActive()) {
            this._manualTX = false;
            this._commitMode = CommitMode.EXTERNAL_COMMIT;
            this._connection = TransactionUtil.getLocalTransactionConnection();
            this._guard = null;
            return this._connection;
        }
        ConnectionGuard.closeAbandonedProcessors();
        this._manualTX = true;
        try {
            this._connection = ConnectionFactory.getConnection(this.helperName);
            this._guard = this.guard(this._connection);
        }
        catch (SQLException sqle) {
            throw new GenericDataSourceException("Unable to establish a connection with the database.", sqle);
        }
        if (Debug.verboseOn()) {
            int isoLevel = -999;
            try {
                isoLevel = this._connection.getTransactionIsolation();
            }
            catch (SQLException e) {
                Debug.logError((Throwable)e, (String)"Problems getting the connection's isolation level", (String)module);
            }
            if (isoLevel == 0) {
                Debug.logVerbose((String)"Transaction isolation level set to 'None'.", (String)module);
            } else if (isoLevel == 2) {
                Debug.logVerbose((String)"Transaction isolation level set to 'ReadCommited'.", (String)module);
            } else if (isoLevel == 1) {
                Debug.logVerbose((String)"Transaction isolation level set to 'ReadUncommitted'.", (String)module);
            } else if (isoLevel == 4) {
                Debug.logVerbose((String)"Transaction isolation level set to 'RepeatableRead'.", (String)module);
            } else if (isoLevel == 8) {
                Debug.logVerbose((String)"Transaction isolation level set to 'Serializable'.", (String)module);
            }
        }
        this.smartSetAutoCommit(this._connection);
        try {
            if (TransactionUtil.getStatus() == 0) {
                this._manualTX = false;
            }
        }
        catch (GenericTransactionException e) {
            Debug.logWarning((String)("[SQLProcessor.getConnection]: Exception was thrown trying to check transaction status: " + e.toString()), (String)module);
        }
        return this._connection;
    }

    @VisibleForTesting
    ConnectionGuard guard(Connection connection) {
        return ConnectionGuard.register(this, connection);
    }

    private void smartSetAutoCommit(Connection connection) {
        if (this._commitMode == CommitMode.READONLY) {
            return;
        }
        if (this._commitMode == CommitMode.AUTO_COMMIT) {
            this.doSetAutoCommit(connection, true);
        } else {
            this.doSetAutoCommit(connection, false);
        }
    }

    private void doSetAutoCommit(Connection connection, boolean autoCommit) {
        try {
            if (connection.getAutoCommit() != autoCommit) {
                connection.setAutoCommit(autoCommit);
            }
        }
        catch (SQLException sqle) {
            this._manualTX = false;
            this._commitMode = CommitMode.NOT_INVOLVED;
        }
    }

    public void prepareStatement(String sql) throws GenericEntityException {
        this.prepareStatement(sql, false, 0, 0);
    }

    public void prepareStatement(String sql, boolean specifyTypeAndConcur, int resultSetType, int resultSetConcurrency) throws GenericEntityException {
        if (Debug.verboseOn()) {
            Debug.logVerbose((String)("[SQLProcessor.prepareStatement] sql=" + sql), (String)module);
        }
        Connection connection = this.getConnection();
        ConnectionGuard guard = this._guard;
        try {
            if (guard != null) {
                guard.setSql(sql);
            }
            this._sql = sql;
            this._parameterValues = new ArrayList<String>();
            this._ind = 1;
            this._ps = specifyTypeAndConcur ? connection.prepareStatement(sql, resultSetType, resultSetConcurrency) : connection.prepareStatement(sql);
        }
        catch (SQLException sqle) {
            throw new GenericDataSourceException("SQL Exception while executing the following:" + sql, sqle);
        }
    }

    private void beforeExecution() {
        this._sqlInterceptor = this._connection instanceof ConnectionWithSQLInterceptor ? ((ConnectionWithSQLInterceptor)this._connection).getNonNullSQLInterceptor() : SQLInterceptorSupport.getNonNullSQLInterceptor(this.helperName);
        this._sqlInterceptor.beforeExecution(this._sql, this._parameterValues, this._ps);
    }

    private void afterExecution(int rowsUpdated) {
        if (this._sqlInterceptor != null) {
            this._sqlInterceptor.afterSuccessfulExecution(this._sql, this._parameterValues, this._ps, null, rowsUpdated);
            this._sqlInterceptor = null;
        }
    }

    private void afterExecution() {
        if (this._sqlInterceptor != null) {
            this._sqlInterceptor.afterSuccessfulExecution(this._sql, this._parameterValues, this._ps, this._rs, -1);
            this._sqlInterceptor = null;
        }
    }

    private void onException(SQLException sqle) {
        if (this._sqlInterceptor != null) {
            this._sqlInterceptor.onException(this._sql, this._parameterValues, this._ps, sqle);
            this._sqlInterceptor = null;
        }
    }

    public ResultSet executeQuery() throws GenericDataSourceException {
        try {
            this.beforeExecution();
            this._rs = this._ps.executeQuery();
            this.afterExecution();
        }
        catch (SQLException sqle) {
            this.onException(sqle);
            throw new GenericDataSourceException("SQL Exception while executing the following:" + this._sql, sqle);
        }
        return this._rs;
    }

    public ResultSet executeQuery(String sql) throws GenericEntityException {
        this.prepareStatement(sql);
        return this.executeQuery();
    }

    public int executeUpdate() throws GenericDataSourceException {
        this.validateCommitMode();
        try {
            this.beforeExecution();
            int rc = this._ps.executeUpdate();
            this.afterExecution(rc);
            return rc;
        }
        catch (SQLException sqle) {
            this.onException(sqle);
            throw new GenericDataSourceException("SQL Exception while executing the following:" + this._sql, sqle);
        }
    }

    public int executeUpdate(String sql) throws GenericDataSourceException {
        this.validateCommitMode();
        SQLInterceptor sqlInterceptor = SQLInterceptorSupport.getNonNullSQLInterceptor(this.helperName);
        List<String> emptyList = Collections.emptyList();
        Statement stmt = null;
        try {
            stmt = this._connection.createStatement();
            ConnectionGuard guard = this._guard;
            if (guard != null) {
                guard.setSql(sql);
            }
            sqlInterceptor.beforeExecution(sql, emptyList, stmt);
            int rc = stmt.executeUpdate(sql);
            sqlInterceptor.afterSuccessfulExecution(sql, emptyList, stmt, null, rc);
            int n = rc;
            return n;
        }
        catch (SQLException sqle) {
            sqlInterceptor.onException(sql, emptyList, stmt, sqle);
            throw new GenericDataSourceException("SQL Exception while executing the following:" + sql, sqle);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sqle) {
                    Debug.logWarning((String)("Unable to close 'statement': " + sqle.getMessage()), (String)module);
                }
            }
        }
    }

    private void validateCommitMode() {
        if (this._commitMode == CommitMode.READONLY) {
            throw new IllegalStateException("The current CommitMode is READ ONLY and you are trying to perform an UPDATE");
        }
    }

    public boolean next() throws GenericDataSourceException {
        try {
            return this._rs.next();
        }
        catch (SQLException sqle) {
            throw new GenericDataSourceException("SQL Exception while executing the following:" + this._sql, sqle);
        }
    }

    public ResultSet getResultSet() {
        return this._rs;
    }

    public PreparedStatement getPreparedStatement() {
        return this._ps;
    }

    public void execQuery(String sql, ExecQueryCallbackFunctionIF aListener) throws GenericEntityException {
        if (this._connection == null) {
            this.getConnection();
        }
        try {
            if (Debug.verboseOn()) {
                Debug.logVerbose((String)("[SQLProcessor.execQuery]: " + sql), (String)module);
            }
            this.executeQuery(sql);
            boolean keepGoing = true;
            while (keepGoing && this._rs.next()) {
                keepGoing = aListener.processNextRow(this._rs);
            }
            if (this._manualTX) {
                this._connection.commit();
            }
        }
        catch (SQLException sqle) {
            Debug.logWarning((String)("[SQLProcessor.execQuery]: SQL Exception while executing the following:\n" + sql + "\nError was:"), (String)module);
            Debug.logWarning((String)sqle.getMessage(), (String)module);
            throw new GenericEntityException("SQL Exception while executing the following:" + this._sql, sqle);
        }
        finally {
            this.close();
        }
    }

    private void recordParameter(Object field) {
        this._parameterValues.add(String.valueOf(field));
    }

    public void setValue(String field) throws SQLException {
        if (field != null) {
            this._ps.setString(this._ind, field);
        } else {
            this._ps.setNull(this._ind, 12);
        }
        this.recordParameter(field);
        ++this._ind;
    }

    public void setValue(Timestamp field) throws SQLException {
        if (field != null) {
            this._ps.setTimestamp(this._ind, field);
        } else {
            this._ps.setNull(this._ind, 93);
        }
        this.recordParameter(field);
        ++this._ind;
    }

    public void setValue(Time field) throws SQLException {
        if (field != null) {
            this._ps.setTime(this._ind, field);
        } else {
            this._ps.setNull(this._ind, 92);
        }
        this.recordParameter(field);
        ++this._ind;
    }

    public void setValue(Date field) throws SQLException {
        if (field != null) {
            this._ps.setDate(this._ind, field);
        } else {
            this._ps.setNull(this._ind, 91);
        }
        this.recordParameter(field);
        ++this._ind;
    }

    public void setValue(Integer field) throws SQLException {
        if (field != null) {
            this._ps.setInt(this._ind, field);
        } else {
            this._ps.setNull(this._ind, 2);
        }
        this.recordParameter(field);
        ++this._ind;
    }

    public void setValue(Long field) throws SQLException {
        if (field != null) {
            this._ps.setLong(this._ind, field);
        } else {
            this._ps.setNull(this._ind, 2);
        }
        this.recordParameter(field);
        ++this._ind;
    }

    public void setValue(Float field) throws SQLException {
        if (field != null) {
            this._ps.setFloat(this._ind, field.floatValue());
        } else {
            this._ps.setNull(this._ind, 2);
        }
        this.recordParameter(field);
        ++this._ind;
    }

    public void setValue(Double field) throws SQLException {
        if (field != null) {
            this._ps.setDouble(this._ind, field);
        } else {
            this._ps.setNull(this._ind, 2);
        }
        this.recordParameter(field);
        ++this._ind;
    }

    public void setValue(Boolean field) throws SQLException {
        if (field != null) {
            this._ps.setBoolean(this._ind, field);
        } else {
            this._ps.setNull(this._ind, 0);
        }
        this.recordParameter(field);
        ++this._ind;
    }

    public void setValue(Object field) throws SQLException {
        if (field != null) {
            this._ps.setObject(this._ind, field, 2000);
        } else {
            this._ps.setNull(this._ind, 2000);
        }
        this.recordParameter(field);
        ++this._ind;
    }

    public void setValue(Blob field) throws SQLException {
        if (field != null) {
            this._ps.setBlob(this._ind, field);
        } else {
            this._ps.setNull(this._ind, 2004);
        }
        this.recordParameter("BLOB");
        ++this._ind;
    }

    public void setValue(Clob field) throws SQLException {
        if (field != null) {
            this._ps.setClob(this._ind, field);
        } else {
            this._ps.setNull(this._ind, 2005);
        }
        this.recordParameter("CLOB");
        ++this._ind;
    }

    public void setBlob(byte[] field) throws SQLException {
        if (field != null) {
            this._ps.setBinaryStream(this._ind, new ByteArrayInputStream(field));
        } else {
            this._ps.setNull(this._ind, 2004);
        }
        this.recordParameter("BLOB");
        ++this._ind;
    }

    public void setByteArray(byte[] field) throws SQLException {
        if (field != null) {
            this._ps.setBytes(this._ind, field);
        } else {
            this._ps.setNull(this._ind, -4);
        }
        this.recordParameter("byte[]");
        ++this._ind;
    }

    public void setBinaryStream(Object field) throws SQLException {
        if (field != null) {
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(os);
                oos.writeObject(field);
                oos.close();
                byte[] buf = os.toByteArray();
                os.close();
                ByteArrayInputStream is = new ByteArrayInputStream(buf);
                this._ps.setBinaryStream(this._ind, (InputStream)is, buf.length);
                is.close();
            }
            catch (IOException ex) {
                throw new SQLException(ex);
            }
        } else {
            this._ps.setNull(this._ind, 2004);
        }
        this.recordParameter("BLOB");
        ++this._ind;
    }

    public void setByteArrayData(Object field) throws SQLException {
        if (field != null) {
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(os);
                oos.writeObject(field);
                oos.close();
                this._ps.setBytes(this._ind, os.toByteArray());
            }
            catch (IOException ex) {
                throw new SQLException(ex);
            }
        } else {
            this._ps.setNull(this._ind, -4);
        }
        this.recordParameter("BLOB");
        ++this._ind;
    }

    public String toString() {
        return "SQLProcessor[commitMode=" + (Object)((Object)this._commitMode) + ",connection=" + this._connection + ",sql=" + this._sql + ",parameters=" + this._parameterValues + ']';
    }

    public static enum CommitMode {
        READONLY,
        AUTO_COMMIT,
        EXPLICIT_COMMIT,
        NOT_INVOLVED,
        EXTERNAL_COMMIT;

    }
}

