/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.util.UtilXml;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ModelIndex {
    protected ModelEntity mainEntity;
    protected String name;
    protected boolean unique;
    protected List<String> fieldNames = new ArrayList<String>();

    public ModelIndex() {
        this.name = "";
        this.unique = false;
    }

    public ModelIndex(ModelEntity mainEntity, Element indexElement) {
        this.mainEntity = mainEntity;
        this.name = UtilXml.checkEmpty((String)indexElement.getAttribute("name"));
        this.unique = "true".equals(UtilXml.checkEmpty((String)indexElement.getAttribute("unique")));
        NodeList indexFieldList = indexElement.getElementsByTagName("index-field");
        for (int i = 0; i < indexFieldList.getLength(); ++i) {
            Element indexFieldElement = (Element)indexFieldList.item(i);
            if (indexFieldElement.getParentNode() != indexElement) continue;
            String fieldName = indexFieldElement.getAttribute("name");
            this.fieldNames.add(fieldName);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean getUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public ModelEntity getMainEntity() {
        return this.mainEntity;
    }

    public void setMainEntity(ModelEntity mainEntity) {
        this.mainEntity = mainEntity;
    }

    public Iterator<String> getIndexFieldsIterator() {
        return this.fieldNames.iterator();
    }

    public int getIndexFieldsSize() {
        return this.fieldNames.size();
    }

    public String getIndexField(int index) {
        return this.fieldNames.get(index);
    }

    public void addIndexField(String fieldName) {
        this.fieldNames.add(fieldName);
    }

    public String removeIndexField(int index) {
        return this.fieldNames.remove(index);
    }
}

