/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.transaction;

import org.apache.commons.collections.BidiMap;
import org.apache.commons.collections.bidimap.DualHashBidiMap;

public class TransactionIsolations {
    private static final BidiMap ISOLATION_LEVELS = new DualHashBidiMap(){
        {
            this.put("None", 0);
            this.put("ReadUncommitted", 1);
            this.put("ReadCommitted", 2);
            this.put("RepeatableRead", 4);
            this.put("Serializable", 8);
        }
    };

    public static int fromString(String isolationLevel) throws IllegalArgumentException {
        if (!ISOLATION_LEVELS.containsKey((Object)isolationLevel)) {
            throw new IllegalArgumentException("Invalid transaction isolation: " + isolationLevel);
        }
        return (Integer)ISOLATION_LEVELS.get((Object)isolationLevel);
    }

    public static String asString(int isolationLevel) {
        if (!ISOLATION_LEVELS.containsValue((Object)isolationLevel)) {
            throw new IllegalArgumentException("Invalid transaction isolation: " + isolationLevel);
        }
        return (String)ISOLATION_LEVELS.getKey((Object)isolationLevel);
    }

    private TransactionIsolations() {
    }
}

