/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionParam;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.EntityWhereString;
import org.ofbiz.core.entity.GenericModelException;
import org.ofbiz.core.entity.jdbc.sql.escape.SqlEscapeHelper;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelField;

public class EntityExpr
extends EntityCondition {
    private Object lhs;
    private boolean leftUpper = false;
    private EntityOperator operator;
    private Object rhs;
    private boolean rightUpper = false;

    protected EntityExpr() {
    }

    public EntityExpr(String lhs, EntityOperator operator, Object rhs) {
        if (lhs == null) {
            throw new IllegalArgumentException("The field name cannot be null");
        }
        if (operator == null) {
            throw new IllegalArgumentException("The operator argument cannot be null");
        }
        this.lhs = lhs;
        this.operator = operator;
        this.rhs = rhs;
    }

    public EntityExpr(String lhs, boolean leftUpper, EntityOperator operator, Object rhs, boolean rightUpper) {
        this(lhs, operator, rhs);
        this.leftUpper = leftUpper;
        this.rightUpper = rightUpper;
    }

    public EntityExpr(EntityCondition lhs, EntityOperator operator, EntityCondition rhs) {
        if (lhs == null) {
            throw new IllegalArgumentException("The left EntityCondition argument cannot be null");
        }
        if (rhs == null) {
            throw new IllegalArgumentException("The right EntityCondition argument cannot be null");
        }
        if (operator == null) {
            throw new IllegalArgumentException("The operator argument cannot be null");
        }
        this.lhs = lhs;
        this.operator = operator;
        this.rhs = rhs;
    }

    public void setLUpper(boolean upper) {
        this.leftUpper = upper;
    }

    public boolean isLUpper() {
        return this.leftUpper;
    }

    public boolean isRUpper() {
        return this.rightUpper;
    }

    public void setRUpper(boolean upper) {
        this.rightUpper = upper;
    }

    public Object getLhs() {
        return this.lhs;
    }

    public EntityOperator getOperator() {
        return this.operator;
    }

    public Object getRhs() {
        return this.rhs;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String makeWhereString(ModelEntity modelEntity, List<? super EntityConditionParam> entityConditionParams, SqlEscapeHelper sqlEscapeHelper) {
        StringBuilder whereStringBuilder = new StringBuilder();
        if (this.lhs instanceof String) {
            ModelField field = modelEntity.getField((String)this.getLhs());
            if (field == null) throw new IllegalArgumentException("ModelField with field name " + this.getLhs() + " not found");
            if (this.getRhs() == null) {
                whereStringBuilder.append(sqlEscapeHelper.escapeColumn(field.getColName()));
                if (EntityOperator.NOT_EQUAL.equals(this.getOperator())) {
                    whereStringBuilder.append(" IS NOT NULL ");
                    return whereStringBuilder.toString();
                } else {
                    whereStringBuilder.append(" IS NULL ");
                }
                return whereStringBuilder.toString();
            } else {
                if (this.isLUpper()) {
                    whereStringBuilder.append("UPPER(" + sqlEscapeHelper.escapeColumn(field.getColName()) + ")");
                } else {
                    whereStringBuilder.append(sqlEscapeHelper.escapeColumn(field.getColName()));
                }
                whereStringBuilder.append(' ');
                whereStringBuilder.append(this.getOperator().toString());
                whereStringBuilder.append(' ');
                if (EntityOperator.IN.equals(this.getOperator())) {
                    whereStringBuilder.append('(');
                    if (this.rhs instanceof Collection) {
                        Iterator rhsIter = ((Collection)this.rhs).iterator();
                        while (rhsIter.hasNext()) {
                            void var7_7;
                            Object e = rhsIter.next();
                            whereStringBuilder.append('?');
                            if (rhsIter.hasNext()) {
                                whereStringBuilder.append(", ");
                            }
                            if (this.isRUpper() && e instanceof String) {
                                String string = ((String)e).toUpperCase();
                            }
                            entityConditionParams.add(new EntityConditionParam(field, var7_7));
                        }
                    } else if (this.rhs instanceof EntityWhereString) {
                        whereStringBuilder.append(" " + ((EntityWhereString)this.rhs).makeWhereString(modelEntity, Collections.emptyList(), sqlEscapeHelper) + " ");
                    } else {
                        whereStringBuilder.append(" ? ");
                        if (this.isRUpper() && this.rhs instanceof String) {
                            this.rhs = ((String)this.rhs).toUpperCase();
                        }
                        entityConditionParams.add(new EntityConditionParam(field, this.rhs));
                    }
                    whereStringBuilder.append(") ");
                    return whereStringBuilder.toString();
                } else {
                    whereStringBuilder.append(" ? ");
                    if (this.isRUpper() && this.rhs instanceof String) {
                        this.rhs = ((String)this.rhs).toUpperCase();
                    }
                    entityConditionParams.add(new EntityConditionParam(field, this.rhs));
                }
            }
            return whereStringBuilder.toString();
        } else {
            if (!(this.lhs instanceof EntityCondition)) return whereStringBuilder.toString();
            whereStringBuilder.append('(');
            whereStringBuilder.append(((EntityCondition)this.lhs).makeWhereString(modelEntity, entityConditionParams, sqlEscapeHelper));
            whereStringBuilder.append(") ");
            whereStringBuilder.append(this.getOperator().toString());
            whereStringBuilder.append(" (");
            whereStringBuilder.append(((EntityCondition)this.rhs).makeWhereString(modelEntity, entityConditionParams, sqlEscapeHelper));
            whereStringBuilder.append(')');
        }
        return whereStringBuilder.toString();
    }

    @Override
    public void checkCondition(ModelEntity modelEntity) throws GenericModelException {
        if (this.lhs instanceof String) {
            if (modelEntity.getField((String)this.lhs) == null) {
                throw new GenericModelException("Field with name " + this.lhs + " not found in the " + modelEntity.getEntityName() + " Entity");
            }
        } else if (this.lhs instanceof EntityCondition) {
            ((EntityCondition)this.lhs).checkCondition(modelEntity);
            ((EntityCondition)this.rhs).checkCondition(modelEntity);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getParameterCount(ModelEntity modelEntity, SqlEscapeHelper sqlEscapeHelper) {
        int parameterCount = 0;
        if (this.lhs instanceof String) {
            ModelField field = modelEntity.getField((String)this.getLhs());
            if (field == null) throw new IllegalArgumentException("ModelField with field name " + this.getLhs() + " not found");
            if (this.getRhs() == null) return parameterCount;
            parameterCount = EntityOperator.IN.equals(this.getOperator()) ? (this.rhs instanceof Collection ? (parameterCount += ((Collection)this.rhs).size()) : (this.rhs instanceof EntityWhereString ? (parameterCount += ((EntityWhereString)this.rhs).getParameterCount(modelEntity, sqlEscapeHelper)) : ++parameterCount)) : ++parameterCount;
            return parameterCount;
        } else {
            if (!(this.lhs instanceof EntityCondition)) return parameterCount;
            EntityCondition lhsCondition = (EntityCondition)this.lhs;
            EntityCondition rhsCondition = (EntityCondition)this.rhs;
            parameterCount += lhsCondition.getParameterCount(modelEntity, sqlEscapeHelper);
            parameterCount += rhsCondition.getParameterCount(modelEntity, sqlEscapeHelper);
        }
        return parameterCount;
    }

    public String toString() {
        return "[Expr::" + this.lhs + "::" + this.operator + "::" + this.rhs + "]";
    }
}

