/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity;

import com.atlassian.util.concurrent.CopyOnWriteMap;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.CountHelper;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionHelper;
import org.ofbiz.core.entity.EntityConditionParam;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityExprList;
import org.ofbiz.core.entity.EntityFieldMap;
import org.ofbiz.core.entity.EntityFindOptions;
import org.ofbiz.core.entity.EntityListIterator;
import org.ofbiz.core.entity.EntityLockedException;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.EntityWhereString;
import org.ofbiz.core.entity.GenericDataSourceException;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.entity.GenericEntity;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericEntityNotFoundException;
import org.ofbiz.core.entity.GenericModelException;
import org.ofbiz.core.entity.GenericNotImplementedException;
import org.ofbiz.core.entity.GenericPK;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.entity.LimitHelper;
import org.ofbiz.core.entity.Transformation;
import org.ofbiz.core.entity.config.DatasourceInfo;
import org.ofbiz.core.entity.config.EntityConfigUtil;
import org.ofbiz.core.entity.jdbc.AutoCommitSQLProcessor;
import org.ofbiz.core.entity.jdbc.DatabaseUtil;
import org.ofbiz.core.entity.jdbc.ExplicitCommitSQLProcessor;
import org.ofbiz.core.entity.jdbc.PassThruSQLProcessor;
import org.ofbiz.core.entity.jdbc.ReadOnlySQLProcessor;
import org.ofbiz.core.entity.jdbc.SQLProcessor;
import org.ofbiz.core.entity.jdbc.SqlJdbcUtil;
import org.ofbiz.core.entity.jdbc.dbtype.DatabaseType;
import org.ofbiz.core.entity.jdbc.dbtype.DatabaseTypeFactory;
import org.ofbiz.core.entity.jdbc.sql.escape.SqlEscapeHelper;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelField;
import org.ofbiz.core.entity.model.ModelFieldTypeReader;
import org.ofbiz.core.entity.model.ModelKeyMap;
import org.ofbiz.core.entity.model.ModelRelation;
import org.ofbiz.core.entity.model.ModelViewEntity;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.UtilDateTime;
import org.ofbiz.core.util.UtilValidate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericDAO {
    public static final String module = GenericDAO.class.getName();
    public static final int ORACLE_MAX_LIST_SIZE = 1000;
    public static final int MS_SQL_MAX_PARAMETER_COUNT = 2000;
    public static final int POSTGRESQL_MAX_PARAMETER_COUNT = 30000;
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericDAO.class);
    private static final int MAX_BACK_OFF_MILLIS = 30;
    protected static Map<String, GenericDAO> genericDAOs = CopyOnWriteMap.newHashMap();
    protected String helperName;
    protected ModelFieldTypeReader modelFieldTypeReader;
    protected DatasourceInfo datasourceInfo;
    private final LimitHelper limitHelper;
    private final CountHelper countHelper;
    private final SqlEscapeHelper sqlEscapeHelper;

    public static synchronized void removeGenericDAO(String helperName) {
        genericDAOs.remove(helperName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GenericDAO getGenericDAO(String helperName) {
        GenericDAO newGenericDAO = genericDAOs.get(helperName);
        if (newGenericDAO != null) return newGenericDAO;
        Class<GenericDAO> clazz = GenericDAO.class;
        synchronized (GenericDAO.class) {
            newGenericDAO = genericDAOs.get(helperName);
            if (newGenericDAO != null) return newGenericDAO;
            newGenericDAO = new GenericDAO(helperName);
            genericDAOs.put(helperName, newGenericDAO);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return newGenericDAO;
        }
    }

    private static long zeroTo(long maximum) {
        return (long)(Math.random() * (double)maximum);
    }

    public GenericDAO(String helperName) {
        this.helperName = helperName;
        this.modelFieldTypeReader = ModelFieldTypeReader.getModelFieldTypeReader(helperName);
        this.datasourceInfo = EntityConfigUtil.getInstance().getDatasourceInfo(helperName);
        this.sqlEscapeHelper = new SqlEscapeHelper(this.datasourceInfo);
        this.limitHelper = new LimitHelper(this.datasourceInfo.getFieldTypeName());
        this.countHelper = new CountHelper();
    }

    @VisibleForTesting
    GenericDAO(String helperName, ModelFieldTypeReader modelFieldTypeReader, DatasourceInfo datasourceInfo, LimitHelper limitHelper, CountHelper countHelper) {
        this.helperName = helperName;
        this.modelFieldTypeReader = modelFieldTypeReader;
        this.datasourceInfo = datasourceInfo;
        this.limitHelper = limitHelper;
        this.countHelper = countHelper;
        this.sqlEscapeHelper = new SqlEscapeHelper(datasourceInfo);
    }

    public int insert(GenericEntity entity) throws GenericEntityException {
        ModelEntity modelEntity = entity.getModelEntity();
        if (modelEntity == null) {
            throw new GenericModelException("Could not find ModelEntity record for entityName: " + entity.getEntityName());
        }
        AutoCommitSQLProcessor sqlP = new AutoCommitSQLProcessor(this.helperName);
        try {
            int n = this.singleInsert(entity, modelEntity, modelEntity.getFieldsCopy(), sqlP.getConnection());
            return n;
        }
        catch (GenericDataSourceException e) {
            sqlP.rollback();
            throw new GenericDataSourceException("Exception while inserting the following entity: " + entity.toString(), (Throwable)((Object)e));
        }
        finally {
            GenericDAO.closeSafely(entity, sqlP);
        }
    }

    private int singleInsert(GenericEntity entity, ModelEntity modelEntity, List<ModelField> fieldsToSave, Connection connection) throws GenericEntityException {
        if (modelEntity instanceof ModelViewEntity) {
            return this.singleUpdateView(entity, (ModelViewEntity)modelEntity, fieldsToSave, connection);
        }
        if (modelEntity.isField("lastUpdatedStamp")) {
            entity.set("lastUpdatedStamp", UtilDateTime.nowTimestamp());
        }
        String sql = "INSERT INTO " + modelEntity.getTableName(this.datasourceInfo) + " (" + modelEntity.colNameString(fieldsToSave, this.sqlEscapeHelper) + ") VALUES (" + modelEntity.fieldsStringList(fieldsToSave, "?", ", ") + ")";
        PassThruSQLProcessor sqlP = new PassThruSQLProcessor(this.helperName, connection);
        try {
            sqlP.prepareStatement(sql);
            SqlJdbcUtil.setValues(sqlP, fieldsToSave, entity, this.modelFieldTypeReader);
            int retVal = sqlP.executeUpdate();
            entity.modified = false;
            if (entity instanceof GenericValue) {
                ((GenericValue)entity).copyOriginalDbValues();
            }
            int n = retVal;
            return n;
        }
        catch (GenericEntityException e) {
            throw new GenericEntityException("while inserting: " + entity.toString(), (Throwable)((Object)e));
        }
        finally {
            GenericDAO.closeSafely(sql, sqlP);
        }
    }

    public int updateAll(GenericEntity entity) throws GenericEntityException {
        ModelEntity modelEntity = entity.getModelEntity();
        if (modelEntity == null) {
            throw new GenericModelException("Could not find ModelEntity record for entityName: " + entity.getEntityName());
        }
        return this.customUpdate(entity, modelEntity, modelEntity.getNopksCopy(), null);
    }

    public int update(GenericEntity entity) throws GenericEntityException {
        return this.update(entity, null);
    }

    public int update(GenericEntity entity, EntityConditionParam nonPkCondition) throws GenericEntityException {
        ModelEntity modelEntity = entity.getModelEntity();
        if (modelEntity == null) {
            throw new GenericModelException("Could not find ModelEntity for entityName: " + entity.getEntityName());
        }
        ArrayList<ModelField> partialFields = new ArrayList<ModelField>();
        Collection<String> keys = entity.getAllKeys();
        for (int fi = 0; fi < modelEntity.getNopksSize(); ++fi) {
            ModelField curField = modelEntity.getNopk(fi);
            if (!keys.contains(curField.getName())) continue;
            partialFields.add(curField);
        }
        return this.customUpdate(entity, modelEntity, partialFields, nonPkCondition);
    }

    private int customUpdate(GenericEntity entity, ModelEntity modelEntity, List<ModelField> fieldsToSave, EntityConditionParam nonPkCondition) throws GenericEntityException {
        AutoCommitSQLProcessor sqlP = new AutoCommitSQLProcessor(this.helperName);
        try {
            int n = this.singleUpdate(entity, modelEntity, fieldsToSave, sqlP.getConnection(), nonPkCondition);
            return n;
        }
        catch (GenericDataSourceException e) {
            sqlP.rollback();
            throw new GenericDataSourceException("Exception while updating the following entity: " + entity.toString(), (Throwable)((Object)e));
        }
        finally {
            GenericDAO.closeSafely("customUpdate (outer)", sqlP);
        }
    }

    private int singleUpdate(GenericEntity entity, ModelEntity modelEntity, List<ModelField> fieldsToSave, Connection connection, EntityConditionParam nonPkCondition) throws GenericEntityException {
        if (modelEntity instanceof ModelViewEntity) {
            return this.singleUpdateView(entity, (ModelViewEntity)modelEntity, fieldsToSave, connection);
        }
        if (fieldsToSave.isEmpty()) {
            if (Debug.verboseOn()) {
                Debug.logVerbose((String)("Trying to do an update on an entity with no non-PK fields, returning having done nothing; entity=" + entity));
            }
            return 1;
        }
        if (modelEntity.lock()) {
            GenericEntity entityCopy = new GenericEntity(entity);
            this.select(entityCopy, connection);
            Object stampField = entity.get("lastUpdatedStamp");
            if (stampField != null && !stampField.equals(entityCopy.get("lastUpdatedStamp"))) {
                String lockedTime = entityCopy.getTimestamp("lastUpdatedStamp").toString();
                throw new EntityLockedException("You tried to update an old version of this data. Version locked: (" + lockedTime + ")");
            }
        }
        if (modelEntity.isField("lastUpdatedStamp")) {
            entity.set("lastUpdatedStamp", UtilDateTime.nowTimestamp());
        }
        List<ModelField> whereFields = modelEntity.getPksCopy();
        if (nonPkCondition != null) {
            whereFields.add(nonPkCondition.getModelField());
        }
        String sql = String.format("UPDATE %s SET %s WHERE %s", modelEntity.getTableName(this.datasourceInfo), modelEntity.colNameString(fieldsToSave, "=?, ", "=?", this.sqlEscapeHelper), SqlJdbcUtil.makeWhereStringFromFields(whereFields, entity, "AND", this.sqlEscapeHelper));
        PassThruSQLProcessor sqlP = new PassThruSQLProcessor(this.helperName, connection);
        int retVal = 0;
        try {
            sqlP.prepareStatement(sql);
            SqlJdbcUtil.setValues(sqlP, fieldsToSave, entity, this.modelFieldTypeReader);
            SqlJdbcUtil.setPkValues(sqlP, modelEntity, entity, this.modelFieldTypeReader);
            if (nonPkCondition != null) {
                SqlJdbcUtil.setValue(sqlP, nonPkCondition.getModelField(), modelEntity.getEntityName(), nonPkCondition.getFieldValue(), this.modelFieldTypeReader);
            }
            retVal = sqlP.executeUpdate();
            entity.modified = false;
            if (entity instanceof GenericValue) {
                ((GenericValue)entity).copyOriginalDbValues();
            }
        }
        catch (GenericEntityException e) {
            throw new GenericEntityException("while updating: " + entity.toString(), (Throwable)((Object)e));
        }
        finally {
            GenericDAO.closeSafely(sql, sqlP);
        }
        if (retVal == 0) {
            throw new GenericEntityNotFoundException("Tried to update an entity that does not exist.");
        }
        return retVal;
    }

    private int singleStore(GenericEntity entity, Connection connection) throws GenericEntityException {
        GenericPK tempPK = entity.getPrimaryKey();
        ModelEntity modelEntity = entity.getModelEntity();
        try {
            this.select(tempPK, connection);
        }
        catch (GenericEntityNotFoundException e) {
            return this.singleInsert(entity, modelEntity, modelEntity.getFieldsCopy(), connection);
        }
        ArrayList<ModelField> partialFields = new ArrayList<ModelField>();
        Collection<String> keys = entity.getAllKeys();
        for (int fi = 0; fi < modelEntity.getNopksSize(); ++fi) {
            ModelField curField = modelEntity.getNopk(fi);
            if (!keys.contains(curField.getName())) continue;
            if (entity.get(curField.getName()) == null) {
                if (tempPK.get(curField.getName()) == null) continue;
                partialFields.add(curField);
                continue;
            }
            if (entity.get(curField.getName()).equals(tempPK.get(curField.getName()))) continue;
            partialFields.add(curField);
        }
        return this.singleUpdate(entity, modelEntity, partialFields, connection, null);
    }

    public int storeAll(List<? extends GenericEntity> entities) throws GenericEntityException {
        if (entities == null || entities.isEmpty()) {
            return 0;
        }
        ExplicitCommitSQLProcessor sqlP = new ExplicitCommitSQLProcessor(this.helperName);
        try {
            int totalStored = 0;
            for (GenericEntity genericEntity : entities) {
                totalStored += this.singleStore(genericEntity, sqlP.getConnection());
            }
            int n = totalStored;
            return n;
        }
        catch (GenericDataSourceException e) {
            sqlP.rollback();
            throw new GenericDataSourceException("Exception occurred in storeAll", (Throwable)((Object)e));
        }
        finally {
            GenericDAO.closeSafely(entities, sqlP);
        }
    }

    private int singleUpdateView(GenericEntity entity, ModelViewEntity modelViewEntity, List<ModelField> fieldsToSave, Connection connection) throws GenericEntityException {
        GenericDelegator delegator = entity.getDelegator();
        int retVal = 0;
        ModelEntity memberModelEntity = null;
        Iterator<Map.Entry<String, ModelViewEntity.ModelMemberEntity>> meIter = modelViewEntity.getMemberModelMemberEntities().entrySet().iterator();
        while (meIter != null && meIter.hasNext()) {
            Map.Entry<String, ModelViewEntity.ModelMemberEntity> meMapEntry = meIter.next();
            ModelViewEntity.ModelMemberEntity modelMemberEntity = meMapEntry.getValue();
            String meName = modelMemberEntity.getEntityName();
            String meAlias = modelMemberEntity.getEntityAlias();
            if (Debug.verboseOn()) {
                Debug.logVerbose((String)("[singleUpdateView]: Processing MemberEntity " + meName + " with Alias " + meAlias));
            }
            try {
                memberModelEntity = delegator.getModelReader().getModelEntity(meName);
            }
            catch (GenericEntityException e) {
                throw new GenericEntityException("Failed to get model entity for " + meName, (Throwable)((Object)e));
            }
            Hashtable<String, Object> findByMap = new Hashtable<String, Object>();
            Iterator<ModelViewEntity.ModelViewLink> linkIter = modelViewEntity.getViewLinksIterator();
            while (linkIter != null && linkIter.hasNext()) {
                ModelViewEntity.ModelViewLink modelViewLink = linkIter.next();
                if (!modelViewLink.getEntityAlias().equals(meAlias) && !modelViewLink.getRelEntityAlias().equals(meAlias)) continue;
                Iterator<ModelKeyMap> kmIter = modelViewLink.getKeyMapsIterator();
                while (kmIter != null && kmIter.hasNext()) {
                    ModelKeyMap keyMap = kmIter.next();
                    String fieldName = "";
                    fieldName = modelViewLink.getEntityAlias().equals(meAlias) ? keyMap.getFieldName() : keyMap.getRelFieldName();
                    if (Debug.verboseOn()) {
                        Debug.logVerbose((String)("[singleUpdateView]: --- Found field to set: " + meAlias + "." + fieldName));
                    }
                    Object value = null;
                    if (modelViewEntity.isField(keyMap.getFieldName())) {
                        value = entity.get(keyMap.getFieldName());
                        if (Debug.verboseOn()) {
                            Debug.logVerbose((String)("[singleUpdateView]: --- Found map value: " + value.toString()));
                        }
                    } else if (modelViewEntity.isField(keyMap.getRelFieldName())) {
                        value = entity.get(keyMap.getRelFieldName());
                        if (Debug.verboseOn()) {
                            Debug.logVerbose((String)("[singleUpdateView]: --- Found map value: " + value.toString()));
                        }
                    } else {
                        throw new GenericNotImplementedException("Update on view entities: no direct link found, unable to update");
                    }
                    findByMap.put(fieldName, value);
                }
            }
            List<GenericValue> meResult = null;
            try {
                meResult = delegator.findByAnd(meName, findByMap);
            }
            catch (GenericEntityException e) {
                throw new GenericEntityException("Error while retrieving partial results for entity member: " + meName, (Throwable)((Object)e));
            }
            if (Debug.verboseOn()) {
                Debug.logVerbose((String)("[singleUpdateView]: --- Found " + meResult.size() + " results for entity member " + meName));
            }
            GenericValue meGenericValue = null;
            if (meResult.size() == 0) {
                try {
                    meGenericValue = delegator.makeValue(meName, findByMap);
                }
                catch (Exception e) {
                    throw new GenericEntityException("Could not create new value for member entity" + meName + " of view " + modelViewEntity.getEntityName(), e);
                }
            } else if (meResult.size() == 1) {
                meGenericValue = meResult.iterator().next();
            } else {
                throw new GenericEntityException("Found more than one result for member entity " + meName + " in view " + modelViewEntity.getEntityName() + " - this is no updatable view");
            }
            Vector<ModelField> meFieldsToSave = new Vector<ModelField>();
            Iterator<ModelField> fieldIter = fieldsToSave.iterator();
            while (fieldIter != null && fieldIter.hasNext()) {
                ModelField modelField = fieldIter.next();
                if (!memberModelEntity.isField(modelField.getName())) continue;
                ModelField meModelField = memberModelEntity.getField(modelField.getName());
                if (meModelField != null) {
                    meGenericValue.set(meModelField.getName(), entity.get(modelField.getName()));
                    meFieldsToSave.add(meModelField);
                    if (!Debug.verboseOn()) continue;
                    Debug.logVerbose((String)("[singleUpdateView]: --- Added field to save: " + meModelField.getName() + " with value " + meGenericValue.get(meModelField.getName())));
                    continue;
                }
                throw new GenericEntityException("Could not get field " + modelField.getName() + " from model entity " + memberModelEntity.getEntityName());
            }
            if (meResult.size() == 0) {
                retVal += this.singleInsert(meGenericValue, memberModelEntity, memberModelEntity.getFieldsCopy(), connection);
                continue;
            }
            if (meFieldsToSave.size() > 0) {
                retVal += this.singleUpdate(meGenericValue, memberModelEntity, meFieldsToSave, connection, null);
                continue;
            }
            if (!Debug.verboseOn()) continue;
            Debug.logVerbose((String)("[singleUpdateView]: No update on member entity " + memberModelEntity.getEntityName() + " needed"));
        }
        return retVal;
    }

    public void select(GenericEntity entity) throws GenericEntityException {
        ReadOnlySQLProcessor sqlP = new ReadOnlySQLProcessor(this.helperName);
        try {
            this.select(entity, sqlP.getConnection());
        }
        finally {
            GenericDAO.closeSafely(entity, sqlP);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void select(GenericEntity entity, Connection connection) throws GenericEntityException {
        block10: {
            ModelEntity modelEntity = entity.getModelEntity();
            if (modelEntity == null) {
                throw new GenericModelException("Could not find ModelEntity record for entityName: " + entity.getEntityName());
            }
            if (modelEntity.getPksSize() <= 0) {
                throw new GenericEntityException("Entity has no primary keys, cannot select by primary key");
            }
            StringBuilder sqlBuffer = new StringBuilder(256).append("SELECT ");
            if (modelEntity.getNopksSize() > 0) {
                sqlBuffer.append(modelEntity.colNameString(modelEntity.getNopksCopy(), ", ", "", this.sqlEscapeHelper));
            } else {
                sqlBuffer.append('*');
            }
            sqlBuffer.append(SqlJdbcUtil.makeFromClause(modelEntity, this.datasourceInfo, this.sqlEscapeHelper));
            sqlBuffer.append(SqlJdbcUtil.makeWhereClause(modelEntity, modelEntity.getPksCopy(), entity, "AND", this.datasourceInfo.getJoinStyle(), this.sqlEscapeHelper));
            String sql = sqlBuffer.toString();
            PassThruSQLProcessor sqlP = new PassThruSQLProcessor(this.helperName, connection);
            try {
                sqlP.prepareStatement(sql, true, 1003, 1007);
                SqlJdbcUtil.setPkValues(sqlP, modelEntity, entity, this.modelFieldTypeReader);
                sqlP.executeQuery();
                if (sqlP.next()) {
                    for (int j = 0; j < modelEntity.getNopksSize(); ++j) {
                        ModelField curField = modelEntity.getNopk(j);
                        SqlJdbcUtil.getValue(sqlP.getResultSet(), j + 1, curField, entity, this.modelFieldTypeReader);
                    }
                    entity.modified = false;
                    if (entity instanceof GenericValue) {
                        ((GenericValue)entity).copyOriginalDbValues();
                    }
                    break block10;
                }
                throw new GenericEntityNotFoundException("Result set was empty for entity: " + entity.toString());
            }
            finally {
                GenericDAO.closeSafely(sql, sqlP);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void partialSelect(GenericEntity entity, Set<String> keys) throws GenericEntityException {
        block12: {
            ModelEntity modelEntity = entity.getModelEntity();
            if (modelEntity == null) {
                throw new GenericModelException("Could not find ModelEntity record for entityName: " + entity.getEntityName());
            }
            if (modelEntity instanceof ModelViewEntity) {
                throw new GenericNotImplementedException("Operation partialSelect not supported yet for view entities");
            }
            ArrayList<ModelField> partialFields = new ArrayList<ModelField>();
            TreeSet<String> tempKeys = new TreeSet<String>(keys);
            for (int fi = 0; fi < modelEntity.getNopksSize(); ++fi) {
                ModelField curField = modelEntity.getNopk(fi);
                if (!tempKeys.contains(curField.getName())) continue;
                partialFields.add(curField);
                tempKeys.remove(curField.getName());
            }
            if (tempKeys.size() > 0) {
                throw new GenericModelException("In partialSelect invalid field names specified: " + ((Object)tempKeys).toString());
            }
            StringBuilder sqlBuffer = new StringBuilder("SELECT ");
            if (partialFields.size() > 0) {
                sqlBuffer.append(modelEntity.colNameString(partialFields, ", ", "", this.sqlEscapeHelper));
            } else {
                sqlBuffer.append('*');
            }
            sqlBuffer.append(SqlJdbcUtil.makeFromClause(modelEntity, this.datasourceInfo, this.sqlEscapeHelper));
            sqlBuffer.append(SqlJdbcUtil.makeWhereClause(modelEntity, modelEntity.getPksCopy(), entity, "AND", this.datasourceInfo.getJoinStyle(), this.sqlEscapeHelper));
            String sql = sqlBuffer.toString();
            ReadOnlySQLProcessor sqlP = new ReadOnlySQLProcessor(this.helperName);
            try {
                sqlP.prepareStatement(sql, true, 1003, 1007);
                SqlJdbcUtil.setPkValues(sqlP, modelEntity, entity, this.modelFieldTypeReader);
                sqlP.executeQuery();
                if (sqlP.next()) {
                    for (int j = 0; j < partialFields.size(); ++j) {
                        ModelField curField = (ModelField)partialFields.get(j);
                        SqlJdbcUtil.getValue(sqlP.getResultSet(), j + 1, curField, entity, this.modelFieldTypeReader);
                    }
                    entity.modified = false;
                    if (entity instanceof GenericValue) {
                        ((GenericValue)entity).copyOriginalDbValues();
                    }
                    break block12;
                }
                throw new GenericEntityNotFoundException("Result set was empty for entity: " + entity.toString());
            }
            finally {
                GenericDAO.closeSafely(sql, sqlP);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GenericValue> selectByAnd(ModelEntity modelEntity, Map<String, ?> fields, List<String> orderBy) throws GenericEntityException {
        if (modelEntity == null) {
            return null;
        }
        EntityFieldMap entityCondition = null;
        if (fields != null) {
            entityCondition = new EntityFieldMap(fields, EntityOperator.AND);
        }
        try (EntityListIterator entityListIterator = null;){
            entityListIterator = this.selectListIteratorByCondition(modelEntity, entityCondition, null, null, orderBy, null);
            List<GenericValue> list = entityListIterator.getCompleteList();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GenericValue> selectByOr(ModelEntity modelEntity, Map<String, ?> fields, List<String> orderBy) throws GenericEntityException {
        if (modelEntity == null) {
            return null;
        }
        EntityFieldMap entityCondition = null;
        if (fields != null) {
            entityCondition = new EntityFieldMap(fields, EntityOperator.OR);
        }
        try (EntityListIterator entityListIterator = null;){
            entityListIterator = this.selectListIteratorByCondition(modelEntity, entityCondition, null, null, orderBy, null);
            List<GenericValue> list = entityListIterator.getCompleteList();
            return list;
        }
    }

    public List<GenericValue> selectByCondition(ModelEntity modelEntity, EntityCondition entityCondition, Collection<String> fieldsToSelect, List<String> orderBy) throws GenericEntityException {
        return this.selectByCondition(modelEntity, entityCondition, fieldsToSelect, orderBy, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GenericValue> selectByCondition(ModelEntity modelEntity, EntityCondition entityCondition, Collection<String> fieldsToSelect, List<String> orderBy, EntityFindOptions findOptions) throws GenericEntityException {
        try (EntityListIterator entityListIterator = null;){
            entityListIterator = this.selectListIteratorByCondition(modelEntity, entityCondition, null, fieldsToSelect, orderBy, findOptions);
            List<GenericValue> list = entityListIterator.getCompleteList();
            return list;
        }
    }

    public EntityListIterator selectListIteratorByCondition(ModelEntity modelEntity, EntityCondition whereEntityCondition, EntityCondition havingEntityCondition, Collection<String> fieldsToSelect, List<String> orderBy, EntityFindOptions findOptions) throws GenericEntityException {
        if (modelEntity == null) {
            return null;
        }
        EntityFindOptions nonNullFindOptions = findOptions == null ? new EntityFindOptions() : findOptions;
        DatabaseType databaseType = this.datasourceInfo.getDatabaseTypeFromJDBCConnection();
        if (databaseType == DatabaseTypeFactory.ORACLE_8I || databaseType == DatabaseTypeFactory.ORACLE_10G) {
            whereEntityCondition = GenericDAO.rewriteConditionToSplitListsLargerThan(whereEntityCondition, 1000);
        }
        InQueryRewritter inQueryRewritter = new InQueryRewritter(databaseType, whereEntityCondition, modelEntity, this.sqlEscapeHelper);
        whereEntityCondition = inQueryRewritter.rewriteIfNeeded();
        if (Debug.verboseOn()) {
            Debug.logVerbose((String)("Doing selectListIteratorByCondition with whereEntityCondition: " + whereEntityCondition));
        }
        List<ModelField> selectFields = this.getSelectFields(modelEntity, fieldsToSelect);
        LinkedList<EntityConditionParam> whereEntityConditionParams = new LinkedList<EntityConditionParam>();
        LinkedList<EntityConditionParam> havingEntityConditionParams = new LinkedList<EntityConditionParam>();
        String sql = this.getSelectQuery(selectFields, nonNullFindOptions, modelEntity, orderBy, whereEntityCondition, havingEntityCondition, whereEntityConditionParams, havingEntityConditionParams, databaseType);
        SQLProcessor sqlP = inQueryRewritter.isRewritten() ? new SQLProcessor(this.helperName) : new ReadOnlySQLProcessor(this.helperName);
        inQueryRewritter.createTemporaryTablesIfNeeded(sqlP);
        return this.createEntityListIterator(sqlP, sql, nonNullFindOptions, modelEntity, selectFields, whereEntityConditionParams, havingEntityConditionParams, inQueryRewritter.getTableCleanUpHandler());
    }

    @VisibleForTesting
    EntityListIterator createEntityListIterator(SQLProcessor sqlP, String sql, EntityFindOptions nonNullFindOptions, ModelEntity modelEntity, List<ModelField> selectFields, List<EntityConditionParam> whereEntityConditionParams, List<EntityConditionParam> havingEntityConditionParams, TableCleanUp tableCleanUp) throws GenericEntityException {
        try {
            sqlP.prepareStatement(sql, nonNullFindOptions.isCustomResultSetTypeAndConcurrency(), nonNullFindOptions.getResultSetType(), nonNullFindOptions.getResultSetConcurrency());
            this.bindParameterValues(sqlP, modelEntity, whereEntityConditionParams, "where");
            this.bindParameterValues(sqlP, modelEntity, havingEntityConditionParams, "having");
            this.setFetchSize(sqlP, nonNullFindOptions.getFetchSize());
            sqlP.executeQuery();
            if (tableCleanUp == null) {
                return new EntityListIterator(sqlP, modelEntity, selectFields, this.modelFieldTypeReader);
            }
            return new EntityListIteratorWithTemporaryTableCleanup(sqlP, modelEntity, selectFields, this.modelFieldTypeReader, tableCleanUp);
        }
        catch (RuntimeException | GenericEntityException e) {
            GenericDAO.closeSafely(sql, sqlP);
            throw e;
        }
    }

    private void bindParameterValues(SQLProcessor sqlP, ModelEntity modelEntity, Iterable<EntityConditionParam> params, String clauseName) throws GenericEntityException {
        if (Debug.verboseOn()) {
            Debug.logVerbose((String)("Setting the " + clauseName + "EntityConditionParams: " + params));
        }
        for (EntityConditionParam param : params) {
            SqlJdbcUtil.setValue(sqlP, param.getModelField(), modelEntity.getEntityName(), param.getFieldValue(), this.modelFieldTypeReader);
        }
    }

    private List<ModelField> getSelectFields(ModelEntity modelEntity, Collection<String> fieldsToSelect) throws GenericModelException {
        ArrayList<ModelField> selectFields = new ArrayList();
        if (fieldsToSelect != null && fieldsToSelect.size() > 0) {
            HashSet<String> tempKeys = new HashSet<String>(fieldsToSelect);
            for (int fi = 0; fi < modelEntity.getFieldsSize(); ++fi) {
                ModelField curField = modelEntity.getField(fi);
                if (!tempKeys.contains(curField.getName())) continue;
                selectFields.add(curField);
                tempKeys.remove(curField.getName());
            }
            if (tempKeys.size() > 0) {
                throw new GenericModelException("In selectListIteratorByCondition invalid field names specified: " + ((Object)tempKeys).toString());
            }
        } else {
            selectFields = modelEntity.getFieldsCopy();
        }
        return selectFields;
    }

    @VisibleForTesting
    String getSelectQuery(List<ModelField> selectFields, EntityFindOptions findOptions, ModelEntity modelEntity, List<String> orderBy, EntityCondition whereEntityCondition, EntityCondition havingEntityCondition, List<EntityConditionParam> whereEntityConditionParams, List<EntityConditionParam> havingEntityConditionParams, DatabaseType databaseType) throws GenericEntityException {
        ModelViewEntity modelViewEntity;
        String groupByString;
        String viewClause;
        StringBuilder sqlBuilder = new StringBuilder("SELECT ");
        if (findOptions.getDistinct()) {
            sqlBuilder.append("DISTINCT ");
        }
        if (selectFields != null && !selectFields.isEmpty()) {
            sqlBuilder.append(modelEntity.colNameString(selectFields, ", ", "", this.sqlEscapeHelper));
        } else {
            sqlBuilder.append("*");
        }
        sqlBuilder.append(SqlJdbcUtil.makeFromClause(modelEntity, this.datasourceInfo, this.sqlEscapeHelper));
        StringBuilder whereString = new StringBuilder();
        String entityCondWhereString = "";
        if (whereEntityCondition != null) {
            entityCondWhereString = whereEntityCondition.makeWhereString(modelEntity, whereEntityConditionParams, this.sqlEscapeHelper);
        }
        if ((viewClause = SqlJdbcUtil.makeViewWhereClause(modelEntity, this.datasourceInfo.getJoinStyle(), this.sqlEscapeHelper)).length() > 0) {
            if (entityCondWhereString.length() > 0) {
                whereString.append("(");
                whereString.append(entityCondWhereString);
                whereString.append(") AND ");
            }
            whereString.append(viewClause);
        } else {
            whereString.append(entityCondWhereString);
        }
        if (whereString.length() > 0) {
            sqlBuilder.append(" WHERE ");
            sqlBuilder.append(whereString.toString());
        }
        if (modelEntity instanceof ModelViewEntity && UtilValidate.isNotEmpty((String)(groupByString = (modelViewEntity = (ModelViewEntity)modelEntity).colNameString(modelViewEntity.getGroupBysCopy(), ", ", "", this.sqlEscapeHelper)))) {
            sqlBuilder.append(" GROUP BY ");
            sqlBuilder.append(groupByString);
        }
        String entityCondHavingString = "";
        if (havingEntityCondition != null) {
            entityCondHavingString = havingEntityCondition.makeWhereString(modelEntity, havingEntityConditionParams, this.sqlEscapeHelper);
        }
        if (entityCondHavingString.length() > 0) {
            sqlBuilder.append(" HAVING ");
            sqlBuilder.append(entityCondHavingString);
        }
        sqlBuilder.append(SqlJdbcUtil.makeOrderByClause(modelEntity, orderBy, this.datasourceInfo));
        String sql = sqlBuilder.toString();
        if (findOptions.getMaxResults() > 0) {
            sql = this.limitHelper.addLimitClause(sql, selectFields, findOptions.getOffset(), findOptions.getMaxResults(), this.sqlEscapeHelper);
        }
        return sql;
    }

    private static EntityCondition rewriteConditionToSplitListsLargerThan(EntityCondition whereEntityCondition, int maxListSize) {
        if (GenericDAO.conditionContainsInClauseWithListOfSizeGreaterThanMaxSize(whereEntityCondition, maxListSize)) {
            return GenericDAO.transformConditionSplittingInClauseListsToChunksNoLongerThanMaxSize(whereEntityCondition, maxListSize);
        }
        return whereEntityCondition;
    }

    @VisibleForTesting
    static boolean conditionContainsInClauseWithListOfSizeGreaterThanMaxSize(EntityCondition whereEntityCondition, final int maxListSize) {
        return !EntityConditionHelper.predicateTrueForEachLeafExpression(whereEntityCondition, (Predicate<EntityExpr>)Predicates.not((Predicate)new Predicate<EntityExpr>(){

            public boolean apply(EntityExpr input) {
                return input.getOperator().equals(EntityOperator.IN) && input.getRhs() instanceof Collection && ((Collection)input.getRhs()).size() > maxListSize;
            }
        }));
    }

    @VisibleForTesting
    static EntityCondition transformConditionSplittingInClauseListsToChunksNoLongerThanMaxSize(EntityCondition whereEntityCondition, final int maxListSize) {
        return EntityConditionHelper.transformCondition(whereEntityCondition, new Function<EntityExpr, EntityCondition>(){

            public EntityCondition apply(final EntityExpr input) {
                if (input.getOperator().equals(EntityOperator.IN) && input.getRhs() instanceof Collection && ((Collection)input.getRhs()).size() > maxListSize) {
                    ImmutableList listOfExpressions = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)Iterables.partition((Iterable)((Collection)input.getRhs()), (int)maxListSize), (Function)new Function<List<?>, EntityExpr>(){

                        public EntityExpr apply(@Nullable List<?> list) {
                            return new EntityExpr((String)input.getLhs(), input.getOperator(), list);
                        }
                    }));
                    return new EntityExprList((List<? extends EntityExpr>)listOfExpressions, EntityOperator.OR);
                }
                return input;
            }
        });
    }

    private void setFetchSize(SQLProcessor sqlP, int fetchSize) {
        block4: {
            if (fetchSize != -1) {
                try {
                    sqlP.getPreparedStatement().setFetchSize(fetchSize);
                    if (Debug.verboseOn()) {
                        Debug.logVerbose((String)("Set the fetch size to: " + fetchSize));
                    }
                }
                catch (SQLException sqle) {
                    if (!Debug.verboseOn()) break block4;
                    Debug.logVerbose((String)("Unable to set the fetch size to: " + fetchSize + ": " + sqle));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GenericValue> selectByMultiRelation(GenericValue value, ModelRelation modelRelationOne, ModelEntity modelEntityOne, ModelRelation modelRelationTwo, ModelEntity modelEntityTwo, List<String> orderBy) throws GenericEntityException {
        ReadOnlySQLProcessor sqlP = new ReadOnlySQLProcessor(this.helperName);
        String atable = modelEntityOne.getTableName(this.datasourceInfo);
        String ttable = modelEntityTwo.getTableName(this.datasourceInfo);
        StringBuilder selsb = new StringBuilder(256);
        ArrayList<String> collist = new ArrayList<String>();
        ArrayList<String> fldlist = new ArrayList<String>();
        Iterator<ModelField> iterator = modelEntityTwo.getFieldsIterator();
        while (iterator.hasNext()) {
            ModelField mf = iterator.next();
            collist.add(this.sqlEscapeHelper.escapeColumn(mf.getColName()));
            fldlist.add(mf.getName());
            selsb.append(ttable).append('.').append(this.sqlEscapeHelper.escapeColumn(mf.getColName()));
            if (iterator.hasNext()) {
                selsb.append(", ");
                continue;
            }
            selsb.append(' ');
        }
        int kmsize = modelRelationTwo.getKeyMapsSize();
        StringBuilder wheresb = new StringBuilder(256);
        for (int i = 0; i < kmsize; ++i) {
            ModelKeyMap mkm = modelRelationTwo.getKeyMap(i);
            String lfname = mkm.getFieldName();
            String rfname = mkm.getRelFieldName();
            if (wheresb.length() > 0) {
                wheresb.append(" AND ");
            }
            wheresb.append(atable).append('.').append(this.sqlEscapeHelper.escapeColumn(modelEntityOne.getField(lfname).getColName())).append(" = ").append(ttable).append('.').append(this.sqlEscapeHelper.escapeColumn(modelEntityTwo.getField(rfname).getColName()));
        }
        kmsize = modelRelationOne.getKeyMapsSize();
        HashMap<ModelField, Object> bindMap = new HashMap<ModelField, Object>();
        for (int i = 0; i < kmsize; ++i) {
            ModelKeyMap mkm = modelRelationOne.getKeyMap(i);
            String sfldname = mkm.getFieldName();
            String lfldname = mkm.getRelFieldName();
            ModelField amf = modelEntityOne.getField(lfldname);
            String lcolname = this.sqlEscapeHelper.escapeColumn(amf.getColName());
            Object object = value.get(sfldname);
            bindMap.put(amf, object);
            if (wheresb.length() > 0) {
                wheresb.append(" AND ");
            }
            wheresb.append(atable).append('.').append(lcolname).append(" = ? ");
        }
        StringBuilder sqlsb = new StringBuilder(256);
        sqlsb.append("SELECT ");
        sqlsb.append(selsb.toString());
        sqlsb.append(" FROM ");
        sqlsb.append(atable).append(", ").append(ttable);
        sqlsb.append(" WHERE ");
        sqlsb.append(wheresb.toString());
        sqlsb.append(SqlJdbcUtil.makeOrderByClause(modelEntityTwo, orderBy, true, this.datasourceInfo));
        String sql = sqlsb.toString();
        ArrayList<GenericValue> retlist = new ArrayList<GenericValue>();
        GenericDelegator gd = value.getDelegator();
        try {
            sqlP.prepareStatement(sql);
            Set entrySet = bindMap.entrySet();
            for (Map.Entry entry : entrySet) {
                ModelField mf = (ModelField)entry.getKey();
                Object curvalue = entry.getValue();
                SqlJdbcUtil.setValue(sqlP, mf, modelEntityOne.getEntityName(), curvalue, this.modelFieldTypeReader);
            }
            sqlP.executeQuery();
            int collsize = collist.size();
            while (sqlP.next()) {
                GenericValue genericValue = gd.makeValue(modelEntityTwo.getEntityName(), Collections.emptyMap());
                for (int j = 0; j < collsize; ++j) {
                    String fldname = (String)fldlist.get(j);
                    ModelField mf = modelEntityTwo.getField(fldname);
                    SqlJdbcUtil.getValue(sqlP.getResultSet(), j + 1, mf, genericValue, this.modelFieldTypeReader);
                }
                retlist.add(genericValue);
            }
        }
        finally {
            GenericDAO.closeSafely(sql, sqlP);
        }
        return retlist;
    }

    public int delete(GenericEntity entity) throws GenericEntityException {
        AutoCommitSQLProcessor sqlP = new AutoCommitSQLProcessor(this.helperName);
        try {
            int n = this.deleteImpl(entity, sqlP.getConnection());
            return n;
        }
        catch (GenericDataSourceException e) {
            sqlP.rollback();
            throw new GenericDataSourceException("Exception while deleting the following entity: " + entity.toString(), (Throwable)((Object)e));
        }
        finally {
            GenericDAO.closeSafely(entity, sqlP);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deleteImpl(GenericEntity entity, Connection connection) throws GenericEntityException {
        int retVal;
        ModelEntity modelEntity = entity.getModelEntity();
        if (modelEntity == null) {
            throw new GenericModelException("Could not find ModelEntity record for entityName: " + entity.getEntityName());
        }
        if (modelEntity instanceof ModelViewEntity) {
            throw new GenericNotImplementedException("Operation delete not supported yet for view entities");
        }
        String sql = "DELETE FROM " + modelEntity.getTableName(this.datasourceInfo) + " WHERE " + SqlJdbcUtil.makeWhereStringFromFields(modelEntity.getPksCopy(), entity, "AND", this.sqlEscapeHelper);
        PassThruSQLProcessor sqlP = new PassThruSQLProcessor(this.helperName, connection);
        try {
            sqlP.prepareStatement(sql);
            SqlJdbcUtil.setPkValues(sqlP, modelEntity, entity, this.modelFieldTypeReader);
            retVal = sqlP.executeUpdate();
            entity.modified = true;
        }
        finally {
            GenericDAO.closeSafely(sql, sqlP);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteByCondition(ModelEntity modelEntity, EntityCondition whereCondition) throws GenericEntityException {
        int retVal;
        if (modelEntity == null) {
            throw new GenericModelException("Could not find ModelEntity record for entityName: " + modelEntity.getEntityName());
        }
        if (modelEntity instanceof ModelViewEntity) {
            throw new GenericNotImplementedException("Operation delete not supported yet for view entities");
        }
        Object whereClause = "";
        LinkedList whereConditionParams = Lists.newLinkedList();
        if (whereCondition != null) {
            whereClause = " WHERE " + whereCondition.makeWhereString(modelEntity, whereConditionParams, this.sqlEscapeHelper);
        }
        String sql = "DELETE FROM " + modelEntity.getTableName(this.datasourceInfo) + (String)whereClause;
        AutoCommitSQLProcessor sqlP = new AutoCommitSQLProcessor(this.helperName);
        try {
            sqlP.prepareStatement(sql);
            if (whereCondition != null) {
                for (EntityConditionParam param : whereConditionParams) {
                    SqlJdbcUtil.setValue(sqlP, param.getModelField(), modelEntity.getEntityName(), param.getFieldValue(), this.modelFieldTypeReader);
                }
            }
            retVal = sqlP.executeUpdate();
        }
        finally {
            GenericDAO.closeSafely(sql, sqlP);
        }
        return retVal;
    }

    public int deleteByAnd(ModelEntity modelEntity, Map<String, ?> fields) throws GenericEntityException {
        AutoCommitSQLProcessor sqlP = new AutoCommitSQLProcessor(this.helperName);
        try {
            int n = this.deleteByAnd(modelEntity, fields, sqlP.getConnection());
            return n;
        }
        catch (GenericDataSourceException e) {
            sqlP.rollback();
            throw new GenericDataSourceException("Generic Entity Exception occurred in deleteByAnd", (Throwable)((Object)e));
        }
        finally {
            GenericDAO.closeSafely(fields, sqlP);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deleteByAnd(ModelEntity modelEntity, Map<String, ?> whereFieldValues, Connection connection) throws GenericEntityException {
        if (modelEntity == null || whereFieldValues == null) {
            return 0;
        }
        if (modelEntity instanceof ModelViewEntity) {
            throw new GenericNotImplementedException("Operation deleteByAnd not supported yet for view entities");
        }
        List<ModelField> whereFields = this.getWhereFields(modelEntity, whereFieldValues);
        GenericValue dummyValue = new GenericValue(modelEntity, whereFieldValues);
        String sql = "DELETE FROM " + modelEntity.getTableName(this.datasourceInfo);
        if (!whereFieldValues.isEmpty()) {
            sql = sql + " WHERE " + SqlJdbcUtil.makeWhereStringFromFields(whereFields, dummyValue, "AND", this.sqlEscapeHelper);
        }
        PassThruSQLProcessor sqlP = new PassThruSQLProcessor(this.helperName, connection);
        try {
            sqlP.prepareStatement(sql);
            if (!whereFieldValues.isEmpty()) {
                SqlJdbcUtil.setValuesWhereClause(sqlP, whereFields, dummyValue, this.modelFieldTypeReader);
            }
            int n = sqlP.executeUpdate();
            return n;
        }
        finally {
            GenericDAO.closeSafely(sql, sqlP);
        }
    }

    private List<ModelField> getWhereFields(ModelEntity modelEntity, Map<String, ?> fieldValues) {
        ArrayList<ModelField> whereFields = new ArrayList<ModelField>();
        if (!fieldValues.isEmpty()) {
            for (int fieldNumber = 0; fieldNumber < modelEntity.getFieldsSize(); ++fieldNumber) {
                ModelField modelField = modelEntity.getField(fieldNumber);
                if (!fieldValues.containsKey(modelField.getName())) continue;
                whereFields.add(modelField);
            }
        }
        return whereFields;
    }

    public int deleteAll(List<? extends GenericEntity> dummyPKs) throws GenericEntityException {
        if (dummyPKs == null || dummyPKs.size() == 0) {
            return 0;
        }
        ExplicitCommitSQLProcessor sqlP = new ExplicitCommitSQLProcessor(this.helperName);
        try {
            Iterator<? extends GenericEntity> iter = dummyPKs.iterator();
            int numDeleted = 0;
            while (iter.hasNext()) {
                GenericEntity entity = iter.next();
                if (entity.containsPrimaryKey()) {
                    numDeleted += this.deleteImpl(entity, sqlP.getConnection());
                    continue;
                }
                numDeleted += this.deleteByAnd(entity.getModelEntity(), entity.getAllFields(), sqlP.getConnection());
            }
            int n = numDeleted;
            return n;
        }
        catch (GenericDataSourceException e) {
            sqlP.rollback();
            throw new GenericDataSourceException("Generic Entity Exception occurred in deleteAll", (Throwable)((Object)e));
        }
        finally {
            GenericDAO.closeSafely(dummyPKs, sqlP);
        }
    }

    public void checkDb(Map<String, ? extends ModelEntity> modelEntities, Collection<String> messages, boolean addMissing) {
        DatabaseUtil dbUtil = new DatabaseUtil(this.helperName);
        dbUtil.checkDb(modelEntities, messages, addMissing);
    }

    public List<ModelEntity> induceModelFromDb(Collection<String> messages) {
        DatabaseUtil dbUtil = new DatabaseUtil(this.helperName);
        return dbUtil.induceModelFromDb(messages);
    }

    public int count(ModelEntity modelEntity, String fieldName, EntityCondition entityCondition, EntityFindOptions findOptions) throws GenericEntityException {
        int count = 0;
        if (modelEntity == null) {
            return count;
        }
        boolean distinct = findOptions == null ? false : findOptions.getDistinct();
        boolean verboseOn = Debug.verboseOn();
        if (verboseOn) {
            Debug.logVerbose((String)("Doing count with whereEntityCondition: " + entityCondition));
        }
        ModelField fieldToSelect = modelEntity.getField(fieldName);
        String columnName = null;
        if (fieldToSelect != null) {
            columnName = this.sqlEscapeHelper.escapeColumn(fieldToSelect.getColName());
        }
        String tableName = modelEntity.getTableName(this.datasourceInfo);
        String entityCondWhereString = null;
        LinkedList whereEntityConditionParams = new LinkedList();
        if (entityCondition != null) {
            entityCondWhereString = entityCondition.makeWhereString(modelEntity, whereEntityConditionParams, this.sqlEscapeHelper);
        }
        String sql = this.countHelper.buildCountSelectStatement(tableName, columnName, entityCondWhereString, distinct);
        if (verboseOn) {
            Debug.logVerbose((String)("Setting the whereEntityConditionParams: " + whereEntityConditionParams));
        }
        ResultSet resultSet = null;
        ReadOnlySQLProcessor sqlP = new ReadOnlySQLProcessor(this.helperName);
        try {
            sqlP.prepareStatement(sql);
            for (EntityConditionParam param : whereEntityConditionParams) {
                SqlJdbcUtil.setValue(sqlP, param.getModelField(), modelEntity.getEntityName(), param.getFieldValue(), this.modelFieldTypeReader);
            }
            resultSet = sqlP.executeQuery();
            if (resultSet.next()) {
                count = resultSet.getInt(1);
            }
        }
        catch (SQLException e) {
            throw new GenericEntityException("SQL Exception while executing the following:" + sql, e);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            GenericDAO.closeSafely(sql, sqlP);
        }
        return count;
    }

    public List<GenericValue> transform(ModelEntity modelEntity, EntityCondition entityCondition, List<String> orderBy, String lockFieldName, Transformation transformation) throws GenericEntityException {
        EntityFindOptions findOptions = EntityFindOptions.findOptions();
        ModelField lockField = modelEntity.getField(lockFieldName);
        try {
            List<GenericValue> targetEntities = this.selectByCondition(modelEntity, entityCondition, null, orderBy, findOptions);
            for (GenericValue entity : targetEntities) {
                this.transformOne(modelEntity, transformation, lockFieldName, lockField, entity);
            }
            return targetEntities;
        }
        catch (Exception e) {
            if (e instanceof GenericEntityException) {
                throw (GenericEntityException)((Object)e);
            }
            throw new GenericEntityException("Transformation failed", e);
        }
    }

    private void transformOne(ModelEntity modelEntity, Transformation transformation, String lockFieldName, ModelField lockField, GenericValue entity) throws GenericEntityException, InterruptedException {
        long totalBackOffMillis = 0L;
        while (true) {
            Object lockValue = entity.get(lockFieldName);
            transformation.transform(entity);
            try {
                this.update(entity, new EntityConditionParam(lockField, lockValue));
                if (totalBackOffMillis > 0L && LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("Total back-off time for %s.%s = %d", modelEntity.getEntityName(), lockFieldName, totalBackOffMillis));
                }
                return;
            }
            catch (GenericEntityNotFoundException notFound) {
                totalBackOffMillis += this.sleepForRandomAmountOfTime();
                this.select(entity);
                continue;
            }
            break;
        }
    }

    private long sleepForRandomAmountOfTime() throws InterruptedException {
        long backOffMillis = GenericDAO.zeroTo(30L);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Backing off for " + backOffMillis + "ms");
        }
        Thread.sleep(backOffMillis);
        return backOffMillis;
    }

    private static void closeSafely(Object info, SQLProcessor sqlP) {
        try {
            sqlP.close();
        }
        catch (Exception ex) {
            Debug.logError((Throwable)ex, (String)("Error closing " + sqlP + "; info=[" + info + "]"), (String)module);
        }
    }

    static class InQueryRewritter
    implements TableCleanUp {
        private static final AtomicInteger temporaryTableCounter = new AtomicInteger(1);
        final DatabaseType databaseType;
        final EntityCondition whereEntityCondition;
        final ModelEntity modelEntity;
        final SqlEscapeHelper sqlEscapeHelper;
        private static final String BIGINT = "bigint";
        private static final String VARCHAR_900 = "varchar(900)";
        Optional<WhereRewrite> whereRewrite;
        Collection<String> temporaryTableNames;

        InQueryRewritter(@Nonnull DatabaseType databaseType, EntityCondition whereEntityCondition, ModelEntity modelEntity, SqlEscapeHelper sqlEscapeHelper) {
            this.databaseType = databaseType;
            this.whereEntityCondition = whereEntityCondition;
            this.modelEntity = modelEntity;
            this.sqlEscapeHelper = sqlEscapeHelper;
            this.whereRewrite = Optional.absent();
            this.temporaryTableNames = new HashSet<String>();
        }

        boolean isRewritten() {
            return this.whereRewrite.isPresent();
        }

        EntityCondition rewriteIfNeeded() {
            this.whereRewrite = this.rewriteConditionToUseTemporaryTablesForLargeInClauses();
            if (this.whereRewrite.isPresent()) {
                return ((WhereRewrite)this.whereRewrite.get()).getNewCondition();
            }
            return this.whereEntityCondition;
        }

        void createTemporaryTablesIfNeeded(SQLProcessor sqlP) throws GenericEntityException {
            if (this.whereRewrite.isPresent()) {
                for (InReplacement inReplacement : ((WhereRewrite)this.whereRewrite.get()).getInReplacements()) {
                    String temporaryTableName = inReplacement.getTemporaryTableName();
                    this.generateTemporaryTable(temporaryTableName, inReplacement.getItems(), sqlP);
                    this.temporaryTableNames.add(temporaryTableName);
                }
            }
        }

        @Override
        public void cleanUp(SQLProcessor sqlP) throws GenericEntityException {
            this.dropTemporaryTables(sqlP);
        }

        TableCleanUp getTableCleanUpHandler() {
            if (this.isRewritten()) {
                return this;
            }
            return null;
        }

        @VisibleForTesting
        static void resetTemporaryTableCounter() {
            temporaryTableCounter.set(1);
        }

        @VisibleForTesting
        Optional<WhereRewrite> rewriteConditionToUseTemporaryTablesForLargeInClauses() {
            if (this.whereEntityCondition == null) {
                return Optional.absent();
            }
            if (!this.shouldRewrite()) {
                return Optional.absent();
            }
            final ArrayList<InReplacement> inReplacements = new ArrayList<InReplacement>();
            EntityCondition newCondition = EntityConditionHelper.transformCondition(this.whereEntityCondition, new Function<EntityExpr, EntityCondition>(){

                public EntityCondition apply(EntityExpr input) {
                    if (input.getOperator().equals(EntityOperator.IN)) {
                        Collection items = (Collection)input.getRhs();
                        Set itemSet = items instanceof Set ? (Set)items : new HashSet(items);
                        InReplacement inReplacement = new InReplacement(this.generateTemporaryTableName(databaseType), itemSet);
                        inReplacements.add(inReplacement);
                        EntityWhereString newRhs = new EntityWhereString("select item from " + inReplacement.getTemporaryTableName());
                        EntityExpr replacementCondition = new EntityExpr((String)input.getLhs(), input.isLUpper(), input.getOperator(), newRhs, input.isRUpper());
                        return replacementCondition;
                    }
                    return input;
                }
            });
            return Optional.of((Object)new WhereRewrite(newCondition, inReplacements));
        }

        private boolean shouldRewrite() {
            int parameterCount = this.whereEntityCondition.getParameterCount(this.modelEntity, this.sqlEscapeHelper);
            return this.databaseType == DatabaseTypeFactory.MSSQL && parameterCount > 2000 || this.databaseType == DatabaseTypeFactory.POSTGRES_7_3 && parameterCount > 30000;
        }

        private String generateTemporaryTableName(DatabaseType databaseType) {
            if (databaseType == DatabaseTypeFactory.POSTGRES_7_3) {
                return "temp" + temporaryTableCounter.getAndIncrement();
            }
            return "#temp" + temporaryTableCounter.getAndIncrement();
        }

        private void generateTemporaryTable(String tableName, Set<?> items, SQLProcessor sqlP) throws GenericEntityException {
            sqlP.getConnection();
            String dataType = this.getColumnType(items);
            if (this.databaseType == DatabaseTypeFactory.POSTGRES_7_3) {
                sqlP.executeUpdate("create temporary table " + tableName + " (item " + dataType + " primary key)");
            } else if (this.databaseType == DatabaseTypeFactory.MSSQL && dataType.equals(VARCHAR_900)) {
                sqlP.executeUpdate("create table " + tableName + " (item " + dataType + " COLLATE database_default primary key)");
            } else {
                sqlP.executeUpdate("create table " + tableName + " (item " + dataType + " primary key)");
            }
            sqlP.prepareStatement("insert into " + tableName + " (item) values (?)");
            PreparedStatement stat = sqlP.getPreparedStatement();
            try {
                for (Object item : items) {
                    if (item instanceof Number) {
                        stat.setLong(1, ((Number)item).longValue());
                    } else if (item instanceof String) {
                        stat.setString(1, (String)item);
                    } else {
                        stat.setObject(1, item);
                    }
                    stat.addBatch();
                }
                stat.executeBatch();
            }
            catch (SQLException e) {
                throw new GenericEntityException(e.getMessage(), e);
            }
            finally {
                try {
                    stat.close();
                }
                catch (SQLException sQLException) {}
            }
        }

        private String getColumnType(Collection<?> items) {
            Object firstItem = items.iterator().next();
            if (firstItem instanceof Number) {
                return BIGINT;
            }
            return VARCHAR_900;
        }

        private void dropTemporaryTables(SQLProcessor sqlP) throws GenericEntityException {
            for (String temporaryTableName : this.temporaryTableNames) {
                sqlP.executeUpdate("drop table " + temporaryTableName);
            }
        }
    }

    static interface TableCleanUp {
        public void cleanUp(SQLProcessor var1) throws GenericEntityException;
    }

    private static class EntityListIteratorWithTemporaryTableCleanup
    extends EntityListIterator {
        private TableCleanUp cleanUp;

        public EntityListIteratorWithTemporaryTableCleanup(SQLProcessor sqlp, ModelEntity modelEntity, List<ModelField> selectFields, ModelFieldTypeReader modelFieldTypeReader, TableCleanUp cleanUp) {
            super(sqlp, modelEntity, selectFields, modelFieldTypeReader);
            this.cleanUp = cleanUp;
        }

        @Override
        public void close() throws GenericEntityException {
            try {
                this.cleanUp.cleanUp(this.sqlp);
            }
            finally {
                super.close();
            }
        }
    }

    @VisibleForTesting
    static class InReplacement {
        private final String temporaryTableName;
        private final Set<?> items;

        public InReplacement(String temporaryTableName, Set<?> items) {
            this.temporaryTableName = temporaryTableName;
            this.items = items;
        }

        public Set<?> getItems() {
            return this.items;
        }

        public String getTemporaryTableName() {
            return this.temporaryTableName;
        }
    }

    @VisibleForTesting
    static class WhereRewrite {
        private final EntityCondition condition;
        private final Collection<InReplacement> inReplacements;

        public WhereRewrite(EntityCondition condition, Collection<InReplacement> inReplacements) {
            this.condition = condition;
            this.inReplacements = inReplacements;
        }

        public EntityCondition getNewCondition() {
            return this.condition;
        }

        public Collection<InReplacement> getInReplacements() {
            return this.inReplacements;
        }
    }
}

