/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class PluginDependencies {
    private final Set<String> mandatory;
    private final Set<String> optional;
    private final Set<String> dynamic;
    private final Set<String> all;
    private final Map<String, SortedSet<Type>> byPluginKey;

    public PluginDependencies() {
        this(null, null, null);
    }

    public PluginDependencies(Set<String> mandatory, Set<String> optional, Set<String> dynamic) {
        this.mandatory = mandatory == null ? Collections.emptySet() : Set.copyOf(mandatory);
        this.optional = optional == null ? Collections.emptySet() : Set.copyOf(optional);
        this.dynamic = dynamic == null ? Collections.emptySet() : Set.copyOf(dynamic);
        HashSet<String> combined = new HashSet<String>();
        combined.addAll(this.mandatory);
        combined.addAll(this.optional);
        combined.addAll(this.dynamic);
        this.all = Set.copyOf(combined);
        HashMap<String, SortedSet> byPluginKeyBuilder = new HashMap<String, SortedSet>();
        for (String key : this.mandatory) {
            byPluginKeyBuilder.computeIfAbsent(key, k -> new TreeSet<Type>(Comparator.comparingInt(Enum::ordinal))).add(Type.MANDATORY);
        }
        for (String key : this.optional) {
            byPluginKeyBuilder.computeIfAbsent(key, k -> new TreeSet<Type>(Comparator.comparingInt(Enum::ordinal))).add(Type.OPTIONAL);
        }
        for (String key : this.dynamic) {
            byPluginKeyBuilder.computeIfAbsent(key, k -> new TreeSet<Type>(Comparator.comparingInt(Enum::ordinal))).add(Type.DYNAMIC);
        }
        this.byPluginKey = Map.copyOf(byPluginKeyBuilder);
    }

    public Set<String> getMandatory() {
        return this.mandatory;
    }

    public Set<String> getOptional() {
        return this.optional;
    }

    public Set<String> getDynamic() {
        return this.dynamic;
    }

    public Set<String> getAll() {
        return this.all;
    }

    public Map<String, SortedSet<Type>> getTypesByPluginKey() {
        HashMap<String, TreeSet> typesByPluginKeyLocal = new HashMap<String, TreeSet>();
        for (Map.Entry<String, SortedSet<Type>> entry : this.byPluginKey.entrySet()) {
            typesByPluginKeyLocal.computeIfAbsent(entry.getKey(), x -> new TreeSet((SortedSet)entry.getValue()));
        }
        return Map.copyOf(typesByPluginKeyLocal);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Type {
        MANDATORY,
        OPTIONAL,
        DYNAMIC;


        public boolean lessSignificant(Type other) {
            return this.ordinal() > other.ordinal();
        }
    }

    public static class Builder {
        final Set<String> mandatory = new HashSet<String>();
        final Set<String> optional = new HashSet<String>();
        final Set<String> dynamic = new HashSet<String>();

        private Builder() {
        }

        public Builder withMandatory(String ... pluginKey) {
            this.mandatory.addAll(Arrays.asList(pluginKey));
            return this;
        }

        public Builder withOptional(String ... pluginKey) {
            this.optional.addAll(Arrays.asList(pluginKey));
            return this;
        }

        public Builder withDynamic(String ... pluginKey) {
            this.dynamic.addAll(Arrays.asList(pluginKey));
            return this;
        }

        public PluginDependencies build() {
            return new PluginDependencies(Set.copyOf(this.mandatory), Set.copyOf(this.optional), Set.copyOf(this.dynamic));
        }
    }
}

