/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.servlet.descriptors;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.StateAware;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.servlet.ServletModuleManager;
import com.atlassian.plugin.servlet.descriptors.BaseServletModuleDescriptor;
import com.atlassian.plugin.servlet.filter.FilterDispatcherCondition;
import com.atlassian.plugin.servlet.filter.FilterLocation;
import com.atlassian.plugin.util.validation.ValidationPattern;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.servlet.Filter;
import org.dom4j.Element;

public class ServletFilterModuleDescriptor
extends BaseServletModuleDescriptor<Filter>
implements StateAware {
    static final String DEFAULT_LOCATION = FilterLocation.BEFORE_DISPATCH.name();
    static final String DEFAULT_WEIGHT = "100";
    private FilterLocation location;
    private int weight;
    private final ServletModuleManager servletModuleManager;
    private Set<FilterDispatcherCondition> dispatcherConditions = Sets.newHashSet((Object[])new FilterDispatcherCondition[]{FilterDispatcherCondition.REQUEST});
    public static final Comparator<ServletFilterModuleDescriptor> byWeight = new Comparator<ServletFilterModuleDescriptor>(){

        @Override
        public int compare(ServletFilterModuleDescriptor lhs, ServletFilterModuleDescriptor rhs) {
            return Integer.valueOf(lhs.getWeight()).compareTo(rhs.getWeight());
        }
    };

    public ServletFilterModuleDescriptor(ModuleFactory moduleFactory, ServletModuleManager servletModuleManager) {
        super(moduleFactory);
        this.servletModuleManager = (ServletModuleManager)Preconditions.checkNotNull((Object)servletModuleManager);
    }

    @Override
    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        try {
            this.location = FilterLocation.parse(element.attributeValue("location", DEFAULT_LOCATION));
            this.weight = Integer.valueOf(element.attributeValue("weight", DEFAULT_WEIGHT));
        }
        catch (IllegalArgumentException ex) {
            throw new PluginParseException((Throwable)ex);
        }
        List dispatcherElements = element.elements("dispatcher");
        if (!dispatcherElements.isEmpty()) {
            this.dispatcherConditions.clear();
            for (Element dispatcher : dispatcherElements) {
                this.dispatcherConditions.add(FilterDispatcherCondition.valueOf(dispatcher.getTextTrim()));
            }
        }
    }

    @Override
    protected void provideValidationRules(ValidationPattern pattern) {
        super.provideValidationRules(pattern);
        StringBuilder conditionRule = new StringBuilder();
        conditionRule.append("dispatcher[");
        for (int x = 0; x < FilterDispatcherCondition.values().length; ++x) {
            conditionRule.append(". != '").append((Object)FilterDispatcherCondition.values()[x]).append("'");
            if (x + 1 >= FilterDispatcherCondition.values().length) continue;
            conditionRule.append(" and ");
        }
        conditionRule.append("]");
        pattern.rule(conditionRule.toString(), new ValidationPattern.RuleTest[]{ValidationPattern.test((String)"dispatcher").withError("The dispatcher value must be one of the following only " + Arrays.asList(FilterDispatcherCondition.values())), ValidationPattern.test((String)"@class").withError("The class is required")});
    }

    public void enabled() {
        super.enabled();
        this.servletModuleManager.addFilterModule(this);
    }

    public void disabled() {
        this.servletModuleManager.removeFilterModule(this);
        super.disabled();
    }

    public Filter getModule() {
        return (Filter)this.moduleFactory.createModule(this.moduleClassName, (ModuleDescriptor)this);
    }

    public FilterLocation getLocation() {
        return this.location;
    }

    public int getWeight() {
        return this.weight;
    }

    public Set<FilterDispatcherCondition> getDispatcherConditions() {
        return this.dispatcherConditions;
    }
}

