/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.web.descriptors;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.util.validation.ValidationException;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.api.provider.WebItemProvider;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.ArrayList;
import javax.annotation.Nonnull;

public class WebItemProviderModuleDescriptor
extends AbstractModuleDescriptor<WebItemProvider>
implements com.atlassian.plugin.web.api.descriptors.WebItemProviderModuleDescriptor<WebItemProvider> {
    private final WebInterfaceManager webInterfaceManager;
    private Supplier<WebItemProvider> itemSupplier;
    private String section;

    public WebItemProviderModuleDescriptor(ModuleFactory moduleFactory, WebInterfaceManager webInterfaceManager) {
        super(moduleFactory);
        this.webInterfaceManager = webInterfaceManager;
    }

    protected void validate(Element element) {
        super.validate(element);
        ArrayList<String> violations = new ArrayList<String>();
        if (element.attributeValue("class") == null) {
            violations.add("The web item provider class is required.");
        }
        if (element.attributeValue("section") == null) {
            violations.add("Must provide a section that items should be added to.");
        }
        if (!violations.isEmpty()) {
            throw new ValidationException("There were validation errors:", violations);
        }
    }

    public void init(@Nonnull Plugin plugin, @Nonnull Element element) throws PluginParseException {
        super.init(plugin, element);
        this.itemSupplier = Suppliers.memoize(() -> {
            WebItemProvider webItemProvider = (WebItemProvider)this.moduleFactory.createModule(this.moduleClassName, (ModuleDescriptor)this);
            webItemProvider.init((com.atlassian.plugin.web.api.descriptors.WebItemProviderModuleDescriptor)this);
            return webItemProvider;
        });
        this.section = element.attributeValue("section");
    }

    public String getSection() {
        return this.section;
    }

    public WebItemProvider getModule() {
        return (WebItemProvider)this.itemSupplier.get();
    }

    public void enabled() {
        super.enabled();
        this.webInterfaceManager.refresh();
    }

    public void disabled() {
        super.disabled();
        this.webInterfaceManager.refresh();
    }
}

