/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.web.impl;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.web.WebFragmentHelper;
import com.atlassian.plugin.web.api.DynamicWebInterfaceManager;
import com.atlassian.plugin.web.api.WebItem;
import com.atlassian.plugin.web.api.WebSection;
import com.atlassian.plugin.web.api.descriptors.WebFragmentModuleDescriptor;
import com.atlassian.plugin.web.api.descriptors.WebItemModuleDescriptor;
import com.atlassian.plugin.web.api.descriptors.WebSectionModuleDescriptor;
import com.atlassian.plugin.web.descriptors.WebItemProviderModuleDescriptor;
import com.atlassian.plugin.web.descriptors.WebPanelModuleDescriptor;
import com.atlassian.plugin.web.descriptors.WebSectionProviderModuleDescriptor;
import com.atlassian.plugin.web.descriptors.WeightedDescriptorComparator;
import com.atlassian.plugin.web.model.WebFragmentBuilder;
import com.atlassian.plugin.web.model.WebLink;
import com.atlassian.plugin.web.model.WebPanel;
import com.atlassian.plugin.web.model.WeightedComparator;
import com.atlassian.util.profiling.Metrics;
import com.atlassian.util.profiling.Ticker;
import com.google.common.base.Function;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWebInterfaceManager
implements DynamicWebInterfaceManager {
    public static final WeightedDescriptorComparator WEIGHTED_DESCRIPTOR_COMPARATOR = new WeightedDescriptorComparator();
    @VisibleForTesting
    public static final String CONDITION_METRIC_KEY = "web.fragment.condition";
    @VisibleForTesting
    public static final String FRAGMENT_LOCATION_TAG_KEY = "fragmentLocation";
    @VisibleForTesting
    public static final String CONDITION_CLASSNAME_TAG_KEY = "conditionClassName";
    private static final Logger log = LoggerFactory.getLogger(DefaultWebInterfaceManager.class);
    private static final long CACHE_EXPIRY = Long.getLong("com.atlassian.plugin.web.interface.caches.timeout.sec", 3600L);
    private final LoadingCache<String, List<com.atlassian.plugin.web.descriptors.WebSectionModuleDescriptor>> sections = CacheBuilder.newBuilder().expireAfterAccess(CACHE_EXPIRY, TimeUnit.SECONDS).build((CacheLoader)new WebSectionCacheLoader());
    private final LoadingCache<String, List<com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor>> items = CacheBuilder.newBuilder().expireAfterAccess(CACHE_EXPIRY, TimeUnit.SECONDS).build((CacheLoader)new WebItemCacheLoader());
    private final LoadingCache<String, List<WebPanelModuleDescriptor>> panels = CacheBuilder.newBuilder().expireAfterAccess(CACHE_EXPIRY, TimeUnit.SECONDS).build((CacheLoader)new WebPanelCacheLoader());
    private final LoadingCache<String, List<WebItemProviderModuleDescriptor>> itemProviders = CacheBuilder.newBuilder().expireAfterAccess(CACHE_EXPIRY, TimeUnit.SECONDS).build((CacheLoader)new WebItemProviderCacheLoader());
    private final LoadingCache<String, List<WebSectionProviderModuleDescriptor>> sectionProviders = CacheBuilder.newBuilder().expireAfterAccess(CACHE_EXPIRY, TimeUnit.SECONDS).build((CacheLoader)new WebSectionProviderCacheLoader());
    @Nullable
    private PluginAccessor pluginAccessor;
    @Nullable
    private WebFragmentHelper webFragmentHelper;

    public DefaultWebInterfaceManager() {
        if (Boolean.parseBoolean("atlassian.dev.mode")) {
            log.error("The no-args DefaultWebInterfaceManager() constructor is deprecated and will be removed by 7.0.0 reach out in #server-frontend if that's a problem");
        }
        this.refresh();
    }

    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public void setWebFragmentHelper(WebFragmentHelper webFragmentHelper) {
        this.webFragmentHelper = webFragmentHelper;
    }

    public DefaultWebInterfaceManager(PluginAccessor pluginAccessor, WebFragmentHelper webFragmentHelper) {
        this.pluginAccessor = pluginAccessor;
        this.webFragmentHelper = webFragmentHelper;
        this.refresh();
    }

    public boolean hasSectionsForLocation(String location) {
        return !Iterables.isEmpty(this.getWebSections(location, Collections.emptyMap()));
    }

    public List<com.atlassian.plugin.web.descriptors.WebSectionModuleDescriptor> getSections(String location) {
        return location == null ? Collections.emptyList() : (List)this.sections.getUnchecked((Object)location);
    }

    public List<com.atlassian.plugin.web.descriptors.WebSectionModuleDescriptor> getDisplayableSections(String location, Map<String, Object> context) {
        return this.filterFragmentsByCondition(location, this.getSections(location), context);
    }

    public List<com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor> getItems(String section) {
        return section == null ? Collections.emptyList() : (List)this.items.getUnchecked((Object)section);
    }

    public List<com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor> getDisplayableItems(String section, Map<String, Object> context) {
        return this.filterFragmentsByCondition(section, this.getItems(section), context);
    }

    public List<WebPanel> getDisplayableWebPanels(String location, Map<String, Object> context) {
        return this.toWebPanels(this.getDisplayableWebPanelDescriptors(location, context));
    }

    public List<WebPanelModuleDescriptor> getDisplayableWebPanelDescriptors(String location, Map<String, Object> context) {
        return this.filterFragmentsByCondition(location, this.getWebPanelDescriptors(location), context);
    }

    public List<WebPanel> getWebPanels(String location) {
        return this.toWebPanels(this.getWebPanelDescriptors(location));
    }

    private List<WebPanel> toWebPanels(List<WebPanelModuleDescriptor> descriptors) {
        return descriptors.stream().map(ModuleDescriptor::getModule).collect(Collectors.toList());
    }

    public List<WebPanelModuleDescriptor> getWebPanelDescriptors(String location) {
        return location == null ? Collections.emptyList() : (List)this.panels.getUnchecked((Object)location);
    }

    private <T extends WebFragmentModuleDescriptor<?>> List<T> filterFragmentsByCondition(String fragmentLocation, List<T> relevantItems, Map<String, Object> context) {
        if (relevantItems.isEmpty()) {
            return relevantItems;
        }
        ArrayList<T> result = new ArrayList<T>(relevantItems);
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            WebFragmentModuleDescriptor descriptor = (WebFragmentModuleDescriptor)iterator.next();
            try {
                if (descriptor.getCondition() == null) continue;
                String conditionClassName = descriptor.getCondition().getClass().getName();
                Ticker ignoredTicker = Metrics.metric((String)CONDITION_METRIC_KEY).fromPluginKey(descriptor.getPluginKey()).tag(CONDITION_CLASSNAME_TAG_KEY, conditionClassName).tag(FRAGMENT_LOCATION_TAG_KEY, fragmentLocation).withAnalytics().startTimer();
                try {
                    if (descriptor.getCondition().shouldDisplay(context)) continue;
                    iterator.remove();
                }
                finally {
                    if (ignoredTicker == null) continue;
                    ignoredTicker.close();
                }
            }
            catch (Throwable t) {
                log.error("Could not evaluate condition '" + descriptor.getCondition() + "' for descriptor: " + descriptor, t);
                iterator.remove();
            }
        }
        return result;
    }

    public void refresh() {
        this.sections.invalidateAll();
        this.items.invalidateAll();
        this.panels.invalidateAll();
        this.itemProviders.invalidateAll();
        this.sectionProviders.invalidateAll();
    }

    public WebFragmentHelper getWebFragmentHelper() {
        return this.webFragmentHelper;
    }

    public Iterable<WebItem> getWebItems(String section, Map<String, Object> context) {
        return this.getDynamicWebItems(this.getItems(section), section, context);
    }

    public Iterable<WebItem> getDisplayableWebItems(String section, Map<String, Object> context) {
        return this.getDynamicWebItems(this.getDisplayableItems(section, context), section, context);
    }

    public Iterable<WebSection> getWebSections(String location, Map<String, Object> context) {
        return this.getDynamicWebSections(this.getSections(location), location, context);
    }

    public Iterable<WebSection> getDisplayableWebSections(String location, Map<String, Object> context) {
        return this.getDynamicWebSections(this.getDisplayableSections(location, context), location, context);
    }

    private Iterable<WebItem> getDynamicWebItems(List<com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor> staticItems, String section, Map<String, Object> context) {
        ArrayList dynamicWebItems = Lists.newArrayList((Iterable)Iterables.transform(staticItems, (Function)new WebItemConverter(context)));
        for (WebItemProviderModuleDescriptor itemProvider : (List)this.itemProviders.getUnchecked((Object)section)) {
            try {
                Optional<Iterable> providedItems = Optional.ofNullable(itemProvider.getModule().getItems(context));
                providedItems.ifPresent(webItems -> Iterables.addAll((Collection)dynamicWebItems, (Iterable)webItems));
            }
            catch (RuntimeException e) {
                if (log.isDebugEnabled()) {
                    log.error("WebItemProvider from module '{}' threw an error '{}'. Web-items provided by this provider will be ignored.", new Object[]{itemProvider.getCompleteKey(), e.getMessage(), e});
                    continue;
                }
                log.error("WebItemProvider from module '{}' threw an error '{}'. Web-items provided by this provider will be ignored.", (Object)itemProvider.getCompleteKey(), (Object)e.getMessage());
            }
        }
        dynamicWebItems.sort(WeightedComparator.WEIGHTED_FRAGMENT_COMPARATOR);
        return dynamicWebItems;
    }

    private Iterable<WebSection> getDynamicWebSections(List<com.atlassian.plugin.web.descriptors.WebSectionModuleDescriptor> staticSections, String location, Map<String, Object> context) {
        ArrayList dynamicWebSections = Lists.newArrayList((Iterable)Iterables.transform(staticSections, (Function)new WebSectionConverter(context)));
        for (WebSectionProviderModuleDescriptor provider : (List)this.sectionProviders.getUnchecked((Object)location)) {
            try {
                Optional<Iterable> sections = Optional.ofNullable(provider.getModule().getSections(context));
                sections.ifPresent(webSections -> Iterables.addAll((Collection)dynamicWebSections, (Iterable)webSections));
            }
            catch (RuntimeException e) {
                if (log.isDebugEnabled()) {
                    log.error("WebSectionProvider from module '{}' threw an error '{}'. Web-sections provided by this provider will be ignored.", new Object[]{provider.getCompleteKey(), e.getMessage(), e});
                    continue;
                }
                log.error("WebSectionProvider from module '{}' threw an error '{}'. Web-sections provided by this provider will be ignored.", (Object)provider.getCompleteKey(), (Object)e.getMessage());
            }
        }
        dynamicWebSections.sort(WeightedComparator.WEIGHTED_FRAGMENT_COMPARATOR);
        return dynamicWebSections;
    }

    private class WebSectionCacheLoader
    extends CacheLoader<String, List<com.atlassian.plugin.web.descriptors.WebSectionModuleDescriptor>> {
        private WebSectionCacheLoader() {
        }

        public List<com.atlassian.plugin.web.descriptors.WebSectionModuleDescriptor> load(String location) throws Exception {
            List webSectionModuleDescriptors = DefaultWebInterfaceManager.this.pluginAccessor.getEnabledModuleDescriptorsByClass(WebSectionModuleDescriptor.class);
            return webSectionModuleDescriptors.stream().filter(webSectionModuleDescriptor -> Objects.equals(location, webSectionModuleDescriptor.getLocation())).sorted(WEIGHTED_DESCRIPTOR_COMPARATOR).toList();
        }
    }

    private class WebItemCacheLoader
    extends CacheLoader<String, List<com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor>> {
        private WebItemCacheLoader() {
        }

        public List<com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor> load(String section) {
            List webItemModuleDescriptors = DefaultWebInterfaceManager.this.pluginAccessor.getEnabledModuleDescriptorsByClass(WebItemModuleDescriptor.class);
            return webItemModuleDescriptors.stream().filter(descriptor -> Objects.equals(section, descriptor.getSection())).sorted(WEIGHTED_DESCRIPTOR_COMPARATOR).toList();
        }
    }

    private class WebPanelCacheLoader
    extends CacheLoader<String, List<WebPanelModuleDescriptor>> {
        private WebPanelCacheLoader() {
        }

        public List<WebPanelModuleDescriptor> load(String location) throws Exception {
            List webPanelModuleDescriptors = DefaultWebInterfaceManager.this.pluginAccessor.getEnabledModuleDescriptorsByClass(com.atlassian.plugin.web.api.descriptors.WebPanelModuleDescriptor.class);
            return webPanelModuleDescriptors.stream().filter(webPanelModuleDescriptor -> Objects.equals(location, webPanelModuleDescriptor.getLocation())).sorted(WEIGHTED_DESCRIPTOR_COMPARATOR).toList();
        }
    }

    private class WebItemProviderCacheLoader
    extends CacheLoader<String, List<WebItemProviderModuleDescriptor>> {
        private WebItemProviderCacheLoader() {
        }

        public List<WebItemProviderModuleDescriptor> load(String section) throws Exception {
            List webItemProviderModuleDescriptors = DefaultWebInterfaceManager.this.pluginAccessor.getEnabledModuleDescriptorsByClass(WebItemProviderModuleDescriptor.class);
            return webItemProviderModuleDescriptors.stream().filter(webItemProviderModuleDescriptor -> Objects.equals(webItemProviderModuleDescriptor.getSection(), section)).collect(Collectors.toList());
        }
    }

    private class WebSectionProviderCacheLoader
    extends CacheLoader<String, List<WebSectionProviderModuleDescriptor>> {
        private WebSectionProviderCacheLoader() {
        }

        public List<WebSectionProviderModuleDescriptor> load(String location) throws Exception {
            List webSectionProviderModuleDescriptors = DefaultWebInterfaceManager.this.pluginAccessor.getEnabledModuleDescriptorsByClass(WebSectionProviderModuleDescriptor.class);
            return webSectionProviderModuleDescriptors.stream().filter(webSectionProviderModuleDescriptor -> Objects.equals(webSectionProviderModuleDescriptor.getLocation(), location)).collect(Collectors.toList());
        }
    }

    private static class WebItemConverter
    implements Function<com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor, WebItem> {
        private final Map<String, Object> context;

        public WebItemConverter(Map<String, Object> context) {
            this.context = context;
        }

        public WebItem apply(com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor input) {
            WebFragmentBuilder builder = new WebFragmentBuilder(input.getCompleteKey(), input.getWeight());
            builder.styleClass(input.getStyleClass());
            if (input.getWebLabel() != null) {
                builder.label(input.getWebLabel().getDisplayableLabel(null, this.context));
            }
            if (input.getTooltip() != null) {
                builder.title(input.getTooltip().getDisplayableLabel(null, this.context));
            }
            if (input.getParams() != null) {
                builder.params(input.getParams());
            }
            if (input.getIcon() != null && input.getIcon().getUrl() != null) {
                builder.addParam("iconUrl", input.getIcon().getUrl().getRenderedUrl(this.context));
            }
            WebFragmentBuilder.WebItemBuilder webItemBuilder = builder.webItem(input.getSection(), input.getEntryPoint());
            WebLink link = input.getLink();
            if (link != null) {
                Optional<HttpServletRequest> httpRequest;
                builder.id(link.getId());
                if (link.hasAccessKey()) {
                    webItemBuilder.accessKey(link.getAccessKey(this.context));
                }
                String url = (httpRequest = Optional.ofNullable((HttpServletRequest)this.context.get("request"))).isPresent() ? link.getDisplayableUrl(httpRequest.get(), this.context) : link.getRenderedUrl(this.context);
                webItemBuilder.url(url);
            }
            return webItemBuilder.build();
        }
    }

    private static class WebSectionConverter
    implements Function<com.atlassian.plugin.web.descriptors.WebSectionModuleDescriptor, WebSection> {
        private final Map<String, Object> context;

        public WebSectionConverter(Map<String, Object> context) {
            this.context = context;
        }

        public WebSection apply(com.atlassian.plugin.web.descriptors.WebSectionModuleDescriptor input) {
            WebFragmentBuilder builder = new WebFragmentBuilder(input.getCompleteKey(), input.getWeight());
            builder.id(input.getKey());
            if (input.getWebLabel() != null) {
                builder.label(input.getWebLabel().getDisplayableLabel(null, this.context));
            }
            if (input.getTooltip() != null) {
                builder.title(input.getTooltip().getDisplayableLabel(null, this.context));
            }
            if (input.getParams() != null) {
                builder.params(input.getParams());
            }
            return builder.webSection(input.getLocation()).build();
        }
    }
}

