/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.web.descriptors;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.StateAware;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.descriptors.ModuleDescriptors;
import com.atlassian.plugin.internal.module.Dom4jDelegatingElement;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.api.conditions.ConditionLoadingException;
import com.atlassian.plugin.web.api.descriptors.WebFragmentModuleDescriptor;
import com.atlassian.plugin.web.descriptors.ConditionElementParser;
import com.atlassian.plugin.web.descriptors.ContextProviderElementParser;
import com.atlassian.plugin.web.descriptors.WeightElementParser;
import com.atlassian.plugin.web.model.DefaultWebLabel;
import com.atlassian.plugin.web.model.WebLabel;
import java.util.List;

public abstract class AbstractWebFragmentModuleDescriptor<T>
extends AbstractModuleDescriptor<T>
implements StateAware,
WebFragmentModuleDescriptor<T> {
    protected WebInterfaceManager webInterfaceManager;
    protected int weight;
    protected Condition condition;
    protected ContextProvider contextProvider;
    protected DefaultWebLabel label;
    protected DefaultWebLabel tooltip;
    private ConditionElementParser conditionElementParser;
    private ContextProviderElementParser contextProviderElementParser;
    private Element descriptorElement;

    protected AbstractWebFragmentModuleDescriptor(WebInterfaceManager webInterfaceManager) {
        super(ModuleFactory.LEGACY_MODULE_FACTORY);
        this.setWebInterfaceManager(webInterfaceManager);
    }

    public AbstractWebFragmentModuleDescriptor() {
        super(ModuleFactory.LEGACY_MODULE_FACTORY);
    }

    public AbstractWebFragmentModuleDescriptor(ModuleFactory moduleClassFactory, WebInterfaceManager webInterfaceManager) {
        super(moduleClassFactory);
        this.setWebInterfaceManager(webInterfaceManager);
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.descriptorElement = element;
        this.weight = WeightElementParser.getWeight(element);
    }

    protected Condition buildConditions(Element element, int type) throws PluginParseException {
        return this.getRequiredConditionElementParser().makeConditions(this.plugin, element, type);
    }

    protected Condition buildConditions(List<Element> elements, int type) throws PluginParseException {
        return this.getRequiredConditionElementParser().makeConditions(this.plugin, elements, type);
    }

    protected Condition buildCondition(Element element) throws PluginParseException {
        return this.getRequiredConditionElementParser().makeCondition(this.plugin, element);
    }

    protected ContextProvider buildContextProvider(Element element) throws PluginParseException {
        return this.contextProviderElementParser.makeContextProvider(this.plugin, (Element)new Dom4jDelegatingElement(((Dom4jDelegatingElement)element).getDelegate().getParent()));
    }

    private ConditionElementParser getRequiredConditionElementParser() {
        if (this.conditionElementParser == null) {
            throw new IllegalStateException("ModuleDescriptorHelper not available because the WebInterfaceManager has not been injected.");
        }
        return this.conditionElementParser;
    }

    public void enabled() {
        super.enabled();
        try {
            Element tooltipElement;
            this.contextProvider = this.contextProviderElementParser.makeContextProvider(this.plugin, this.descriptorElement);
            Element labelElement = this.descriptorElement.element("label");
            if (labelElement != null) {
                this.label = new DefaultWebLabel(labelElement, this.webInterfaceManager.getWebFragmentHelper(), this.contextProvider, this);
            }
            if ((tooltipElement = this.descriptorElement.element("tooltip")) != null) {
                this.tooltip = new DefaultWebLabel(tooltipElement, this.webInterfaceManager.getWebFragmentHelper(), this.contextProvider, this);
            }
            this.condition = this.buildConditions(this.descriptorElement, 1);
        }
        catch (PluginParseException e) {
            throw new RuntimeException("Unable to enable web fragment", e);
        }
        this.webInterfaceManager.refresh();
    }

    public void disabled() {
        this.condition = null;
        this.webInterfaceManager.refresh();
        super.disabled();
    }

    public int getWeight() {
        return this.weight;
    }

    public WebLabel getWebLabel() {
        return this.label;
    }

    public WebLabel getTooltip() {
        return this.tooltip;
    }

    public void setWebInterfaceManager(final WebInterfaceManager webInterfaceManager) {
        this.webInterfaceManager = webInterfaceManager;
        this.conditionElementParser = new ConditionElementParser(new ConditionElementParser.ConditionFactory(){

            @Override
            public Condition create(String className, Plugin plugin) throws ConditionLoadingException {
                return webInterfaceManager.getWebFragmentHelper().loadCondition(className, plugin);
            }
        });
        this.contextProviderElementParser = new ContextProviderElementParser(webInterfaceManager.getWebFragmentHelper());
    }

    public Condition getCondition() {
        return this.condition;
    }

    public ContextProvider getContextProvider() {
        return this.contextProvider;
    }

    public boolean equals(Object obj) {
        return new ModuleDescriptors.EqualsBuilder().descriptor((ModuleDescriptor)this).isEqualTo(obj);
    }

    public int hashCode() {
        return new ModuleDescriptors.HashCodeBuilder().descriptor((ModuleDescriptor)this).toHashCode();
    }
}

