package com.atlassian.webresource.api.assembler;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.json.marshal.Jsonable;

import java.util.Set;

/**
 * Interface for clients to require data blobs.
 * @since v3.0
 */
@ExperimentalApi
public interface RequiredData
{
   /**
     * Specifies that JSON data with the given key should be included on the next call to drainIncludedResources().
     * @param key data key
     * @param content JSON data
     * @return this, to support method chaining
     */
    public RequiredData requireData(String key, Jsonable content);

    /**
     * Specifies that JSON data with the given key should be included on the next call to drainIncludedResources().
     * @param key data key
     * @param content content to render
     * @return this, to support method chaining
     */
    public RequiredData requireData(String key, Number content);

    /**
     * Specifies that JSON data with the given key should be included on the next call to drainIncludedResources().
     * @param key data key
     * @param content content to render
     * @return this, to support method chaining
     */
    public RequiredData requireData(String key, String content);

    /**
     * Specifies that JSON data with the given key should be included on the next call to drainIncludedResources().
     * @param key data key
     * @param content content to render
     * @return this, to support method chaining
     */
    public RequiredData requireData(String key, Boolean content);
}
