/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.servlet;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.servlet.DownloadException;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.servlet.util.LastModifiedHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

abstract class AbstractDownloadableResource
implements DownloadableResource {
    private static final Log log = LogFactory.getLog(AbstractDownloadableResource.class);
    protected Plugin plugin;
    protected String extraPath;
    protected ResourceLocation resourceLocation;

    public AbstractDownloadableResource(Plugin plugin, ResourceLocation resourceLocation, String extraPath) {
        if (extraPath != null && !"".equals(extraPath.trim()) && !resourceLocation.getLocation().endsWith("/")) {
            extraPath = "/" + extraPath;
        }
        this.plugin = plugin;
        this.extraPath = extraPath;
        this.resourceLocation = resourceLocation;
    }

    public void serveResource(HttpServletRequest request, HttpServletResponse response) throws DownloadException {
        ServletOutputStream out;
        log.debug((Object)("Serving: " + this));
        InputStream resourceStream = this.getResourceAsStream();
        if (resourceStream == null) {
            log.warn((Object)("Resource not found: " + this));
            return;
        }
        if (StringUtils.isNotBlank((String)this.getContentType())) {
            response.setContentType(this.getContentType());
        }
        try {
            out = response.getOutputStream();
        }
        catch (IOException e) {
            throw new DownloadException(e);
        }
        this.streamResource(resourceStream, (OutputStream)out);
        log.debug((Object)"Serving file done.");
    }

    public void streamResource(OutputStream out) {
        InputStream resourceStream = this.getResourceAsStream();
        if (resourceStream == null) {
            log.warn((Object)("Resource not found: " + this));
            return;
        }
        this.streamResource(resourceStream, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void streamResource(InputStream in, OutputStream out) {
        try {
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        catch (IOException e) {
            log.error((Object)"Error serving the requested file", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
            try {
                out.flush();
            }
            catch (IOException e) {
                log.warn((Object)"Error flushing output stream", (Throwable)e);
            }
        }
    }

    public boolean isResourceModified(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Date resourceLastModifiedDate = this.plugin.getDateLoaded() == null ? new Date() : this.plugin.getDateLoaded();
        LastModifiedHandler lastModifiedHandler = new LastModifiedHandler(resourceLastModifiedDate);
        return lastModifiedHandler.checkRequest(httpServletRequest, httpServletResponse);
    }

    public String getContentType() {
        return this.resourceLocation.getContentType();
    }

    protected abstract InputStream getResourceAsStream();

    protected String getLocation() {
        return this.resourceLocation.getLocation() + this.extraPath;
    }

    public String toString() {
        return "Resource: " + this.getLocation() + " (" + this.getContentType() + ")";
    }
}

