/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.transformer.instance;

import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.QueryParams;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.plugin.webresource.transformer.SearchAndReplaceDownloadableResource;
import com.atlassian.plugin.webresource.transformer.SearchAndReplacer;
import com.atlassian.plugin.webresource.transformer.TransformableResource;
import com.atlassian.plugin.webresource.transformer.TransformerParameters;
import com.atlassian.plugin.webresource.transformer.TransformerUrlBuilder;
import com.atlassian.plugin.webresource.transformer.UrlReadingWebResourceTransformer;
import com.atlassian.plugin.webresource.transformer.WebResourceTransformerFactory;
import com.atlassian.plugin.webresource.url.UrlBuilder;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.base.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RelativeUrlTransformerFactory
implements WebResourceTransformerFactory {
    static final String RELATIVE_URL_QUERY_KEY = "relative-url";
    private static final Pattern CSS_URL_PATTERN = Pattern.compile("url\\s*\\(\\s*+([\"'])?+(?!/|https?://|data:)");
    private final WebResourceIntegration webResourceIntegration;
    private final WebResourceUrlProvider webResourceUrlProvider;

    public RelativeUrlTransformerFactory(WebResourceIntegration webResourceIntegration, WebResourceUrlProvider webResourceUrlProvider) {
        this.webResourceIntegration = webResourceIntegration;
        this.webResourceUrlProvider = webResourceUrlProvider;
    }

    @Override
    public TransformerUrlBuilder makeUrlBuilder(TransformerParameters parameters) {
        return new RelativeUrlTransformerUrlBuilder();
    }

    @Override
    public UrlReadingWebResourceTransformer makeResourceTransformer(TransformerParameters parameters) {
        return new RelativeUrlTransformer(parameters);
    }

    public static class CdnStrategyChangedException
    extends RuntimeException {
        public CdnStrategyChangedException(String message) {
            super(message);
        }
    }

    class RelativeUrlTransformer
    implements UrlReadingWebResourceTransformer {
        private final TransformerParameters parameters;

        RelativeUrlTransformer(TransformerParameters parameters) {
            this.parameters = parameters;
        }

        @Override
        public DownloadableResource transform(TransformableResource transformableResource, QueryParams params) {
            boolean requestCdnUrl = Boolean.valueOf(params.get(RelativeUrlTransformerFactory.RELATIVE_URL_QUERY_KEY));
            final LazyReference<String> urlPrefix = this.createUrlPrefixRef(requestCdnUrl);
            Function<Matcher, CharSequence> replacer = new Function<Matcher, CharSequence>(){

                public CharSequence apply(Matcher matcher) {
                    return new StringBuilder(matcher.group()).append((String)urlPrefix.get());
                }
            };
            SearchAndReplacer grep = SearchAndReplacer.create(CSS_URL_PATTERN, replacer);
            return new SearchAndReplaceDownloadableResource(transformableResource.nextResource(), grep);
        }

        private LazyReference<String> createUrlPrefixRef(final boolean requestCdnUrl) {
            return new LazyReference<String>(){

                protected String create() {
                    String version = RelativeUrlTransformerFactory.this.webResourceIntegration.getPluginAccessor().getPlugin(RelativeUrlTransformer.this.parameters.getPluginKey()).getPluginInformation().getVersion();
                    String localRelativeUrl = RelativeUrlTransformerFactory.this.webResourceUrlProvider.getStaticResourcePrefix(version, UrlMode.RELATIVE) + "/download/resources" + "/" + RelativeUrlTransformer.this.parameters.getPluginKey() + ":" + RelativeUrlTransformer.this.parameters.getModuleKey() + "/";
                    if (requestCdnUrl) {
                        if (RelativeUrlTransformerFactory.this.webResourceIntegration.getCDNStrategy() == null || !RelativeUrlTransformerFactory.this.webResourceIntegration.getCDNStrategy().supportsCdn()) {
                            throw new CdnStrategyChangedException("CDN strategy has changed between url generation time and resource fetch time");
                        }
                        return RelativeUrlTransformerFactory.this.webResourceIntegration.getCDNStrategy().transformRelativeUrl(localRelativeUrl);
                    }
                    return localRelativeUrl;
                }
            };
        }
    }

    class RelativeUrlTransformerUrlBuilder
    implements TransformerUrlBuilder {
        RelativeUrlTransformerUrlBuilder() {
        }

        @Override
        public void addToUrl(UrlBuilder urlBuilder) {
            if (RelativeUrlTransformerFactory.this.webResourceIntegration.getCDNStrategy() != null && RelativeUrlTransformerFactory.this.webResourceIntegration.getCDNStrategy().supportsCdn()) {
                urlBuilder.addToQueryString(RelativeUrlTransformerFactory.RELATIVE_URL_QUERY_KEY, String.valueOf(true));
            }
        }
    }
}

