package com.atlassian.plugin.webresource.assembler;

import com.atlassian.plugin.webresource.PluginResource;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.webresource.api.UrlMode;
import com.atlassian.webresource.api.assembler.resource.PluginUrlResource;
import com.atlassian.webresource.api.assembler.resource.PluginUrlResourceParams;

/**
 * Implementation of PluginUrlResource
 * @since 3.0
 */
abstract class DefaultPluginUrlResource<T extends PluginUrlResourceParams> implements PluginUrlResource<T>
{
    protected final PluginResource pluginResource;

    public DefaultPluginUrlResource(PluginResource pluginResource)
    {
        this.pluginResource = pluginResource;
    }

    @Override
    public String getStaticUrl(UrlMode urlMode)
    {
        return pluginResource.getUrl(urlMode == UrlMode.ABSOLUTE);
    }

    @Override
    public String toString()
    {
        return pluginResource.getCompleteKey() + ":" + pluginResource.getResourceName();
    }
}
