package com.atlassian.plugin.webresource.bigpipe;

import com.atlassian.fugue.Either;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Represents a successful or failed invocation of an an asynchronous task.
 * @param <V> type of successful values
 * @since 3.3
 */
public final class KeyedValue<V>
{
    private final Key key;
    private final Either<Exception, V> value;

    public static <V> KeyedValue success(Key key, V value)
    {
        return new KeyedValue(key, Either.<Exception, V>right(value));
    }

    public static <V> KeyedValue fail(Key key, Exception ex)
    {
        return new KeyedValue(key, Either.<Exception, V>left(ex));
    }

    public KeyedValue(Key key, Either<Exception, V> value)
    {
        this.key = checkNotNull(key);
        this.value = checkNotNull(value);
    }

    public Key key()
    {
        return key;
    }

    public Either<Exception, V> value()
    {
        return value;
    }
}
