package com.atlassian.plugin.webresource.condition;

import com.atlassian.plugin.webresource.QueryParams;
import com.atlassian.plugin.webresource.url.DefaultUrlBuilder;
import com.atlassian.plugin.webresource.url.UrlBuilder;

import java.util.Map;

/**
 * Instance of a DecoratingCondition that wraps a UrlReadingCondition
 * @since v3.0
 */
class DecoratingUrlReadingCondition implements DecoratingCondition
{
    protected final UrlReadingCondition urlReadingCondition;
    private final boolean invert;

    public DecoratingUrlReadingCondition(UrlReadingCondition urlReadingCondition)
    {
        this(urlReadingCondition, false);
    }

    public DecoratingUrlReadingCondition(UrlReadingCondition urlReadingCondition, boolean invert)
    {
        this.urlReadingCondition = urlReadingCondition;
        this.invert = invert;
    }

    @Override
    public void addToUrl(UrlBuilder urlBuilder)
    {
        urlReadingCondition.addToUrl(urlBuilder);
    }

    @Override
    public boolean canEncodeStateIntoUrl()
    {
        return true;
    }

    @Override
    public boolean shouldDisplayImmediate(Map<String, Object> context)
    {
        DefaultUrlBuilder urlBuilder = new DefaultUrlBuilder();
        addToUrl(urlBuilder);
        return shouldDisplay(QueryParams.of(urlBuilder.build().toQueryString()));
    }

    @Override
    public boolean shouldDisplay(QueryParams params)
    {
        boolean shouldDisplay = urlReadingCondition.shouldDisplay(params);
        return invert ? !shouldDisplay : shouldDisplay;
    }

    @Override
    public DecoratingCondition invertCondition()
    {
        return new DecoratingUrlReadingCondition(urlReadingCondition, !invert);
    }
}
