/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.webresource.AbstractPluginResource;
import com.atlassian.plugin.webresource.BatchedWebResourceDescriptor;
import com.atlassian.plugin.webresource.Globals;
import com.atlassian.plugin.webresource.ResourceUtils;
import com.atlassian.plugin.webresource.http.Router;
import com.atlassian.plugin.webresource.url.UrlParameters;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ContextBatchPluginResource
extends AbstractPluginResource {
    private final String key;
    private final String versionHash;
    private final List<String> contexts;
    private final Iterable<String> excludedContexts;
    private final String name;
    private final String type;

    ContextBatchPluginResource(Globals globals, String key, List<String> contexts, Iterable<String> excludedContexts, String versionHash, String type, UrlParameters urlParams, Map<String, String> params, Set<BatchedWebResourceDescriptor> batchedWebResourceDescriptor) {
        super(globals, urlParams, params, Collections.unmodifiableSet(batchedWebResourceDescriptor));
        this.name = "batch." + type;
        this.type = type;
        this.key = key;
        this.versionHash = versionHash;
        this.contexts = contexts;
        this.excludedContexts = excludedContexts;
    }

    Iterable<String> getContexts() {
        return this.contexts;
    }

    public Iterable<String> getExcludedContexts() {
        return this.excludedContexts;
    }

    @Override
    public String getVersion() {
        return this.versionHash;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public boolean isCacheSupported() {
        return true;
    }

    @Override
    public String getResourceName() {
        return this.name;
    }

    @Override
    public String getCompleteKey() {
        return "contextbatch-" + this.name;
    }

    public String getContext() {
        return this.key;
    }

    public Collection<ContextBatchPluginResource> splitIntoParts() {
        if (this.contexts.size() <= 1) {
            return Collections.singletonList(this);
        }
        LinkedList<ContextBatchPluginResource> result = new LinkedList<ContextBatchPluginResource>();
        ArrayList<String> furtherExcludes = new ArrayList<String>();
        for (String ctx : this.contexts) {
            Iterable totalExcludes = Iterables.concat(this.excludedContexts, furtherExcludes);
            List<String> newContexts = Collections.singletonList(ctx);
            String newKey = Router.encodeContexts(newContexts, totalExcludes);
            result.add(new ContextBatchPluginResource(this.globals, newKey, newContexts, totalExcludes, this.versionHash, this.getType(), this.urlParams, this.params, this.batchedWebResourceDescriptors));
            furtherExcludes.add(ctx);
        }
        return result;
    }

    @Override
    public String getUrl(boolean isAbsolute) {
        return this.globals.getRouter().cloneWithNewUrlMode(isAbsolute).urlFor(this);
    }

    @Override
    public Map<String, String> getParamsWithBatchableParams() {
        return ResourceUtils.mergeParamList(this.params, this.urlParams.toQueryString());
    }

    public String toString() {
        return "[Context Batch type=" + this.getType() + ", params=" + this.params + "]";
    }
}

