/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.annotations.Internal;
import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.webresource.Bundle;
import com.atlassian.plugin.webresource.Content;
import com.atlassian.plugin.webresource.Helpers;
import com.atlassian.plugin.webresource.PluginResourceLocator;
import com.google.common.base.Objects;
import java.util.Date;
import java.util.Map;

@Internal
public class Resource {
    private final Bundle parent;
    private final String type;
    private final boolean isBatchable;
    private final ResourceLocation resourceLocation;
    private final boolean isRedirect;
    private final boolean isCacheable;

    protected Resource(Bundle parent, ResourceLocation resourceLocation, String type, boolean isBatchable, boolean isRedirect, boolean isCacheable) {
        this.parent = parent;
        this.type = type;
        this.isBatchable = isBatchable;
        this.isRedirect = isRedirect;
        this.isCacheable = isCacheable;
        this.resourceLocation = resourceLocation;
    }

    public Bundle getParent() {
        return this.parent;
    }

    public String getName() {
        return this.resourceLocation.getName();
    }

    public String getLocation() {
        return this.resourceLocation.getLocation();
    }

    public boolean isRedirect() {
        return this.isRedirect;
    }

    public String getType() {
        return this.type;
    }

    public String getContentType() {
        return this.resourceLocation.getContentType();
    }

    public boolean isBatchable() {
        return this.isBatchable;
    }

    public boolean isBatchable(Map<String, String> batchParams) {
        if (!this.isBatchable || this.isRedirect()) {
            return false;
        }
        for (String key : PluginResourceLocator.BATCH_PARAMS) {
            if (Helpers.equals(batchParams.get(key), this.getParams().get(key))) continue;
            return false;
        }
        return true;
    }

    public Map<String, String> getParams() {
        return this.resourceLocation.getParams();
    }

    public Date getUpdatedAt() {
        return this.parent.getUpdatedAt();
    }

    public boolean isTransformable() {
        return this.parent.isTransformable();
    }

    public String getVersion() {
        return this.parent.getVersion();
    }

    public String getKey() {
        return this.parent.getKey();
    }

    public boolean isCacheable() {
        return this.isCacheable;
    }

    public boolean isCdnSupported() {
        return this.parent.isCdnSupported();
    }

    public Content getContent() {
        return this.parent.getSnapshot().config.getContentFor(this);
    }

    @Deprecated
    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Resource resource = (Resource)o;
        return this.parent.equals(resource.parent) && this.getName().equals(resource.getName());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.parent, this.getName()});
    }

    public String toString() {
        return "{" + this.getName() + (!this.isBatchable() ? " isNotBatchable" : "") + "}";
    }

    @Deprecated
    public String getFilePath() {
        return "";
    }
}

