/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.assembler;

import com.atlassian.plugin.webresource.DefaultResourceDependencyResolver;
import com.atlassian.plugin.webresource.PluginResourceLocator;
import com.atlassian.plugin.webresource.ResourceBatchingConfiguration;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.assembler.DefaultWebResourceAssembler;
import com.atlassian.plugin.webresource.assembler.WebResourceSetCache;
import com.atlassian.plugin.webresource.transformer.StaticTransformers;
import com.atlassian.webresource.api.assembler.WebResourceAssembler;
import com.atlassian.webresource.api.assembler.WebResourceAssemblerBuilder;
import java.util.Collections;
import java.util.List;

public class DefaultWebResourceAssemblerBuilder
implements WebResourceAssemblerBuilder {
    private final ResourceBatchingConfiguration batchingConfiguration;
    private final WebResourceIntegration webResourceIntegration;
    private final PluginResourceLocator pluginResourceLocator;
    private final StaticTransformers staticTransformers;
    private final WebResourceSetCache webResourceSetCache;
    private Boolean overrideSuperBatchingEnabled;

    public DefaultWebResourceAssemblerBuilder(ResourceBatchingConfiguration batchingConfiguration, WebResourceIntegration webResourceIntegration, PluginResourceLocator pluginResourceLocator, StaticTransformers staticTransformers, WebResourceSetCache webResourceSetCache) {
        this.batchingConfiguration = batchingConfiguration;
        this.webResourceIntegration = webResourceIntegration;
        this.pluginResourceLocator = pluginResourceLocator;
        this.staticTransformers = staticTransformers;
        this.webResourceSetCache = webResourceSetCache;
    }

    public WebResourceAssembler build() {
        ResourceBatchingConfiguration bc = this.overrideSuperBatchingEnabled == null ? this.batchingConfiguration : new SuperBatchOverridingResourceBatchingConfiguration(this.batchingConfiguration, this.overrideSuperBatchingEnabled);
        DefaultWebResourceAssembler assembler = new DefaultWebResourceAssembler(bc, this.webResourceIntegration, this.pluginResourceLocator, this.staticTransformers, this.webResourceSetCache);
        if (bc.isSuperBatchingEnabled()) {
            assembler.resources().requireContext(DefaultResourceDependencyResolver.IMPLICIT_CONTEXT_NAME);
        }
        return assembler;
    }

    public WebResourceAssemblerBuilder includeSuperbatchResources(boolean include) {
        this.overrideSuperBatchingEnabled = include;
        return this;
    }

    private static class SuperBatchOverridingResourceBatchingConfiguration
    implements ResourceBatchingConfiguration {
        private final ResourceBatchingConfiguration config;
        private final boolean superBatchingEnabled;

        private SuperBatchOverridingResourceBatchingConfiguration(ResourceBatchingConfiguration config, boolean superBatchingEnabled) {
            this.config = config;
            this.superBatchingEnabled = superBatchingEnabled;
        }

        @Override
        public boolean isSuperBatchingEnabled() {
            return this.superBatchingEnabled;
        }

        @Override
        public List<String> getSuperBatchModuleCompleteKeys() {
            return this.superBatchingEnabled ? this.config.getSuperBatchModuleCompleteKeys() : Collections.emptyList();
        }

        @Override
        public boolean isContextBatchingEnabled() {
            return this.config.isContextBatchingEnabled();
        }

        @Override
        public boolean isPluginWebResourceBatchingEnabled() {
            return this.config.isPluginWebResourceBatchingEnabled();
        }

        @Override
        public boolean isJavaScriptTryCatchWrappingEnabled() {
            return this.config.isJavaScriptTryCatchWrappingEnabled();
        }

        @Override
        public boolean isBatchContentTrackingEnabled() {
            return this.config.isBatchContentTrackingEnabled();
        }

        @Override
        public boolean resplitMergedContextBatchesForThisRequest() {
            return this.config.resplitMergedContextBatchesForThisRequest();
        }

        @Override
        public boolean isSourceMapEnabled() {
            return this.config.isSourceMapEnabled();
        }
    }
}

