/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.http;

import com.atlassian.annotations.Internal;
import com.atlassian.plugin.cache.filecache.Cache;
import com.atlassian.plugin.servlet.util.LastModifiedHandler;
import com.atlassian.plugin.webresource.Content;
import com.atlassian.plugin.webresource.Globals;
import com.atlassian.plugin.webresource.Helpers;
import com.atlassian.plugin.webresource.RequestCache;
import com.atlassian.plugin.webresource.Resource;
import com.atlassian.plugin.webresource.support.NullOutputStream;
import com.atlassian.plugin.webresource.support.http.BaseController;
import com.atlassian.plugin.webresource.support.http.BaseRouter;
import com.atlassian.plugin.webresource.support.http.Request;
import com.atlassian.plugin.webresource.support.http.Response;
import com.atlassian.sourcemap.SourceMap;
import com.atlassian.sourcemap.Util;
import com.google.common.base.Supplier;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Date;

@Internal
public class Controller
extends BaseController {
    private final RequestCache requestCache = new RequestCache();

    public Controller(Globals globals, Request request, Response response) {
        super(globals, request, response);
    }

    public void serveResource(String completeKey, String resourceName) {
        this.serveResource(Helpers.getResource(this.globals, this.requestCache, completeKey, resourceName), true);
    }

    public void serveResourceSourceMap(String completeKey, String resourceName) {
        this.serveSourceMap(Helpers.getResource(this.globals, this.requestCache, completeKey, resourceName));
    }

    public void serveBatch(final Collection<String> included, final Collection<String> excluded, final String type, final boolean resolveDependencies, final boolean includeLegacy, boolean isCachingEnabled) {
        this.serveResources(new Supplier<Collection<Resource>>(){

            public Collection<Resource> get() {
                Collection<String> bundles = Helpers.resolveBundles(Controller.this.globals, included, excluded, resolveDependencies, includeLegacy, Controller.this.request.getParams());
                return Helpers.selectForBatch(Helpers.getResources(Controller.this.globals, Controller.this.requestCache, bundles), type, Controller.this.request.getParams());
            }
        }, isCachingEnabled);
    }

    public void serveBatchSourceMap(final Collection<String> included, final Collection<String> excluded, final String type, final boolean resolveDependencies, final boolean includeLegacy) {
        this.serveResourcesSourceMap(new Supplier<Collection<Resource>>(){

            public Collection<Resource> get() {
                Collection<String> bundles = Helpers.resolveBundles(Controller.this.globals, included, excluded, resolveDependencies, includeLegacy, Controller.this.request.getParams());
                return Helpers.selectForBatch(Helpers.getResources(Controller.this.globals, Controller.this.requestCache, bundles), type, Controller.this.request.getParams());
            }
        });
    }

    public void serveResourceRelativeToBatch(Collection<String> included, Collection<String> excluded, String resourceName, boolean resolveDependencies, boolean includeLegacy) {
        Collection<String> bundles = Helpers.resolveBundles(this.globals, included, excluded, resolveDependencies, includeLegacy, this.request.getParams());
        this.serveResource(Helpers.getResource(this.globals, this.requestCache, bundles, resourceName), true);
    }

    public void serveResourceRelativeToBatchSourceMap(Collection<String> included, Collection<String> excluded, String resourceName, boolean resolveDependencies, boolean includeLegacy) {
        Collection<String> bundles = Helpers.resolveBundles(this.globals, included, excluded, resolveDependencies, includeLegacy, this.request.getParams());
        this.serveSourceMap(Helpers.getResource(this.globals, this.requestCache, bundles, resourceName));
    }

    public void serveSource(String completeKey, String resourceName) {
        this.serveResource(Helpers.getResource(this.globals, this.requestCache, completeKey, resourceName), false);
    }

    protected void serveResource(Resource resource, boolean applyTransformations) {
        if (this.handleNotFoundRedirectAndNotModified(resource)) {
            return;
        }
        Content content = Helpers.isConditionSatisfied(resource.getParent(), this.request.getParams()) ? (applyTransformations ? Helpers.transform(this.globals, resource, this.request.getParams()) : resource.getContent()) : Helpers.buildEmptyContent(resource.getContent());
        this.sendCached(this.request.getUrl(), content, false);
    }

    protected void serveResources(Supplier<Collection<Resource>> resources, boolean isCachingEnabled) {
        String type = this.request.getType();
        Content content = Helpers.transform(this.globals, type, resources, this.request.getParams());
        this.sendCached(this.request.getUrl(), content, isCachingEnabled);
    }

    protected void serveSourceMap(Resource resource) {
        String resourcePath = this.globals.getRouter().resourcePathFromSourceMapPath(this.request.getPath());
        String cacheKey = BaseRouter.buildUrl(resourcePath, this.request.getParams());
        if (this.handleNotFoundRedirectAndNotModified(resource)) {
            return;
        }
        Content content = Helpers.transform(this.globals, resource, this.request.getParams());
        this.sendCached(cacheKey, content);
    }

    private void serveResourcesSourceMap(Supplier<Collection<Resource>> resources) {
        String resourcePath = this.globals.getRouter().resourcePathFromSourceMapPath(this.request.getPath());
        String cacheKey = BaseRouter.buildUrl(resourcePath, this.request.getParams());
        String type = Request.getType(resourcePath);
        Content content = Helpers.transform(this.globals, type, resources, this.request.getParams());
        this.sendCached(cacheKey, content);
    }

    protected boolean handleNotFoundRedirectAndNotModified(Resource resource) {
        if (resource == null) {
            this.response.sendError(404);
            return true;
        }
        if (this.checkIfCachedAndNotModified(resource.getParent().getUpdatedAt())) {
            return true;
        }
        if (resource.isRedirect()) {
            this.response.sendRedirect(resource.getLocation(), resource.getContentType());
            return true;
        }
        return false;
    }

    protected boolean checkIfCachedAndNotModified(Date updatedAt) {
        LastModifiedHandler lastModifiedHandler = new LastModifiedHandler(updatedAt);
        return this.request.isCacheable() && lastModifiedHandler.checkRequest(this.request.getOriginalRequest(), this.response.getOriginalResponse());
    }

    protected void sendCached(String cacheKey, Content content) {
        this.sendCached(cacheKey, content, true);
    }

    protected CachedContent buildCachedContent(final String cacheKey, final Content content, final boolean isCacheEnabled) {
        class CachedContentImpl
        implements CachedContent {
            CachedContentImpl() {
            }

            @Override
            public void writeTo(OutputStream contentOut, OutputStream sourceMapOut, final String contentType, final boolean isSourceMapEnabled, final String sourceMapUrl) {
                this.cache(cacheKey, contentOut, sourceMapOut, new Cache.TwoStreamProvider(){

                    @Override
                    public void write(OutputStream contentOut, OutputStream sourceMapOut) {
                        if (contentOut == null) {
                            contentOut = new NullOutputStream();
                        }
                        try {
                            SourceMap sourceMap = content.writeTo(contentOut, isSourceMapEnabled);
                            if (isSourceMapEnabled && sourceMap != null) {
                                contentOut.write(("\n" + Util.generateSourceMapComment((String)sourceMapUrl, (String)contentType)).getBytes());
                                if (sourceMapOut != null) {
                                    sourceMapOut.write(sourceMap.generate().getBytes());
                                }
                            }
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }, isSourceMapEnabled, isCacheEnabled);
            }

            private void cache(String key, OutputStream contentOut, OutputStream sourceMapOut, final Cache.TwoStreamProvider twoStreamProvider, boolean isSourceMapEnabled, boolean isCacheEnabled2) {
                if (Controller.this.request.isCacheable() && isCacheEnabled2) {
                    if (isSourceMapEnabled) {
                        Controller.this.globals.getCache().cacheTwo("http", key, contentOut, sourceMapOut, twoStreamProvider);
                    } else {
                        Controller.this.globals.getCache().cache("http", key, contentOut, new Cache.StreamProvider(){

                            @Override
                            public void write(OutputStream out) {
                                twoStreamProvider.write(out, null);
                            }
                        });
                    }
                } else {
                    twoStreamProvider.write(contentOut, sourceMapOut);
                }
            }
        }
        return new CachedContentImpl();
    }

    @Deprecated
    protected void sendCached(String cacheKey, Content content, boolean isCacheEnabled) {
        CachedContent cachedContent = this.buildCachedContent(cacheKey, content, isCacheEnabled);
        if ("map".equals(this.request.getType())) {
            this.response.setContentTypeIfNotBlank(this.request.getContentType());
            String resourcePath = this.globals.getRouter().resourcePathFromSourceMapPath(this.request.getPath());
            String resourceContentType = content.getContentType() != null ? content.getContentType() : this.globals.getConfig().getContentType(resourcePath);
            String sourceMapUrl = this.request.getUrl();
            cachedContent.writeTo(null, this.response.getOutputStream(), resourceContentType, this.isSourceMapEnabled(), sourceMapUrl);
        } else {
            String contentType = content.getContentType() != null ? content.getContentType() : this.request.getContentType();
            this.response.setContentTypeIfNotBlank(contentType);
            String sourceMapUrl = this.globals.getRouter().sourceMapUrl(this.request.getPath(), this.request.getParams());
            cachedContent.writeTo(this.response.getOutputStream(), null, contentType, this.isSourceMapEnabled(), sourceMapUrl);
        }
    }

    protected boolean isSourceMapEnabled() {
        String resourcePath = "map".equals(this.request.getType()) ? this.globals.getRouter().resourcePathFromSourceMapPath(this.request.getPath()) : this.request.getPath();
        String type = Request.getType(resourcePath);
        return this.globals.getConfig().isSourceMapEnabledFor(type);
    }

    protected static interface CachedContent {
        public void writeTo(OutputStream var1, OutputStream var2, String var3, boolean var4, String var5);
    }
}

