/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.assembler;

import com.atlassian.plugin.webresource.BatchResourceContentsWebFormatter;
import com.atlassian.plugin.webresource.CssWebResource;
import com.atlassian.plugin.webresource.JavascriptWebResource;
import com.atlassian.plugin.webresource.PrefetchLinkWebResource;
import com.atlassian.plugin.webresource.ResourceUrl;
import com.atlassian.plugin.webresource.WebResourceFormatter;
import com.atlassian.plugin.webresource.assembler.DefaultPluginCssResource;
import com.atlassian.plugin.webresource.assembler.DefaultPluginJsResource;
import com.atlassian.plugin.webresource.assembler.DefaultPluginUrlResource;
import com.atlassian.plugin.webresource.data.DataTagWriter;
import com.atlassian.plugin.webresource.impl.RequestState;
import com.atlassian.plugin.webresource.impl.config.Config;
import com.atlassian.plugin.webresource.impl.helpers.ResourceServingHelpers;
import com.atlassian.plugin.webresource.impl.support.Content;
import com.atlassian.plugin.webresource.impl.support.Support;
import com.atlassian.webresource.api.UrlMode;
import com.atlassian.webresource.api.assembler.WebResource;
import com.atlassian.webresource.api.assembler.WebResourceSet;
import com.atlassian.webresource.api.assembler.resource.PluginUrlResource;
import com.atlassian.webresource.api.data.PluginDataResource;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class DefaultWebResourceSet
implements WebResourceSet {
    private final List<Container> resources;
    private final List<PluginDataResource> data;
    private final boolean complete;
    private final RequestState requestState;
    private final Config config;
    private final List<ResourceUrl> resourceUrls;

    public DefaultWebResourceSet(RequestState requestState, List<PluginDataResource> data, List<ResourceUrl> resourceUrls, boolean complete, Config config) {
        this.requestState = requestState;
        this.data = data;
        this.complete = complete;
        this.config = config;
        this.resourceUrls = resourceUrls;
        this.resources = new LinkedList<Container>();
        for (ResourceUrl resourceUrl : resourceUrls) {
            DefaultPluginUrlResource pluginUrlResource;
            String type = resourceUrl.getType();
            if ("js".equals(type)) {
                pluginUrlResource = new DefaultPluginJsResource(resourceUrl);
            } else if ("css".equals(type)) {
                pluginUrlResource = new DefaultPluginCssResource(resourceUrl);
            } else {
                throw new RuntimeException("unsupported extension " + type);
            }
            this.resources.add(new Container(resourceUrl, pluginUrlResource));
        }
    }

    public Iterable<WebResource> getResources() {
        LinkedList<PluginDataResource> webResources = new LinkedList<PluginDataResource>(this.data);
        for (Container resource : this.resources) {
            webResources.add((PluginDataResource)resource.getPluginUrlResource());
        }
        return webResources;
    }

    public <T extends WebResource> Iterable<T> getResources(Class<T> clazz) {
        return Iterables.filter(this.getResources(), (Predicate)Predicates.instanceOf(clazz));
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void writeHtmlTags(Writer writer, UrlMode urlMode) {
        this.writeHtmlTags(writer, urlMode, (Predicate<WebResource>)Predicates.alwaysTrue());
    }

    public void writeHtmlTags(Writer writer, UrlMode urlMode, Predicate<WebResource> predicate) {
        this.writeHtmlTags(writer, urlMode, predicate, (Predicate<ResourceUrl>)Predicates.alwaysTrue());
    }

    public void writePrefetchLinks(Writer writer, UrlMode urlMode) {
        this.writeFormattedResources(writer, urlMode, (Predicate<Container>)Predicates.alwaysTrue(), Collections.singletonList(PrefetchLinkWebResource.FORMATTER), true);
    }

    public void writeHtmlTags(Writer writer, UrlMode urlMode, Predicate<WebResource> predicate, Predicate<ResourceUrl> legacyPredicate) {
        this.writeSyncResources(writer);
        try {
            new DataTagWriter().write(writer, Iterables.filter(this.data, predicate));
        }
        catch (IOException ex) {
            Support.LOGGER.error("IOException encountered rendering data tags", (Throwable)ex);
        }
        List<WebResourceFormatter> formatters = Arrays.asList(new CssWebResource(this.config.amdEnabled()), new JavascriptWebResource(this.config.amdEnabled()));
        this.writeFormattedResources(writer, urlMode, new ContainerPredicate(predicate, legacyPredicate), formatters, false);
    }

    public List<ResourceUrl> getResourceUrls() {
        return Lists.newArrayList(this.resourceUrls);
    }

    private void writeFormattedResources(Writer writer, UrlMode urlMode, Predicate<Container> predicate, List<WebResourceFormatter> webResourceFormatters, boolean writingPrefetchLinks) {
        LinkedList<Container> localCopyOfResources = new LinkedList<Container>();
        for (Container resource : this.resources) {
            if (!predicate.apply((Object)resource)) continue;
            localCopyOfResources.add(resource);
        }
        boolean isDeferJsAttributeEnabled = this.config.isDeferJsAttributeEnabled();
        for (WebResourceFormatter formatter : webResourceFormatters) {
            Iterator iter = localCopyOfResources.iterator();
            while (iter.hasNext()) {
                Container resource = (Container)iter.next();
                if (!formatter.matches(resource.getResourceUrl().getName())) continue;
                this.writeResourceTag(urlMode, resource, formatter, writer, isDeferJsAttributeEnabled, writingPrefetchLinks);
                iter.remove();
            }
        }
        for (Container resource : localCopyOfResources) {
            this.writeContentAndSwallowErrors(writer, "<!-- Error loading resource \"", resource.getResourceUrl().getKey(), "\".  No resource formatter matches \"", resource.getResourceUrl().getName(), "\" -->\n");
        }
    }

    private void writeSyncResources(final Writer writer) {
        Optional<DefaultWebResourceSet> syncSet = this.requestState.getSyncResourceSet();
        if (syncSet.isPresent()) {
            Stream resources = syncSet.get().getResourceUrls().stream().flatMap(resourceUrl -> resourceUrl.getResources(this.requestState.getCache()).stream());
            List resourceContents = resources.filter(resource -> {
                boolean isJS = resource.getNameType().equals("js");
                if (!isJS) {
                    Support.LOGGER.warn("'" + resource.getFullName() + "' resource has been filtered and will not show up on the page. Currently, only JS files are supported for sync resources.");
                }
                return isJS;
            }).map(resource -> ResourceServingHelpers.transform(this.requestState.getGlobals(), new LinkedHashSet<String>(Collections.singletonList(resource.getParent().getKey())), null, resource, resource.getParams(), true)).collect(Collectors.toList());
            if (resourceContents.size() > 0) {
                try {
                    OutputStream out = new OutputStream(){

                        @Override
                        public void write(int b) throws IOException {
                            writer.write(b);
                        }
                    };
                    writer.write("<script>");
                    for (Content content : resourceContents) {
                        content.writeTo(out, false);
                        writer.write("\n");
                    }
                    writer.write("</script>\n");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.requestState.markSyncResourcesAsWritten();
        }
    }

    private void writeResourceTag(UrlMode urlMode, Container resource, WebResourceFormatter formatter, Writer writer, boolean isDeferJsAttributeEnabled, boolean writingPrefetchLinks) {
        String formattedResource;
        PluginUrlResource urlResource = resource.getPluginUrlResource();
        if (formatter instanceof JavascriptWebResource) {
            Map<String, String> params = resource.getResourceUrl().getParams();
            LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>(urlResource.getParams().all());
            if (this.config.useAsyncAttributeForScripts()) {
                params.put("async", "true");
                attributes.put("async", "");
            }
            attributes.put("data-initially-rendered", "");
            formattedResource = ((JavascriptWebResource)formatter).formatResource(urlResource.getStaticUrl(urlMode), attributes, isDeferJsAttributeEnabled);
        } else {
            formattedResource = formatter.formatResource(urlResource.getStaticUrl(urlMode), urlResource.getParams().all());
        }
        if (!writingPrefetchLinks && this.config.isBatchContentTrackingEnabled()) {
            formattedResource = BatchResourceContentsWebFormatter.insertBatchResourceContents(resource, formattedResource);
        }
        this.writeContentAndSwallowErrors(writer, formattedResource);
    }

    private void writeContentAndSwallowErrors(Writer writer, String ... contents) {
        try {
            for (String content : contents) {
                writer.write(content);
            }
        }
        catch (IOException ex) {
            Support.LOGGER.error("IOException encountered rendering resource", (Throwable)ex);
        }
    }

    public static class Container {
        private final ResourceUrl resourceUrl;
        private final PluginUrlResource pluginUrlResource;

        public Container(ResourceUrl resourceUrl, PluginUrlResource pluginUrlResource) {
            this.resourceUrl = resourceUrl;
            this.pluginUrlResource = pluginUrlResource;
        }

        public PluginUrlResource getPluginUrlResource() {
            return this.pluginUrlResource;
        }

        public ResourceUrl getResourceUrl() {
            return this.resourceUrl;
        }
    }

    private static class ContainerPredicate
    implements Predicate<Container> {
        private final Predicate<WebResource> resourcePredicate;
        private final Predicate<ResourceUrl> legacyPredicate;

        public ContainerPredicate(Predicate<WebResource> resourcePredicate, Predicate<ResourceUrl> legacyPredicate) {
            this.resourcePredicate = resourcePredicate;
            this.legacyPredicate = legacyPredicate;
        }

        public boolean apply(@Nullable Container container) {
            return container != null && this.resourcePredicate.apply((Object)container.getPluginUrlResource()) && this.legacyPredicate.apply((Object)container.getResourceUrl());
        }
    }
}

