/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.util.Assertions;
import com.atlassian.plugin.webresource.DefaultResourceBatchingConfiguration;
import com.atlassian.plugin.webresource.DefaultWebResourceFilter;
import com.atlassian.plugin.webresource.PluginResourceLocator;
import com.atlassian.plugin.webresource.ResourceBatchingConfiguration;
import com.atlassian.plugin.webresource.ResourceDependencyResolver;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.assembler.DefaultPageBuilderService;
import com.atlassian.plugin.webresource.assembler.DefaultWebResourceAssemblerFactory;
import com.atlassian.plugin.webresource.assembler.DefaultWebResourceSet;
import com.atlassian.plugin.webresource.assembler.LegacyPageBuilderService;
import com.atlassian.plugin.webresource.assembler.UrlModeUtils;
import com.atlassian.plugin.webresource.impl.Globals;
import com.atlassian.webresource.api.UrlMode;
import com.atlassian.webresource.api.WebResourceFilter;
import com.atlassian.webresource.api.WebResourceManager;
import com.atlassian.webresource.api.WebResourceUrlProvider;
import com.atlassian.webresource.api.assembler.AssembledResources;
import com.atlassian.webresource.api.assembler.RequiredResources;
import com.atlassian.webresource.api.assembler.WebResource;
import com.atlassian.webresource.api.assembler.WebResourceAssembler;
import com.atlassian.webresource.api.assembler.WebResourceAssemblerFactory;
import com.atlassian.webresource.api.assembler.WebResourceSet;
import com.google.common.base.Predicates;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

public class WebResourceManagerImpl
implements WebResourceManager {
    protected final LegacyPageBuilderService pageBuilderService;
    @Deprecated
    protected final WebResourceIntegration webResourceIntegration;
    private final WebResourceAssemblerFactory webResourceAssemblerFactory;
    private final WebResourceUrlProvider webResourceUrlProvider;

    public WebResourceManagerImpl(Globals globals, WebResourceIntegration webResourceIntegration, WebResourceUrlProvider webResourceUrlProvider) {
        this(globals, webResourceIntegration, webResourceUrlProvider, new DefaultResourceBatchingConfiguration());
    }

    public WebResourceManagerImpl(Globals globals, WebResourceIntegration webResourceIntegration, WebResourceUrlProvider webResourceUrlProvider, ResourceBatchingConfiguration batchingConfiguration) {
        this(new DefaultWebResourceAssemblerFactory(globals), null, webResourceIntegration, webResourceUrlProvider, null);
    }

    public WebResourceManagerImpl(WebResourceAssemblerFactory webResourceAssemblerFactory, PluginResourceLocator pluginResourceLocator, WebResourceIntegration webResourceIntegration, WebResourceUrlProvider webResourceUrlProvider, ResourceBatchingConfiguration batchingConfiguration) {
        this(webResourceAssemblerFactory, new DefaultPageBuilderService(webResourceIntegration, webResourceAssemblerFactory), null, webResourceIntegration, webResourceUrlProvider, null, null);
    }

    public WebResourceManagerImpl(WebResourceAssemblerFactory webResourceAssemblerFactory, LegacyPageBuilderService pageBuilderService, PluginResourceLocator pluginResourceLocator, WebResourceIntegration webResourceIntegration, WebResourceUrlProvider webResourceUrlProvider, ResourceBatchingConfiguration batchingConfiguration, ResourceDependencyResolver resourceDependencyResolver) {
        this.webResourceAssemblerFactory = (WebResourceAssemblerFactory)Assertions.notNull((String)"webResourceAssemblerFactory", (Object)webResourceAssemblerFactory);
        this.pageBuilderService = (LegacyPageBuilderService)Assertions.notNull((String)"pageBuilderService", (Object)pageBuilderService);
        this.webResourceIntegration = (WebResourceIntegration)Assertions.notNull((String)"webResourceIntegration", (Object)webResourceIntegration);
        this.webResourceUrlProvider = (WebResourceUrlProvider)Assertions.notNull((String)"webResourceUrlProvider", (Object)webResourceUrlProvider);
    }

    public void requireResource(String moduleCompleteKey) {
        this.getRequestLocalRequiredResources().requireWebResource(moduleCompleteKey);
    }

    public void requireResourcesForContext(String context) {
        this.getRequestLocalRequiredResources().requireContext(context);
    }

    public void includeResources(Iterable<String> moduleCompleteKeys, Writer writer, UrlMode urlMode) {
        WebResourceAssembler webResourceAssembler = this.createSuperbatchingDisabledWebResourceAssembler();
        for (String moduleCompleteKey : moduleCompleteKeys) {
            webResourceAssembler.resources().requireWebResource(moduleCompleteKey);
        }
        WebResourceSet webResourceSet = webResourceAssembler.assembled().drainIncludedResources();
        webResourceSet.writeHtmlTags(writer, UrlModeUtils.convert(urlMode));
    }

    public void includeResources(Writer writer, UrlMode urlMode) {
        this.includeResources(writer, urlMode, new DefaultWebResourceFilter());
    }

    public void includeResources(Writer writer, UrlMode urlMode, WebResourceFilter webResourceFilter) {
        this.writeIncludedResources(writer, urlMode, webResourceFilter);
        this.clear();
    }

    public String getRequiredResources(UrlMode urlMode) {
        return this.getRequiredResources(urlMode, new DefaultWebResourceFilter());
    }

    public String getRequiredResources(UrlMode urlMode, WebResourceFilter filter) {
        return this.writeIncludedResources(new StringWriter(), urlMode, filter).toString();
    }

    protected String getRequiredResources(UrlMode urlMode, WebResourceFilter webResourceFilter, Set<String> excludedResourceKeys, List<String> excludedContexts) {
        return this.writeIncludedResources(new StringWriter(), urlMode, webResourceFilter, excludedResourceKeys, excludedContexts).toString();
    }

    private <W extends Writer> W writeIncludedResources(W writer, UrlMode urlMode, WebResourceFilter filter) {
        return this.writeIncludedResources(writer, urlMode, filter, Collections.emptySet(), Collections.emptyList());
    }

    private <W extends Writer> W writeIncludedResources(W writer, UrlMode urlMode, WebResourceFilter filter, Set<String> excludedResourceKeys, List<String> excludedContexts) {
        if (null != excludedResourceKeys && !excludedResourceKeys.isEmpty() && null != excludedContexts && !excludedContexts.isEmpty()) {
            this.getRequestLocalRequiredResources().exclude(excludedResourceKeys, new HashSet<String>(excludedContexts));
        }
        DefaultWebResourceSet webResourceSet = (DefaultWebResourceSet)this.getRequestLocalAssembledResources().peek();
        webResourceSet.writeHtmlTags(writer, UrlModeUtils.convert(urlMode), (Predicate<WebResource>)Predicates.alwaysTrue(), input -> filter.matches(input.getName()));
        return writer;
    }

    public void requireResource(String moduleCompleteKey, Writer writer, UrlMode urlMode) {
        WebResourceAssembler webResourceAssembler = this.createSuperbatchingDisabledWebResourceAssembler();
        webResourceAssembler.resources().requireWebResource(moduleCompleteKey);
        WebResourceSet webResourceSet = webResourceAssembler.assembled().drainIncludedResources();
        webResourceSet.writeHtmlTags(writer, UrlModeUtils.convert(urlMode));
    }

    public String getResourceTags(String moduleCompleteKey, UrlMode urlMode) {
        StringWriter writer = new StringWriter();
        this.requireResource(moduleCompleteKey, writer, urlMode);
        return writer.toString();
    }

    protected AssembledResources getRequestLocalAssembledResources() {
        return this.pageBuilderService.assembler().assembled();
    }

    protected RequiredResources getRequestLocalRequiredResources() {
        return this.pageBuilderService.assembler().resources();
    }

    private void clear() {
        this.pageBuilderService.clearRequestLocal();
    }

    private WebResourceAssembler createSuperbatchingDisabledWebResourceAssembler() {
        return this.webResourceAssemblerFactory.create().includeSuperbatchResources(false).build();
    }
}

