/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.assembler;

import com.atlassian.plugin.webresource.assembler.DefaultWebResourceAssembler;
import com.atlassian.plugin.webresource.impl.Globals;
import com.atlassian.plugin.webresource.impl.RequestState;
import com.atlassian.plugin.webresource.impl.UrlBuildingStrategy;
import com.atlassian.webresource.api.assembler.WebResourceAssembler;
import com.atlassian.webresource.api.assembler.WebResourceAssemblerBuilder;
import java.util.Optional;

public class DefaultWebResourceAssemblerBuilder
implements WebResourceAssemblerBuilder {
    private final Globals globals;
    private Optional<Boolean> isSuperBatchingEnabled = Optional.empty();
    private Optional<Boolean> isSyncBatchingEnabled = Optional.empty();
    private Optional<Boolean> isAutoIncludeFrontendRuntimeEnabled = Optional.empty();

    public DefaultWebResourceAssemblerBuilder(Globals globals) {
        this.globals = globals;
    }

    public WebResourceAssembler build() {
        UrlBuildingStrategy urlStrat = UrlBuildingStrategy.normal();
        boolean autoIncludeFrontendRuntime = this.isAutoIncludeFrontendRuntimeEnabled.orElse(true);
        RequestState requestState = new RequestState(this.globals, urlStrat, autoIncludeFrontendRuntime);
        DefaultWebResourceAssembler assembler = new DefaultWebResourceAssembler(requestState, this.globals);
        this.isSyncBatchingEnabled.ifPresent(requestState::setSyncbatchEnabled);
        this.isSuperBatchingEnabled.ifPresent(requestState.getSuperbatchConfiguration()::setEnabled);
        return assembler;
    }

    @Deprecated
    public WebResourceAssemblerBuilder includeSuperbatchResources(boolean include) {
        this.isSuperBatchingEnabled = Optional.of(include);
        return this;
    }

    public WebResourceAssemblerBuilder includeSyncbatchResources(boolean include) {
        this.isSyncBatchingEnabled = Optional.of(include);
        return this;
    }

    public WebResourceAssemblerBuilder autoIncludeFrontendRuntime(boolean include) {
        this.isAutoIncludeFrontendRuntimeEnabled = Optional.of(include);
        return this;
    }
}

