/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.condition;

import com.atlassian.plugin.webresource.condition.DecoratingCondition;
import com.atlassian.plugin.webresource.condition.MetricsUtil;
import com.atlassian.plugin.webresource.impl.UrlBuildingStrategy;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.webresource.api.QueryParams;
import com.atlassian.webresource.api.url.UrlBuilder;
import com.atlassian.webresource.spi.condition.UrlReadingCondition;
import java.util.Map;

public class DecoratingUrlReadingCondition
implements DecoratingCondition {
    protected final UrlReadingCondition urlReadingCondition;
    protected final Map<String, String> params;
    private final String pluginKey;
    private final String conditionClassName;

    public DecoratingUrlReadingCondition(UrlReadingCondition urlReadingCondition, Map<String, String> params, String pluginKey, String conditionClassName) {
        this.urlReadingCondition = urlReadingCondition;
        this.params = params;
        this.pluginKey = pluginKey;
        this.conditionClassName = conditionClassName;
    }

    @Override
    public void addToUrl(UrlBuilder urlBuilder, UrlBuildingStrategy urlBuilderStrategy) {
        urlBuilderStrategy.addToUrl(this.urlReadingCondition, urlBuilder);
    }

    @Override
    public boolean shouldDisplay(QueryParams params) {
        try (Ticker ignored = MetricsUtil.startWebConditionProfilingTimer(this.pluginKey, this.conditionClassName);){
            boolean bl = this.urlReadingCondition.shouldDisplay(params);
            return bl;
        }
    }

    @Override
    public DecoratingCondition invertCondition() {
        return new DecoratingCondition(){

            @Override
            public void addToUrl(UrlBuilder urlBuilder, UrlBuildingStrategy urlBuilderStrategy) {
                DecoratingUrlReadingCondition.this.addToUrl(urlBuilder, urlBuilderStrategy);
            }

            @Override
            public boolean shouldDisplay(QueryParams params) {
                return !DecoratingUrlReadingCondition.this.shouldDisplay(params);
            }

            @Override
            public DecoratingCondition invertCondition() {
                return DecoratingUrlReadingCondition.this;
            }
        };
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public UrlReadingCondition getUrlReadingCondition() {
        return this.urlReadingCondition;
    }
}

