package com.atlassian.sal.api;

import java.io.File;
import java.util.Date;

/**
 * Component for looking up application properties specific to their web interface
 *
 * @since 2.0
 */
public interface ApplicationProperties
{
    /**
     * Get the base URL of the current application.
     *
     * @return the current application's base URL
     * @deprecated since 2.10. This implementation is application-specific, and unreliable for a cross product plugin.
     *   Use {@link #getBaseUrl(UrlMode)} instead.
     */
    @Deprecated
    String getBaseUrl();

    /**
     * Get the base URL of the current application, with respect to the given {@link UrlMode}. This varies as follows:
     * <ul>
     *     <li>If {@link UrlMode#CANONICAL} return the configured base URL.</li>
     *     <li>If {@link UrlMode#ABSOLUTE} return either the base URL of a request in the current scope, or the
     *       configured base URL if there is no such request.</li>
     *     <li>If {@link UrlMode#RELATIVE} return either the context path of a request in the current scope, or the
     *       configured context path if there is no such request.</li>
     *     <li>If {@link UrlMode#RELATIVE_CANONICAL} return the configured context path.</li>
     *     <li>If {@link UrlMode#AUTO} return either a relative URL if there is a request in the current scope, or the
     *       canonical URL if there is no such request.</li>
     * </ul>
     * @param urlMode the UrlMode to use.
     * @return the current application's base URL.
     */
    String getBaseUrl(UrlMode urlMode);

    /**
     * @return the displayable name of the application
     */
    String getDisplayName();

    /**
     * @return the version of the application
     */
    String getVersion();

    /**
     * @return the build date of the application
     */
    Date getBuildDate();

    /**
     * @return the build number of the application, must be parsable by {@link Long#parseLong(String)}
     */
    String getBuildNumber();


    /**
     * @return the home directory of the application or null if none is defined
     */
    File getHomeDirectory();

    /**
     * Get the value of an application property by its key.
     * @param key The Key of the property to retrieve.
     * @return The value of the property or Null if the property does not exist
     * @deprecated As of SAL 2.7.
     */
    @Deprecated
    String getPropertyValue(String key);
}
