/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pageobjects.elements;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.TimedElement;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.google.common.base.Preconditions;

public final class DataAttributeFinder {
    private static final String DATA_PREFIX = "data-";
    private final PageElement pageElement;
    private final Timed timed;

    public static DataAttributeFinder query(PageElement element) {
        return new DataAttributeFinder(element);
    }

    private DataAttributeFinder(PageElement pageElement) {
        this.pageElement = (PageElement)Preconditions.checkNotNull((Object)pageElement);
        this.timed = new Timed();
    }

    public String getDataAttribute(String dataAttributeName) {
        return this.pageElement.getAttribute(DATA_PREFIX + dataAttributeName);
    }

    public boolean hasDataAttribute(String dataAttributeName, String value) {
        return this.pageElement.hasAttribute(DATA_PREFIX + dataAttributeName, value);
    }

    public Timed timed() {
        return this.timed;
    }

    public class Timed {
        private final TimedElement timedElement;

        private Timed() {
            this.timedElement = DataAttributeFinder.this.pageElement.timed();
        }

        public TimedQuery<String> getDataAttribute(String dataAttrName) {
            return this.timedElement.getAttribute(DataAttributeFinder.DATA_PREFIX + dataAttrName);
        }

        public TimedCondition hasDataAttribute(String dataAttrName, String dataAttrValue) {
            return this.timedElement.hasAttribute(DataAttributeFinder.DATA_PREFIX + dataAttrName, dataAttrValue);
        }
    }
}

