/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pageobjects.elements;

import com.atlassian.pageobjects.elements.Option;
import com.google.common.base.Function;

public final class Options {
    public static IdOption id(String id) {
        return new IdOption(id);
    }

    public static ValueOption value(String value) {
        return new ValueOption(value);
    }

    public static TextOption text(String text) {
        return new TextOption(text);
    }

    public static Option full(String id, String value, String text) {
        return new FullOption(id, value, text);
    }

    public static Function<Option, String> getValue() {
        return new Function<Option, String>(){

            public String apply(Option option) {
                return option.value();
            }
        };
    }

    public static Function<Option, String> getId() {
        return new Function<Option, String>(){

            public String apply(Option option) {
                return option.id();
            }
        };
    }

    public static Function<Option, String> getText() {
        return new Function<Option, String>(){

            public String apply(Option option) {
                return option.text();
            }
        };
    }

    public static class FullOption
    extends AbstractOption {
        FullOption(String id, String value, String text) {
            super(id, value, text);
        }
    }

    public static class TextOption
    extends AbstractOption {
        TextOption(String text) {
            super(null, null, text);
        }
    }

    public static class ValueOption
    extends AbstractOption {
        ValueOption(String value) {
            super(null, value, null);
        }
    }

    public static class IdOption
    extends AbstractOption {
        IdOption(String id) {
            super(id, null, null);
        }
    }

    static abstract class AbstractOption
    implements Option {
        private final String id;
        private final String value;
        private final String text;

        public AbstractOption(String id, String value, String text) {
            if (value == null && id == null && text == null) {
                throw new IllegalArgumentException("One of the option identifiers must be non-null");
            }
            this.value = value;
            this.id = id;
            this.text = text;
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public String text() {
            return this.text;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!Option.class.isAssignableFrom(obj.getClass())) {
                return false;
            }
            AbstractOption other = (AbstractOption)obj;
            if (this.id != null && !this.id.equals(other.id)) {
                return false;
            }
            if (this.value != null && !this.value.equals(other.value)) {
                return false;
            }
            return this.text == null || this.text.equals(other.text);
        }

        public int hashCode() {
            int result = this.id != null ? this.id.hashCode() : 0;
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            result = 31 * result + (this.text != null ? this.text.hashCode() : 0);
            return result;
        }
    }
}

