/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pageobjects.elements;

import com.atlassian.annotations.Internal;
import com.atlassian.util.concurrent.Nullable;
import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;

@Internal
public interface WebDriverLocatable {
    @Nullable
    public By getLocator();

    @Nullable
    public WebDriverLocatable getParent();

    @Deprecated
    @Nonnull
    public SearchContext waitUntilLocated(@Nonnull WebDriver var1, int var2) throws NoSuchElementException;

    @Deprecated
    public boolean isPresent(@Nonnull WebDriver var1, int var2);

    @Nonnull
    public SearchContext waitUntilLocated(@Nonnull WebDriver var1, @Nonnull LocateTimeout var2) throws NoSuchElementException;

    public boolean isPresent(@Nonnull WebDriver var1, @Nonnull LocateTimeout var2);

    public static final class LocateTimeout {
        private final long timeout;
        private final long pollInterval;

        public static Builder builder() {
            return new Builder();
        }

        public static LocateTimeout zero() {
            return new LocateTimeout(0L, 1L);
        }

        private LocateTimeout(long timeout, long pollInterval) {
            Preconditions.checkArgument((timeout >= 0L ? 1 : 0) != 0, (Object)"timeout >= 0");
            Preconditions.checkArgument((pollInterval > 0L ? 1 : 0) != 0, (Object)"pollInterval > 0");
            this.timeout = timeout;
            this.pollInterval = pollInterval;
        }

        public long timeout() {
            return this.timeout;
        }

        public long pollInterval() {
            return this.pollInterval;
        }

        public static final class Builder {
            private long timeout;
            private long pollInterval = 100L;

            public Builder timeout(long millis) {
                this.timeout = millis;
                return this;
            }

            public Builder timeout(long amount, TimeUnit unit) {
                return this.timeout(unit.toMillis(amount));
            }

            public Builder pollInterval(long millis) {
                this.pollInterval = millis;
                return this;
            }

            public Builder pollInterval(long amount, TimeUnit unit) {
                return this.pollInterval(unit.toMillis(amount));
            }

            public LocateTimeout build() {
                return new LocateTimeout(this.timeout, this.pollInterval);
            }
        }
    }
}

