/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.selenium.visualcomparison.v2.settings;

import com.atlassian.annotations.ExperimentalApi;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@ExperimentalApi
@Immutable
public final class Resolution
implements Comparable<Resolution> {
    public static final Resolution R1024_768 = new Resolution(1024, 768);
    private static final String SEPARATOR = "x";
    private final int width;
    private final int height;

    public Resolution(int width, int height) {
        Preconditions.checkArgument((width > 0 ? 1 : 0) != 0, (Object)"Width must be >0");
        Preconditions.checkArgument((height > 0 ? 1 : 0) != 0, (Object)"Height must be >0");
        this.width = width;
        this.height = height;
    }

    public static Resolution parse(@Nonnull String resolutionString) {
        String[] parts = ((String)Preconditions.checkNotNull((Object)resolutionString, (Object)"resolutionString")).split(SEPARATOR);
        try {
            Preconditions.checkArgument((parts.length == 2 ? 1 : 0) != 0, (Object)("More than one 'x' in " + resolutionString));
            return new Resolution(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("'%s' is not a valid screen resolution representation. Valid values are in form <width>x<height>", resolutionString));
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    @Override
    public int compareTo(@Nonnull Resolution that) {
        Preconditions.checkNotNull((Object)that, (Object)"that");
        int widthCompare = Integer.valueOf(this.width).compareTo(that.width);
        if (widthCompare != 0) {
            return widthCompare;
        }
        return Integer.valueOf(this.height).compareTo(that.height);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Resolution that = (Resolution)o;
        return this.width == that.width && this.height == that.height;
    }

    public int hashCode() {
        int result = this.width;
        result = 31 * result + this.height;
        return result;
    }

    @Nonnull
    public String toString() {
        return this.width + SEPARATOR + this.height;
    }
}

